/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.extension.impl;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import com.ebmwebsourcing.wsstar.notification.extension.api.XsltStyleSheetType;

/**
 * This class implements {@link XsltStyleSheetType} java interface respect to
 * EASYWSDL Library model.
 * 
 * @author Thierry Déjean - eBM Websourcing
 */
public class XsltStyleSheetTypeImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.notification.jaxbextension.types.XsltStyleSheetType> implements
		XsltStyleSheetType {

	private static final long serialVersionUID = 1L;

	/**
 	 * Constructor (follow EASYWSDL model)
 	 *
	 * @param model
	 * @param parent
	 */
	public XsltStyleSheetTypeImpl(com.ebmwebsourcing.wsstar.notification.jaxbextension.types.XsltStyleSheetType model,
			AbstractSchemaElementImpl<?> parent) {
		super(model,parent);
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.XsltStyleSheetType#getStyleSheet()
	 */
	public Element getStyleSheet() {		
		Element result = null;				
		Object storedStyleSheet = this.model.getAny();
		
		if ((storedStyleSheet instanceof Element) && 
				(((Element)storedStyleSheet).getLocalName().compareTo("stylesheet") == 0) &&
				(((Element)storedStyleSheet).getNamespaceURI().compareTo("http://www.w3.org/1999/XSL/Transform") == 0)){
			result = (Element)storedStyleSheet;
		}								
		return result;
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.XsltStyleSheetType#setStyleSheet(org.w3c.dom.Element)
	 */
	public void setStyleSheet(Element styleSheet) {
		this.model.setAny((Node) styleSheet);
	}

}
