/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.extension.inout;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.w3c.dom.Document;

import com.ebmwebsourcing.wsstar.notification.extension.api.ContextPolicyType;
import com.ebmwebsourcing.wsstar.notification.extension.api.ProcessPolicyType;
import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.api.TerminationTimeType;
import com.ebmwebsourcing.wsstar.notification.extension.api.XsltStyleSheetType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnExtensionConstants;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionJAXBContext;

/**
 * This class provides a collection of methods that enable conversion of a
 * "custom java type" object defined in the xml schema file named 
 * "specifictypesFornotifications.xsd" into a {@link Document} object.
 * This conversion uses JAXB "marshalling" mechanism
 * 
 * @author Thierry Déjean -eBM WebSourcing
 */
public class WSNotificationExtensionWriter {
	
	private static Logger log = Logger.getLogger(WSNotificationExtensionWriter.class.getName());
	private WSNotificationExtensionJAXBContext notifJaxbContext = null;

	/**
	 * Constructor. Initialize private attributes
	 * 
	 * @throws WSNotificationExtensionException
	 */
	private WSNotificationExtensionWriter() {
		try {
			this.notifJaxbContext = new WSNotificationExtensionJAXBContext();
		} catch (final Exception e) {
			log.log(Level.WARNING, "WsNotificationWriter initialisation failed !", e);
		}
	}
	
	/**
	 * SingletonHolder is loaded on the first execution of Singleton.getInstance() 
	 * or the first access to SingletonHolder.INSTANCE, not before.
	 */
    private static class WSNotificationExtensionWriterHolder {     	
		private final static WSNotificationExtensionWriter INSTANCE = new WSNotificationExtensionWriter();
	}
    
    /**
	 * Return an unique - respect to the Singleton design pattern - instance  
	 * of the {@link WSNotificationExtensionJAXBContext} class.  
	 * 
	 * @return a unique WSNotificationFactory instance. 
	 */
	public static WSNotificationExtensionWriter getInstance() {
		return WSNotificationExtensionWriterHolder.INSTANCE;
	}
	
	/**
	 * Provides an empty {@link Document} instance that will be used to return the JAXB's marshalling process result. See JAXB "How to" and tutorials - available on the web - for more details.
	 * 
	 * @return a new {@link Document} instance.
	 * @throws WSNotificationExtensionException
	 */
	private Document getEmptyDomDocument() throws WSNotificationExtensionException {
		Document result = null;
		try {
			final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			dbf.setNamespaceAware(true);
			final DocumentBuilder db = dbf.newDocumentBuilder();
			result = db.newDocument();
		} catch (final ParserConfigurationException e) {
			throw new WSNotificationExtensionException("Failed to build XML binding from SchemaImpl descriptor Java classes", e);
		}
		return result;
	}
	/**
     * marchall a {@link SOAParameterType} object.
     * 
     * @param notifyObj {@link SOAParameterType} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link SOAParameterType} Java type 
     * @throws WSNotificationExtensionException
     */
	public Document writeSOAParameterType(SOAParameterType javaObj) throws WSNotificationExtensionException{
		Document result = null;

		try {
			result = this.getEmptyDomDocument();

			final Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
			final JAXBElement<com.ebmwebsourcing.wsstar.notification.jaxbextension.types.SOAParameterType> jaxbTypeObj = new JAXBElement<com.ebmwebsourcing.wsstar.notification.jaxbextension.types.SOAParameterType>(WsnExtensionConstants.SOA_PARAMETER_QNAME,
					com.ebmwebsourcing.wsstar.notification.jaxbextension.types.SOAParameterType.class, (com.ebmwebsourcing.wsstar.notification.jaxbextension.types.SOAParameterType) ((AbstractSchemaElementImpl<?>) javaObj).getModel());

			marshaller.marshal(jaxbTypeObj, result);

		} catch (final JAXBException ex) {
			throw new WSNotificationExtensionException("Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
		}
		return result;
	}
	
	/**
     * marchall a {@link ResourcesUuidType} object.
     * 
     * @param notifyObj {@link ResourcesUuidType} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link ResourcesUuidType} Java type 
     * @throws WSNotificationExtensionException
     */
	public Document writeResourcesUuidType(ResourcesUuidType javaObj) throws WSNotificationExtensionException{
		Document result = null;
		try {

			result = this.getEmptyDomDocument();

			final Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
			final JAXBElement<com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ResourcesUuidType> jaxbTypeObj = new JAXBElement<com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ResourcesUuidType>(WsnExtensionConstants.RESOURCES_UUID_QNAME,
					com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ResourcesUuidType.class, (com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ResourcesUuidType) ((AbstractSchemaElementImpl<?>) javaObj).getModel());

			marshaller.marshal(jaxbTypeObj, result);

		} catch (final JAXBException ex) {
			throw new WSNotificationExtensionException("Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
		}
		return result;
	}
	
	/**
     * marchall a {@link XsltStyleSheetType} object.
     * 
     * @param notifyObj {@link XsltStyleSheetType} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link XsltStyleSheetType} Java type 
     * @throws WSNotificationExtensionException
     */
	public Document writeXsltStyleSheetType(XsltStyleSheetType javaObj) throws WSNotificationExtensionException{
		Document result = null;
		try {
			result = this.getEmptyDomDocument();

			final Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
			final JAXBElement<com.ebmwebsourcing.wsstar.notification.jaxbextension.types.XsltStyleSheetType> jaxbTypeObj = new JAXBElement<com.ebmwebsourcing.wsstar.notification.jaxbextension.types.XsltStyleSheetType>(WsnExtensionConstants.TRANSFORM_POLICY_QNAME,
					com.ebmwebsourcing.wsstar.notification.jaxbextension.types.XsltStyleSheetType.class, (com.ebmwebsourcing.wsstar.notification.jaxbextension.types.XsltStyleSheetType) ((AbstractSchemaElementImpl<?>) javaObj).getModel());

			marshaller.marshal(jaxbTypeObj, result);

		} catch (final JAXBException ex) {
			throw new WSNotificationExtensionException("Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
		}
		return result;
	}
	
	/**
     * marchall a {@link ProcessPolicyType} object.
     * 
     * @param notifyObj {@link ProcessPolicyType} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link ProcessPolicyType} Java type 
     * @throws WSNotificationExtensionException
     */
	public Document writeProcessPolicyType(ProcessPolicyType javaObj) throws WSNotificationExtensionException{
		Document result = null;
		try {
			result = this.getEmptyDomDocument();

			final Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
			final JAXBElement<com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ProcessPolicyType> jaxbTypeObj = new JAXBElement<com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ProcessPolicyType>(WsnExtensionConstants.PROCESS_POLICY_QNAME,
					com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ProcessPolicyType.class, (com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ProcessPolicyType) ((AbstractSchemaElementImpl<?>) javaObj).getModel());

			marshaller.marshal(jaxbTypeObj, result);

		} catch (final JAXBException ex) {
			throw new WSNotificationExtensionException("Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
		}
		return result;
	}
	
	/**
     * marchall a {@link ContextPolicyType} object.
     * 
     * @param notifyObj {@link ContextPolicyType} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link ContextPolicyType} Java type 
     * @throws WSNotificationExtensionException
     */
	public Document writeContextPolicyType(ContextPolicyType javaObj) throws WSNotificationExtensionException{
		Document result = null;
		try {
			result = this.getEmptyDomDocument();

			final Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
			final JAXBElement<com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ContextPolicyType> jaxbTypeObj = new JAXBElement<com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ContextPolicyType>(WsnExtensionConstants.CONTEXT_POLICY_QNAME,
					com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ContextPolicyType.class, (com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ContextPolicyType) ((AbstractSchemaElementImpl<?>) javaObj).getModel());

			marshaller.marshal(jaxbTypeObj, result);

		} catch (final JAXBException ex) {
			throw new WSNotificationExtensionException("Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
		}
		return result;
	}
	/**
     * marchall a {@link TerminationTimeType} object.
     * 
     * @param notifyObj {@link TerminationTimeType} Java object to marshall
     * @return {@link org.w3c.dom.Document} representation of the {@link TerminationTimeType} Java type 
     * @throws WSNotificationExtensionException
     */
	public Document writeTerminationTimeType(TerminationTimeType javaObj) throws WSNotificationExtensionException{
		Document result = null;
		try {
			result = this.getEmptyDomDocument();

			final Marshaller marshaller = this.notifJaxbContext.createWSNotificationMarshaller();
			final JAXBElement<com.ebmwebsourcing.wsstar.notification.jaxbextension.types.TerminationTimeType> jaxbTypeObj = new JAXBElement<com.ebmwebsourcing.wsstar.notification.jaxbextension.types.TerminationTimeType>(WsnExtensionConstants.TERMINATION_TIME_QNAME,
					com.ebmwebsourcing.wsstar.notification.jaxbextension.types.TerminationTimeType.class, (com.ebmwebsourcing.wsstar.notification.jaxbextension.types.TerminationTimeType) ((AbstractSchemaElementImpl<?>) javaObj).getModel());

			marshaller.marshal(jaxbTypeObj, result);

		} catch (final JAXBException ex) {
			throw new WSNotificationExtensionException("Failed to build XML binding from SchemaImpl descriptor Java classes", ex);
		}
		return result;
	}
}
