/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.extension.utils;

import java.util.List;

import javax.xml.bind.JAXBElement;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.impl.EndpointReferenceTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.WsnbConstants;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessageResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Message;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.QueryExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Renew;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionManagerRP;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionPolicyType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.NotificationMessageHolderTypeImpl;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationReader;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationWriter;
import com.ebmwebsourcing.wsstar.notification.definition.topics.api.TopicType;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.api.ContextPolicyType;
import com.ebmwebsourcing.wsstar.notification.extension.api.ProcessPolicyType;
import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.api.TerminationTimeType;
import com.ebmwebsourcing.wsstar.notification.extension.api.XsltStyleSheetType;
import com.ebmwebsourcing.wsstar.notification.extension.impl.ContextPolicyTypeImpl;
import com.ebmwebsourcing.wsstar.notification.extension.impl.ProcessPolicyTypeImpl;
import com.ebmwebsourcing.wsstar.notification.extension.impl.ResourcesUuidTypeImpl;
import com.ebmwebsourcing.wsstar.notification.extension.impl.SOAParameterTypeImpl;
import com.ebmwebsourcing.wsstar.notification.extension.impl.TerminationTimeTypeImpl;
import com.ebmwebsourcing.wsstar.notification.extension.impl.XsltStyleSheetTypeImpl;
import com.ebmwebsourcing.wsstar.notification.extension.inout.WSNotificationExtensionReader;
import com.ebmwebsourcing.wsstar.notification.extension.inout.WSNotificationExtensionWriter;

/**
 * This class provides a set of static methods that helps
 * to use all defined specific Types with WS-Notification
 * implementation (ws-notification-definition library).
 * 
 * It means that each time a "AnyType" xml fragment is
 * expected in the xml-schema files of WS-Notification
 * specifications, then the desired specific type can
 * be use instead. And following methods make it easier
 * to do    
 *  
 * @author Thierry Déjean - eBM Websourcing
 */
public class WsnSpecificTypeHelper {

	// ------------------------------------------------
	// ------- "Helpers" for SOAParameterType type ----
	// ------------------------------------------------

	// --- Pseudo Getters ---

	/**
	 * Private method that get - if the expected xml fragment exists -a {@link SOAParameterType}
	 * object from an {@link List} Of {@link Object}.  
	 * 
	 * @param listOfObj from which the xml representation is supposed to be found
	 * @return a {@link SOAParameterType} object
	 * @throws WSNotificationExtensionException
	 */
	private static SOAParameterType getSOAParameter(final List<Object> listOfObj) throws WSNotificationExtensionException{

		SOAParameterType result = null;

		if (listOfObj!= null) {
			for (final Object item : listOfObj) {
				if (item instanceof Element &&
						((Element)item).getLocalName().compareTo(WsnExtensionConstants.SOA_PARAMETER_QNAME.getLocalPart()) == 0 &&
						((Element)item).getNamespaceURI().compareTo(WsnExtensionConstants.SOA_PARAMETER_QNAME.getNamespaceURI()) == 0){

					final Document doc = ((Element)item).getOwnerDocument();
					doc.setDocumentURI(WsnExtensionConstants.WSNOTIFICATION_EXTENDED_TYPES_NAMESPACE);

					result = WSNotificationExtensionReader.getInstance().readSOAParameterType(doc);
				} 
				else if ((item instanceof JAXBElement<?>) &&
						(((JAXBElement<?>)item).getName().equals(WsnExtensionConstants.SOA_PARAMETER_QNAME)) &&
						(((JAXBElement<?>)item).getValue() instanceof 
								com.ebmwebsourcing.wsstar.notification.jaxbextension.types.SOAParameterType) ) {														
					result = new SOAParameterTypeImpl((com.ebmwebsourcing.wsstar.notification.jaxbextension.types.SOAParameterType)((JAXBElement<?>)item).getValue(),null);					
				}
			}
		}
		return result;
	}

	/**
	 * Method used to get {@link SOAParameterType} object from 
	 * {@link ReferenceParametersType} object
	 * 
	 * @param refParams {@link ReferenceParametersType} object (see WS-Addressing)
	 * @return {@link SOAParameterType} object
	 * @throws WSNotificationExtensionException
	 */
	public static SOAParameterType getSOAParameter(final ReferenceParametersType refParams) throws WSNotificationExtensionException{

		final List<Object> listObj =
			((com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.ReferenceParametersType)
					((AbstractSchemaElementImpl<?>)refParams).getModel()).getAny();
		return WsnSpecificTypeHelper.getSOAParameter(listObj);
	}

	/**
	 * Method used to get {@link SOAParameterType} object from 
	 * {@link QueryExpressionType} object
	 * 
	 * @param msgContent {@link QueryExpressionType} object
	 * @return {@link SOAParameterType} object
	 * @throws WSNotificationExtensionException
	 */
	public static SOAParameterType getSOAParameter(final QueryExpressionType msgContent) throws WSNotificationExtensionException{

		final List<Object> listObj =
			((com.ebmwebsourcing.wsstar.notification.definition.base.QueryExpressionType)
					((AbstractSchemaElementImpl<?>)msgContent).getModel()).getContent();
		return WsnSpecificTypeHelper.getSOAParameter(listObj);
	}

	// --- Pseudo Setters ---
	/**
	 * Private method that add an xml fragment representation of a {@link SOAParameterType}
	 * object to an {@link List} Of {@link Object}.  
	 * 
	 * @param soaParameter {@link SOAParameterType} object whom the xml representation must be set
	 * @param listOfObj in which the xml representation must be add
	 * @throws WSNotificationExtensionException
	 */
	private static void setSOAParameter(final SOAParameterType soaParameter,final List<Object> listOfObj) throws WSNotificationExtensionException{
		if(listOfObj != null){
			
			Object previousExistingObj = null; 
			
			for (final Object item : listOfObj) {
				if ((item instanceof Element &&
						((Element)item).getLocalName().compareTo(WsnExtensionConstants.SOA_PARAMETER_QNAME.getLocalPart()) == 0 &&
						((Element)item).getNamespaceURI().compareTo(WsnExtensionConstants.SOA_PARAMETER_QNAME.getNamespaceURI()) == 0) ||
						((item instanceof JAXBElement<?>) &&
								(((JAXBElement<?>)item).getName().equals(WsnExtensionConstants.SOA_PARAMETER_QNAME)) &&
								(((JAXBElement<?>)item).getValue() instanceof 
										com.ebmwebsourcing.wsstar.notification.jaxbextension.types.SOAParameterType))) {

					previousExistingObj = item;
					break;
				}
			}			
			if (previousExistingObj != null)
				listOfObj.remove(previousExistingObj);
									
			final Element eprAsElt = WSNotificationExtensionWriter.getInstance().writeSOAParameterType(soaParameter).getDocumentElement();
			listOfObj.add(eprAsElt);
		}
	}


	/**
	 * Method used to set an xml fragment representation of a {@link SOAParameterType} object into a 
	 * {@link QueryExpressionType} object
	 * 
	 * @param soaParameter {@link SOAParameterType} object whom the xml representation must be set
	 * @param msgContent {@link QueryExpressionType} object in which the xml representation must be set
	 * @throws WSNotificationExtensionException
	 */
	public static void setSOAParameter(final SOAParameterType soaParamObj ,final QueryExpressionType msgContent)  throws WSNotificationExtensionException{

		final List<Object> listObj =
			((com.ebmwebsourcing.wsstar.notification.definition.base.QueryExpressionType)
					((AbstractSchemaElementImpl<?>)msgContent).getModel()).getContent();

		WsnSpecificTypeHelper.setSOAParameter(soaParamObj, listObj);
	}

	/**
	 * Method used to set an xml fragment representation of a {@link SOAParameterType} object into a 
	 * {@link ReferenceParametersType} object
	 * 
	 * @param soaParameter {@link SOAParameterType} object whom the xml representation must be set
	 * @param msgContent {@link ReferenceParametersType} object in which the xml representation must be set
	 * @throws WSNotificationExtensionException
	 */
	public static void setSOAParameter(final SOAParameterType soaParamObj ,final ReferenceParametersType refParams) throws WSNotificationExtensionException{

		final List<Object> listObj =
			((com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.ReferenceParametersType)
					((AbstractSchemaElementImpl<?>)refParams).getModel()).getAny();

		WsnSpecificTypeHelper.setSOAParameter(soaParamObj, listObj);

	}

	// ------------------------------------------------------
	// ------- "Helpers" for EndpointReferenceType type -----
	// ------------------------------------------------------

	// --- Pseudo Getters ---

	/**
	 * Private method that get - if the expected xml fragment exists - a {@link EndpointReferenceType}
	 * object from an {@link List} Of {@link Object}.  
	 * 
	 * @param listOfObj from which the xml representation is supposed to be found
	 * @return a {@link EndpointReferenceType} object
	 * @throws WSNotificationExtensionException
	 */
	private static EndpointReferenceType getEndpointReference(final List<Object> listOfObj) throws WSAddressingException{
		EndpointReferenceType result = null;

		if (listOfObj!= null) {
			for (final Object item : listOfObj) {
				if (item instanceof Element &&
						((Element)item).getLocalName().compareTo(com.ebmwebsourcing.wsstar.addressing.definition.impl.Constants.ENDPOINT_REFERENCE_QNAME.getLocalPart()) == 0 &&
						((Element)item).getNamespaceURI().compareTo(com.ebmwebsourcing.wsstar.addressing.definition.impl.Constants.ENDPOINT_REFERENCE_QNAME.getNamespaceURI()) == 0){

					final Document doc = ((Element)item).getOwnerDocument();
					doc.setDocumentURI(com.ebmwebsourcing.wsstar.addressing.definition.impl.Constants.WSADDRESSING_NAMESPACE);

					result = WSAddressingFactory.getInstance().newWSAddressingReader().readEndpointReferenceType(doc);

				} else if (item instanceof JAXBElement<?> &&
						((JAXBElement<?>)item).getValue() instanceof
						com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.EndpointReferenceType) {

					result = new EndpointReferenceTypeImpl((com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.EndpointReferenceType) ((JAXBElement<?>)item).getValue(),null);
				}
			}
		}
		return result;
	}

	/**
	 * Method used to get {@link EndpointReferenceType} object from 
	 * {@link Unsubscribe} object
	 * 
	 * @param unsubObj {@link Unsubscribe} object
	 * @return {@link EndpointReferenceType} object
	 * @throws WSNotificationExtensionException
	 */
	public static EndpointReferenceType getEndpointReference(final Unsubscribe unsubObj) throws WSAddressingException{

		final List<Object> listOfObj = ((com.ebmwebsourcing.wsstar.notification.definition.base.Unsubscribe)
				((AbstractSchemaElementImpl<?>)unsubObj).getModel()).getAny();

		return WsnSpecificTypeHelper.getEndpointReference(listOfObj);
	}

	/**
	 * Method used to get {@link EndpointReferenceType} object from 
	 * {@link DestroyRegistration} object
	 * 
	 * @param unsubObj {@link DestroyRegistration} object
	 * @return {@link EndpointReferenceType} object
	 * @throws WSNotificationExtensionException
	 */
	public static EndpointReferenceType getEndpointReference(final DestroyRegistration destRegObj) throws WSAddressingException{

		final List<Object> listOfObj = ((com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistration)
				((AbstractSchemaElementImpl<?>)destRegObj).getModel()).getAny();

		return WsnSpecificTypeHelper.getEndpointReference(listOfObj);
	}

	// --- Pseudo Setters ---
	/**
	 * Private method that add an xml fragment representation of a {@link EndpointReferenceType}
	 * object to an {@link List} Of {@link Object}.  
	 * 
	 * @param listOfObj in which the xml representation must be add
	 * @throws WSNotificationExtensionException
	 */
	private static void setEndpointReference(final EndpointReferenceType epr,final List<Object> listOfObj) throws WSAddressingException{
		if(listOfObj != null){
						
			Object previousExistingObj = null; 
			
			for (final Object item : listOfObj) {
				if ((item instanceof Element &&
						((Element)item).getLocalName().compareTo(com.ebmwebsourcing.wsstar.addressing.definition.impl.Constants.ENDPOINT_REFERENCE_QNAME.getLocalPart()) == 0 &&
						((Element)item).getNamespaceURI().compareTo(com.ebmwebsourcing.wsstar.addressing.definition.impl.Constants.ENDPOINT_REFERENCE_QNAME.getNamespaceURI()) == 0) ||
						((item instanceof JAXBElement<?>) &&
								(((JAXBElement<?>)item).getName().equals(com.ebmwebsourcing.wsstar.addressing.definition.impl.Constants.ENDPOINT_REFERENCE_QNAME)) &&
								(((JAXBElement<?>)item).getValue() instanceof 
										com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.EndpointReferenceType))) {

					previousExistingObj = item;
					break;
				}
			}			
			if (previousExistingObj != null)
				listOfObj.remove(previousExistingObj);
			
			final Element eprAsElt = WSAddressingFactory.getInstance().newWSAddressingWriter().getDocument(epr).getDocumentElement();
			listOfObj.add(eprAsElt);
		}
	}

	/**
	 * Method used to set an xml fragment representation of a {@link Unsubscribe} object into a 
	 * {@link EndpointReferenceType} object
	 * 
	 * @param epr {@link EndpointReferenceType} object whom the xml representation must be set
	 * @param unsubObj {@link Unsubscribe} object in which the xml representation must be set
	 * @throws WSNotificationExtensionException
	 */
	public static void setEndpointReference(final EndpointReferenceType epr,final Unsubscribe unsubObj) throws WSAddressingException{

		final List<Object> listOfObj = ((com.ebmwebsourcing.wsstar.notification.definition.base.Unsubscribe)
				((AbstractSchemaElementImpl<?>)unsubObj).getModel()).getAny();
		WsnSpecificTypeHelper.setEndpointReference(epr, listOfObj);

	}

	/**
	 * Method used to set an xml fragment representation of a {@link DestroyRegistration} object into a 
	 * {@link EndpointReferenceType} object
	 * 
	 * @param epr {@link EndpointReferenceType} object whom the xml representation must be set
	 * @param destRegObj {@link DestroyRegistration} object in which the xml representation must be set
	 * @throws WSNotificationExtensionException
	 */
	public static void setEndpointReference(final EndpointReferenceType epr,final DestroyRegistration destRegObj) throws WSAddressingException{

		final List<Object> listOfObj = ((com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistration)
				((AbstractSchemaElementImpl<?>)destRegObj).getModel()).getAny();

		WsnSpecificTypeHelper.setEndpointReference(epr, listOfObj);
	}

	// ------------------------------------------------------
	// ------- "Helpers" for ResourcesUuidsType type --------
	// ------------------------------------------------------

	// --- Pseudo Getters ---

	/**
	 * Private method that get - if the expected xml fragment exists -a {@link ResourcesUuidType}
	 * object from an {@link List} Of {@link Object}.  
	 * 
	 * @param listOfObj from which the xml representation is supposed to be found
	 * @return a {@link ResourcesUuidType} object
	 * @throws WSNotificationExtensionException
	 */
	private static ResourcesUuidType getResourcesUuidType(final List<Object> listOfObj) throws WSNotificationExtensionException{
		ResourcesUuidType result = null;

		if (listOfObj!= null) {
			for (final Object item : listOfObj) {
				if (item instanceof Element &&
						((Element)item).getLocalName().compareTo(WsnExtensionConstants.RESOURCES_UUID_QNAME.getLocalPart()) == 0 &&
						((Element)item).getNamespaceURI().compareTo(WsnExtensionConstants.RESOURCES_UUID_QNAME.getNamespaceURI()) == 0){

					final Document doc = ((Element)item).getOwnerDocument();
					doc.setDocumentURI(WsnExtensionConstants.WSNOTIFICATION_EXTENDED_TYPES_NAMESPACE);

					result = WSNotificationExtensionReader.getInstance().readResourcesUuidType(doc);
				}
				else if ((item instanceof JAXBElement<?>) &&
						(((JAXBElement<?>)item).getName().equals(WsnExtensionConstants.RESOURCES_UUID_QNAME)) &&
						(((JAXBElement<?>)item).getValue() instanceof 
								com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ResourcesUuidType) ) {														
					result = new ResourcesUuidTypeImpl((com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ResourcesUuidType)((JAXBElement<?>)item).getValue(),null);					
				}
			}
		}
		return result;
	}

	/**
	 * Method used to get {@link ResourcesUuidType} object from 
	 * {@link ReferenceParametersType} object
	 * 
	 * @param refParams {@link ReferenceParametersType} object
	 * @return {@link ResourcesUuidType} object
	 * @throws WSNotificationExtensionException
	 */
	public static ResourcesUuidType getResourcesUuidType(final ReferenceParametersType refParams) throws WSNotificationExtensionException{

		final List<Object> listOfObj =
			((com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.ReferenceParametersType)
					((AbstractSchemaElementImpl<?>)refParams).getModel()).getAny();

		return WsnSpecificTypeHelper.getResourcesUuidType(listOfObj);
	}

	/**
	 * Method used to get {@link ResourcesUuidType} object from 
	 * {@link Unsubscribe} object
	 * 
	 * @param unsubsObj {@link Unsubscribe} object
	 * @return {@link ResourcesUuidType} object
	 * @throws WSNotificationExtensionException
	 */
	public static ResourcesUuidType getResourcesUuidType(final Unsubscribe unsubsObj) throws WSNotificationExtensionException{

		final List<Object> listOfObj =
			((com.ebmwebsourcing.wsstar.notification.definition.base.Unsubscribe)
					((AbstractSchemaElementImpl<?>)unsubsObj).getModel()).getAny();

		return WsnSpecificTypeHelper.getResourcesUuidType(listOfObj);
	}

	/**
	 * Method used to get {@link ResourcesUuidType} object from 
	 * {@link DestroyRegistration} object
	 * 
	 * @param destRegObj {@link DestroyRegistration} object
	 * @return {@link ResourcesUuidType} object
	 * @throws WSNotificationExtensionException
	 */
	public static ResourcesUuidType getResourcesUuidType(final DestroyRegistration destRegObj) throws WSNotificationExtensionException{

		final List<Object> listOfObj =
			((com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistration)
					((AbstractSchemaElementImpl<?>)destRegObj).getModel()).getAny();

		return WsnSpecificTypeHelper.getResourcesUuidType(listOfObj);
	}
	
	/**
	 * Method used to get {@link ResourcesUuidType} object from 
	 * {@link Renew} object
	 * 
	 * @param unsubsObj {@link Renew} object
	 * @return {@link ResourcesUuidType} object
	 * @throws WSNotificationExtensionException
	 */
	public static ResourcesUuidType getResourcesUuidType(final Renew renewObj) throws WSNotificationExtensionException{

		final List<Object> listOfObj =
			((com.ebmwebsourcing.wsstar.notification.definition.base.Renew)
					((AbstractSchemaElementImpl<?>)renewObj).getModel()).getAny();

		return WsnSpecificTypeHelper.getResourcesUuidType(listOfObj);
	}
	// --- Pseudo Setters ---
	/**
	 * Private method that add an xml fragment representation of a {@link ResourcesUuidType}
	 * object to an {@link List} Of {@link Object}.  
	 * 
	 * @param rUuidsObj {@link ResourcesUuidType} object whom the xml representation must be add
	 * @param listOfObj in which the xml representation must be add
	 * @throws WSNotificationExtensionException
	 */
	private static void setResourceUuidType(final ResourcesUuidType rUuidsObj ,final List<Object> listOfObj) throws WSNotificationExtensionException {
		if (listOfObj!= null){
						
			Object previousExistingObj = null; 
			
			for (final Object item : listOfObj) {
				if ((item instanceof Element &&
						((Element)item).getLocalName().compareTo(WsnExtensionConstants.RESOURCES_UUID_QNAME.getLocalPart()) == 0 &&
						((Element)item).getNamespaceURI().compareTo(WsnExtensionConstants.RESOURCES_UUID_QNAME.getNamespaceURI()) == 0) ||
						((item instanceof JAXBElement<?>) &&
								(((JAXBElement<?>)item).getName().equals(WsnExtensionConstants.RESOURCES_UUID_QNAME)) &&
								(((JAXBElement<?>)item).getValue() instanceof 
										com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ResourcesUuidType))) {

					previousExistingObj = item;
					break;
				}
			}			
			if (previousExistingObj != null)
				listOfObj.remove(previousExistingObj);
						
			final Element resourcesUuidsAsElt = WSNotificationExtensionWriter.getInstance().writeResourcesUuidType(rUuidsObj).getDocumentElement();
			listOfObj.add(resourcesUuidsAsElt);
		}
	}

	/**
	 * Method used to set an xml fragment representation of a {@link ResourcesUuidType} object into a 
	 * {@link ReferenceParametersType} object
	 * 
	 * @param rUuidsObj {@link ResourcesUuidType} object whom the xml representation must be set
	 * @param refParams {@link ReferenceParametersType} object in which the xml representation must be set
	 * @throws WSNotificationExtensionException
	 */
	public static void setResourcesUuidType(final ResourcesUuidType rUuidsObj ,final ReferenceParametersType refParams) throws WSNotificationExtensionException{
		final List<Object> listOfObj =
			((com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.ReferenceParametersType)
					((AbstractSchemaElementImpl<?>)refParams).getModel()).getAny();

		WsnSpecificTypeHelper.setResourceUuidType(rUuidsObj, listOfObj);
	}

	/**
	 * Method used to set an xml fragment representation of a {@link ResourcesUuidType} object into a 
	 * {@link ReferenceParametersType} object
	 * 
	 * @param rUuidsObj {@link ResourcesUuidType} object whom the xml representation must be set
	 * @param unsubsObj {@link Unsubscribe} object in which the xml representation must be set
	 * @throws WSNotificationExtensionException
	 */
	public static void setResourcesUuidType(final ResourcesUuidType rUuidsObj ,final Unsubscribe unsubsObj) throws WSNotificationExtensionException{
		final List<Object> listOfObj =
			((com.ebmwebsourcing.wsstar.notification.definition.base.Unsubscribe)
					((AbstractSchemaElementImpl<?>)unsubsObj).getModel()).getAny();

		WsnSpecificTypeHelper.setResourceUuidType(rUuidsObj, listOfObj);
	}

	/**
	 * Method used to set an xml fragment representation of a {@link ResourcesUuidType} object into a 
	 * {@link DestroyRegistration} object
	 * 
	 * @param rUuidsObj {@link ResourcesUuidType} object whom the xml representation must be set
	 * @param destRegObj {@link DestroyRegistration} object in which the xml representation must be set
	 * @throws WSNotificationExtensionException
	 */
	public static void setResourcesUuidType(final ResourcesUuidType rUuidsObj ,final DestroyRegistration destRegObj) throws WSNotificationExtensionException{
		final List<Object> listOfObj =
			((com.ebmwebsourcing.wsstar.notification.definition.brokered.DestroyRegistration)
					((AbstractSchemaElementImpl<?>)destRegObj).getModel()).getAny();

		WsnSpecificTypeHelper.setResourceUuidType(rUuidsObj, listOfObj);
	}
	
	/**
	 * Method used to set an xml fragment representation of a {@link ResourcesUuidType} object into a 
	 * {@link Renew} object
	 * 
	 * @param rUuidsObj {@link ResourcesUuidType} object whom the xml representation must be set
	 * @param renewObj {@link Renew} object in which the xml representation must be set
	 * @throws WSNotificationExtensionException
	 */
	public static void setResourcesUuidType(final ResourcesUuidType rUuidsObj ,final Renew renewObj) throws WSNotificationExtensionException{
		final List<Object> listOfObj =
			((com.ebmwebsourcing.wsstar.notification.definition.base.Renew)
					((AbstractSchemaElementImpl<?>)renewObj).getModel()).getAny();

		WsnSpecificTypeHelper.setResourceUuidType(rUuidsObj, listOfObj);
	}

	// ----------------------------------------------------
	// ------- "Helpers" for ProcessPolicyType type -------
	// ----------------------------------------------------

	// --- Pseudo Getters ---
	
	/**
	 * method that get - if the expected xml fragment exists -a {@link ProcessPolicyType}
	 * object from a {@link SubscriptionPolicyType} object.  
	 * 
	 * @param subsPolicy {@link SubscriptionPolicyType} object from which the xml representation is supposed to be found
	 * @return a {@link ProcessPolicyType} object
	 * @throws WSNotificationExtensionException
	 */
	public static ProcessPolicyType getProcessPolicyType(final SubscriptionPolicyType subsPolicy) throws WSNotificationExtensionException{
		ProcessPolicyType result = null;

		final List<Object> listObj =
			((com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionPolicyType)
					((AbstractSchemaElementImpl<?>)subsPolicy).getModel()).getAny();

		if (listObj!= null) {
			for (final Object item : listObj) {
				if (item instanceof Element &&
						((Element)item).getLocalName().compareTo(WsnExtensionConstants.PROCESS_POLICY_QNAME.getLocalPart()) == 0 &&
						((Element)item).getNamespaceURI().compareTo(WsnExtensionConstants.PROCESS_POLICY_QNAME.getNamespaceURI()) == 0){

					final Document doc = ((Element)item).getOwnerDocument();
					doc.setDocumentURI(WsnExtensionConstants.WSNOTIFICATION_EXTENDED_TYPES_NAMESPACE);

					result = WSNotificationExtensionReader.getInstance().readProcessPolicyType(doc);
				}
				else if ((item instanceof JAXBElement<?>) &&
						(((JAXBElement<?>)item).getName().equals(WsnExtensionConstants.PROCESS_POLICY_QNAME)) &&
						(((JAXBElement<?>)item).getValue() instanceof 
								com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ProcessPolicyType) ) {														
					result = new ProcessPolicyTypeImpl((com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ProcessPolicyType)((JAXBElement<?>)item).getValue(),null);					
				}
			}
		}

		return result;
	}

	// --- Pseudo Setters ---

	/**
	 * Method used to set an xml fragment representation of a {@link ProcessPolicyType} object into a 
	 * {@link SubscriptionPolicyType} object
	 * 
	 * @param rUuidsObj {@link ProcessPolicyType} object whom the xml representation must be set
	 * @param destRegObj {@link SubscriptionPolicyType} object in which the xml representation must be set
	 * @throws WSNotificationExtensionException
	 */
	public static void setProcessPolicyType(final ProcessPolicyType processPolicyObj ,final SubscriptionPolicyType subsPolicy) throws WSNotificationExtensionException{

		final List<Object> listObj =
			((com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionPolicyType)
					((AbstractSchemaElementImpl<?>)subsPolicy).getModel()).getAny();

		if (listObj!= null){
			final Element processPolicyAsElt = WSNotificationExtensionWriter.getInstance().writeProcessPolicyType(processPolicyObj).getDocumentElement();
			listObj.add(processPolicyAsElt);
		}
	}


	// ----------------------------------------------------
	// ------- "Helpers" for ContextPolicyType type -------
	// ----------------------------------------------------

	// --- Pseudo Getters ---
	
	/**
	 * method that get - if the expected xml fragment exists -a {@link ContextPolicyType}
	 * object from a {@link SubscriptionPolicyType} object.  
	 * 
	 * @param subsPolicy {@link SubscriptionPolicyType} object from which the xml representation is supposed to be found
	 * @return a {@link ContextPolicyType} object
	 * @throws WSNotificationExtensionException
	 */
	public static ContextPolicyType getContextPolicyType(final SubscriptionPolicyType subsPolicy) throws WSNotificationExtensionException{
		ContextPolicyType result = null;

		final List<Object> listObj =
			((com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionPolicyType)
					((AbstractSchemaElementImpl<?>)subsPolicy).getModel()).getAny();

		if (listObj!= null) {
			for (final Object item : listObj) {
				if (item instanceof Element &&
						((Element)item).getLocalName().compareTo(WsnExtensionConstants.CONTEXT_POLICY_QNAME.getLocalPart()) == 0 &&
						((Element)item).getNamespaceURI().compareTo(WsnExtensionConstants.CONTEXT_POLICY_QNAME.getNamespaceURI()) == 0){

					final Document doc = ((Element)item).getOwnerDocument();
					doc.setDocumentURI(WsnExtensionConstants.WSNOTIFICATION_EXTENDED_TYPES_NAMESPACE);

					result = WSNotificationExtensionReader.getInstance().readContextPolicyType(doc);
				}
				else if ((item instanceof JAXBElement<?>) &&
						(((JAXBElement<?>)item).getName().equals(WsnExtensionConstants.CONTEXT_POLICY_QNAME)) &&
						(((JAXBElement<?>)item).getValue() instanceof 
								com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ContextPolicyType) ) {														
					result = new ContextPolicyTypeImpl((com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ContextPolicyType)((JAXBElement<?>)item).getValue(),null);					
				}
			}
		}

		return result;
	}

	// --- Pseudo Setters ---
	/**
	 * Method used to set an xml fragment representation of a {@link ContextPolicyType} object into a 
	 * {@link SubscriptionPolicyType} object
	 * 
	 * @param contextPolicyObj {@link ContextPolicyType} object whom the xml representation must be set
	 * @param destRegObj {@link SubscriptionPolicyType} object in which the xml representation must be set
	 * @throws WSNotificationExtensionException
	 */
	public static void setContextPolicyType(final ContextPolicyType contextPolicyObj ,final SubscriptionPolicyType subsPolicy) throws WSNotificationExtensionException{

		final List<Object> listObj =
			((com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionPolicyType)
					((AbstractSchemaElementImpl<?>)subsPolicy).getModel()).getAny();

		if (listObj!= null){
			final Element contextPolicyAsElt = WSNotificationExtensionWriter.getInstance().writeContextPolicyType(contextPolicyObj).getDocumentElement();
			listObj.add(contextPolicyAsElt);
		}
	}


	// --------------------------------------------------------
	// ------- "Helpers" for XpathExrpessionsType type --------
	// --------------------------------------------------------

	// --- Pseudo Getters ---
	/**
	 * method that get - if the expected xml fragment exists -a {@link String}
	 * object from a {@link QueryExpressionType} object.  
	 * 
	 * @param listOfObj from which the xml representation is supposed to be found
	 * @return a {@link String} object
	 * @throws WSNotificationExtensionException
	 */
	public static String getXpathExpression(final QueryExpressionType messageContent) throws WSNotificationExtensionException{
		String result = null;

		final List<Object> listObj =
			((com.ebmwebsourcing.wsstar.notification.definition.base.QueryExpressionType)
					((AbstractSchemaElementImpl<?>) messageContent).getModel()).getContent();
		if (listObj!= null) {
			for (final Object item : listObj) {
				if (item instanceof Element &&
						((Element)item).getLocalName().compareTo(WsnExtensionConstants.XPATHS_QNAME.getLocalPart()) == 0 &&
						((Element)item).getNamespaceURI().compareTo(WsnExtensionConstants.XPATHS_QNAME.getNamespaceURI()) == 0){
					result = ((Element)item).getTextContent();
				} else if ((item instanceof JAXBElement<?>) &&
						(((JAXBElement<?>)item).getName().equals(WsnExtensionConstants.XPATHS_QNAME)) &&
						(((JAXBElement<?>)item).getValue() instanceof String) ) {														
					result = (String)((JAXBElement<?>)item).getValue();					
				}
			}
		}
		return result;
	}

	// --- Pseudo Setters ---
	/**
	 * Method used to set an xml fragment representation of a {@link ProcessPolicyType} object into a 
	 * {@link SubscriptionPolicyType} object
	 * 
	 * @param xpathsObj {@link String} object whom the xml representation must be set
	 * @param messageContent {@link QueryExpressionType} object in which the xml representation must be set
	 * @throws WSNotificationExtensionException
	 */
	public static void setXpathExpressionsType(final String xpathsObj ,final QueryExpressionType messageContent) throws WSNotificationExtensionException{

		final List<Object> listObj =
			((com.ebmwebsourcing.wsstar.notification.definition.base.QueryExpressionType)
					((AbstractSchemaElementImpl<?>)messageContent).getModel()).getContent();
		if (listObj!= null){
			//Element xpathsAsElt = WSNotificationExtensionFactory.getInstance().createWSNotificationExtensionWriter().writeXpathExpressionsType(xpathsObj).getDocumentElement();
			final JAXBElement<String> xpathasJaxB = new JAXBElement<String> (WsnExtensionConstants.XPATHS_QNAME,java.lang.String.class,xpathsObj);
			listObj.add(xpathasJaxB);
		}
	}

	// ------------------------------------------------------
	// ------- "Helpers" for XsltStyleSheetType type --------
	// ------------------------------------------------------

	// --- Pseudo Getters ---
	/**
	 * method that get - if the expected xml fragment exists -a {@link XsltStyleSheetType}
	 * object from a {@link SubscriptionPolicyType} object.  
	 * 
	 * @param subsPolicy {@link SubscriptionPolicyType} object from which the xml representation is supposed to be found
	 * @return a {@link XsltStyleSheetType} object
	 * @throws WSNotificationExtensionException
	 */
	public static XsltStyleSheetType getXsltStyleSheetType(final SubscriptionPolicyType subsPolicy) throws WSNotificationExtensionException{
		XsltStyleSheetType result = null;

		final List<Object> listObj =
			((com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionPolicyType)
					((AbstractSchemaElementImpl<?>)subsPolicy).getModel()).getAny();
		if (listObj!= null) {
			for (final Object item : listObj) {
				if (item instanceof Element &&
						((Element)item).getLocalName().compareTo(WsnExtensionConstants.TRANSFORM_POLICY_QNAME.getLocalPart()) == 0 &&
						((Element)item).getNamespaceURI().compareTo(WsnExtensionConstants.TRANSFORM_POLICY_QNAME.getNamespaceURI()) == 0){

					final Document doc = ((Element)item).getOwnerDocument();
					doc.setDocumentURI(WsnExtensionConstants.WSNOTIFICATION_EXTENDED_TYPES_NAMESPACE);

					result = WSNotificationExtensionReader.getInstance().readXsltStyleSheetType(doc);
				}
				else if ((item instanceof JAXBElement<?>) &&
						(((JAXBElement<?>)item).getName().equals(WsnExtensionConstants.TRANSFORM_POLICY_QNAME)) &&
						(((JAXBElement<?>)item).getValue() instanceof 
								com.ebmwebsourcing.wsstar.notification.jaxbextension.types.XsltStyleSheetType) ) {														
					result = new XsltStyleSheetTypeImpl((com.ebmwebsourcing.wsstar.notification.jaxbextension.types.XsltStyleSheetType)((JAXBElement<?>)item).getValue(),null);					
				}				
			}
		}

		return result;
	}

	// --- Pseudo Setters ---
	/**
	 * Method used to set an xml fragment representation of a {@link XsltStyleSheetType} object into a 
	 * {@link SubscriptionPolicyType} object
	 * 
	 * @param transformPolicyObj {@link XsltStyleSheetType} object whom the xml representation must be set
	 * @param subsPolicy {@link SubscriptionPolicyType} object in which the xml representation must be set
	 * @throws WSNotificationExtensionException
	 */
	public static void setXsltStyleSheetType(final XsltStyleSheetType transformPolicyObj ,final SubscriptionPolicyType subsPolicy) throws WSNotificationExtensionException{

		final List<Object> listObj =
			((com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionPolicyType)
					((AbstractSchemaElementImpl<?>)subsPolicy).getModel()).getAny();
		if (listObj!= null){
			final Element transfromPolicyAsElt = WSNotificationExtensionWriter.getInstance().writeXsltStyleSheetType(transformPolicyObj).getDocumentElement();
			listObj.add(transfromPolicyAsElt);
		}
	}

	// ------------------------------------------------------
	// 		------- "Helpers" for Message type --------
	// ------------------------------------------------------
	
	// ---- Pseudo Getters -----
	
	
	 //TODO : try to make a generic method using Generic. It would return the expected
	 // generic typed object or null.
	 /*  
	 public static <T> T getContentFromMessage(Message messageContent, Class<T> clazz) {	
		T result = null;
		Object tmp = null;
		try {
			tmp = ((com.ebmwebsourcing.wsstar.notification.definition.base.NotificationMessageHolderType.Message)((AbstractSchemaElementImpl<?>) messageContent).getModel()).getAny(); 
			result = clazz.cast(tmp);
		} catch (ClassCastException e) {
			System.out.println("JAVA Object type : " + tmp.getClass().getSimpleName());
		} 		
		return result;
	}	
	*/
	/**
	 * method that get the content of a {@link Message} as a {@link Element}.  
	 * 
	 * @param messageContent from which the xml representation is supposed to be found
	 * @return a {@link Element} object
	 * @throws WSNotificationExtensionException
	 */
	public static Element getContentFromMessage(Message messageContent) {		
		Element result = null;
		try {
			result =(Element) 
			((com.ebmwebsourcing.wsstar.notification.definition.base.NotificationMessageHolderType.Message)((AbstractSchemaElementImpl<?>) messageContent).getModel()).getAny();		
		} catch (ClassCastException e) {}
		return result ;	
	}	
	
	
	// --- Pseudo Setters ---
	/**
	 * Method used to set an xml fragment representation of a {@link String} object into a 
	 * {@link Message} object
	 * 
	 * @param strValue {@link String} object whom the xml representation must be set
	 * @param content {@link Message} object in which the xml representation must be set
	 * @throws WSNotificationExtensionException
	 */
	/*public static void setContentToMessage(String strValue, Message content) {
		content.setContent(new JAXBElement<String>(new QName("NotifyContent"),
				java.lang.String.class,
				strValue));
	}*/
	
	/**
	 * Method used to set an {@link Element} object into a {@link Message} object
	 * 
	 * @param eltValue {@link Element} object whom the xml representation must be set
	 * @param content {@link Message} object in which the xml representation must be set
	 * @throws WSNotificationExtensionException
	 */
	public static void setContentToMessage(Element eltValue, Message content) {
		content.setContent(eltValue);
	}
	
	
	// ------------------------------------------------------
	//   ------- "Helpers" for TerminationTime type --------
	// ------------------------------------------------------
	
	// ---- Pseudo Getters -----
	
		
	/**
	 * method that get the termination time of a {@link SubscriptionManagerRP} as a {@link TerminationTimeType}.  
	 * 
	 * @param subscription from which the xml representation is supposed to be found
	 * @return subscription a {@link XsltStyleSheetType} object
	 * @throws WSNotificationExtensionException 
	 */
	public static TerminationTimeType getTerminationTimeFromSubscription(SubscriptionManagerRP subscription) throws WSNotificationExtensionException {		
		TerminationTimeType result = null;		
		SubscriptionPolicyType subsPolicy = subscription.getSubscriptionPolicy();

		if (subsPolicy != null){
			final List<Object> listOfObj = 
				((com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionPolicyType) ((AbstractSchemaElementImpl<?>) subsPolicy).getModel()).getAny(); 			
						
			if (listOfObj!= null) {
				for (final Object item : listOfObj) {
					if (item instanceof Element &&
							((Element)item).getLocalName().compareTo(WsnExtensionConstants.TERMINATION_TIME_QNAME.getLocalPart()) == 0 &&
							((Element)item).getNamespaceURI().compareTo(WsnExtensionConstants.TERMINATION_TIME_QNAME.getNamespaceURI()) == 0){

						final Document doc = ((Element)item).getOwnerDocument();
						doc.setDocumentURI(WsnExtensionConstants.WSNOTIFICATION_EXTENDED_TYPES_NAMESPACE);

						result = WSNotificationExtensionReader.getInstance().readTerminationTimeType(doc);
					}
					else if ((item instanceof JAXBElement<?>) &&
							(((JAXBElement<?>)item).getName().equals(WsnExtensionConstants.TERMINATION_TIME_QNAME)) &&
							(((JAXBElement<?>)item).getValue() instanceof com.ebmwebsourcing.wsstar.notification.jaxbextension.types.TerminationTimeType) ) {														
						result = new TerminationTimeTypeImpl((com.ebmwebsourcing.wsstar.notification.jaxbextension.types.TerminationTimeType)((JAXBElement<?>)item).getValue(),null);					
					}				
				}
			}		
		}

		return result;
	}	
	
	
	// --- Pseudo Setters ---
	
	/**
	 * Method used to set an {@link TerminationTimeType} object into a {@link SubscriptionManagerRP} object
	 * 
	 * @param termTimeValue {@link TerminationTimeType} object whom the xml representation must be set
	 * @param subscription {@link SubscriptionManagerRP} object which the xml representation must be set in
	 * @throws WSNotificationExtensionException
	 */
	public static void setTerminationTimeToSubscription(TerminationTimeType termTimeValue, SubscriptionManagerRP subscription) throws WSNotificationExtensionException {

		SubscriptionPolicyType subsPolicy = subscription.getSubscriptionPolicy();

		if (subsPolicy != null) {

			final List<Object> listObj =
				((com.ebmwebsourcing.wsstar.notification.definition.base.SubscriptionPolicyType)
						((AbstractSchemaElementImpl<?>)subsPolicy).getModel()).getAny();

			if (listObj!= null){				
				Object currentTermTimeAsObj = null; 
				
				for (final Object item : listObj) {
					if ((item instanceof Element &&
							((Element)item).getLocalName().compareTo(WsnExtensionConstants.TERMINATION_TIME_QNAME.getLocalPart()) == 0 &&
							((Element)item).getNamespaceURI().compareTo(WsnExtensionConstants.TERMINATION_TIME_QNAME.getNamespaceURI()) == 0) ||
							((item instanceof JAXBElement<?>) &&
									(((JAXBElement<?>)item).getName().equals(WsnExtensionConstants.TERMINATION_TIME_QNAME)) &&
									(((JAXBElement<?>)item).getValue() instanceof 
											com.ebmwebsourcing.wsstar.notification.jaxbextension.types.TerminationTimeType))) {

						currentTermTimeAsObj = item;
						break;
					}
				}
				
				if (currentTermTimeAsObj != null)
					listObj.remove(currentTermTimeAsObj);
				
				final Element terminationTimeAsElt = WSNotificationExtensionWriter.getInstance().writeTerminationTimeType(termTimeValue).getDocumentElement();
				listObj.add(terminationTimeAsElt);
				
			}
			
		}
	}	

	// ---------------------------------------------------------
	//   ------- "Helpers" for TopicTypeImpl type -----------
	// --------------------------------------------------------
	
	// ------ Getter ----------
	
	/**
	 * check if a given topic is a supported topic in the current context
	 *  
	 * @param topic {@link TopicType} object to check 
	 * @return true if supported , false if not
	 */
	public static Boolean isTopicSupported(TopicType topic) {
		Boolean res = null;
		com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType model = 
			((AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType>)topic).getModel();
		final String value = model.getOtherAttributes().get(WsnExtensionConstants.SUPPORTED_QNAME_ATTR);
		if (value != null) {
			res = Boolean.valueOf(value);
		}
		return res;
	}
	
	// ------ Setter ----------

	/**
	 * 
	 * @param topic
	 * @param support
	 */
	public static void setSupported(TopicType topic,final Boolean support) {
		if (support != null) {
			com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType model = 
				((AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.notification.definition.topics.TopicType>)topic).getModel();
			if (support == true) {
				model.getOtherAttributes().put(WsnExtensionConstants.SUPPORTED_QNAME_ATTR, support.toString());
			} else {
				model.getOtherAttributes().remove(WsnExtensionConstants.SUPPORTED_QNAME_ATTR);
			}
		}
	}
		
}
