/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.extension.api;

import java.util.List;

import org.ow2.easywsdl.schema.api.SchemaElement;

import com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.ActionType;
/**
 * This interface provides an encapsulated version of the JAXB Class
 * {@ link com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ProcessPolicyType}.
 * It also uses EASYWSDL library encapsulation model. 
 * 
 * @author Thierry Déjean -eBM WebSourcing
 */
public interface ProcessPolicyType extends SchemaElement {

	/**
	 * see the "same named method" javadoc description in
	 * {@link com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ProcessPolicyType} JAXB*
	 * generated class
	 */
	public List<ActionType> getAction();
	
	/**
	 * see the "same named method" javadoc description in
	 * {@link com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ProcessPolicyType} JAXB*
	 * generated class
	 */
	public void addAction(ActionType value);
	
	/**
	 * see the "same named method" javadoc description in
	 * {@link com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ProcessPolicyType} JAXB*
	 * generated class
	 */
	public void clearAction();
}
