/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.extension.impl;

import java.util.List;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.wsstar.notification.extension.api.ProcessPolicyType;
import com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.ActionType;
/**
 * This class implements {@link ProcessPolicyType} java interface respect to
 * EASYWSDL Library model.
 * 
 * @author Thierry Déjean - eBM Websourcing
 */
public class ProcessPolicyTypeImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.ProcessPolicyType> implements
		ProcessPolicyType {

	private static final long serialVersionUID = 1L;

	/**
 	 * Constructor (follow EASYWSDL model)
 	 *
	 * @param model
	 * @param parent
	 */
	public ProcessPolicyTypeImpl(com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.ProcessPolicyType model,
			AbstractSchemaElementImpl<?> parent) {
		super(model,parent);
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.ProcessPolicyType#addAction(com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ActionType)
	 */
	public void addAction(ActionType value) {
		this.model.getAction().add(value);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.ProcessPolicyType#clearAction()
	 */
	public void clearAction() {
		this.model.getAction().clear();
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.ProcessPolicyType#getAction()
	 */
	public List<ActionType> getAction() {
		return this.model.getAction();
	}

}
