/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.extension.inout;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.dom.DOMSource;

import org.w3c.dom.Document;

import com.ebmwebsourcing.wsstar.notification.extension.api.ContextPolicyType;
import com.ebmwebsourcing.wsstar.notification.extension.api.ProcessPolicyType;
import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.api.TerminationTimeType;
import com.ebmwebsourcing.wsstar.notification.extension.api.XsltStyleSheetType;
import com.ebmwebsourcing.wsstar.notification.extension.impl.ContextPolicyTypeImpl;
import com.ebmwebsourcing.wsstar.notification.extension.impl.ProcessPolicyTypeImpl;
import com.ebmwebsourcing.wsstar.notification.extension.impl.ResourcesUuidTypeImpl;
import com.ebmwebsourcing.wsstar.notification.extension.impl.SOAParameterTypeImpl;
import com.ebmwebsourcing.wsstar.notification.extension.impl.TerminationTimeTypeImpl;
import com.ebmwebsourcing.wsstar.notification.extension.impl.XsltStyleSheetTypeImpl;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionJAXBContext;

/**
 * This class provides a collection of methods that enable conversion of a
 * {@link Document} object into a "custom java type" object defined in the xml schema
 * file named "specifictypesFornotifications.xsd". This conversion uses JAXB
 * "unmarshalling" mechanism
 * 
 * @author tdejean -eBM WebSourcing
 */
public class WSNotificationExtensionReader {
	private static Logger log = Logger.getLogger(WSNotificationExtensionReader.class.getName());
	
	private WSNotificationExtensionJAXBContext notifJaxbContext = null;
	
	/**
	 * Constructor. Initialize private attributes value
	 * 
	 */
	private WSNotificationExtensionReader() {
		try {
			this.notifJaxbContext = new WSNotificationExtensionJAXBContext();
		} catch (final Exception e) {
			log.log(Level.WARNING, "WsNotificationExtensionReader initialisation failed !", e);
		}
	}
	
	
	
	/**
	 * SingletonHolder is loaded on the first execution of Singleton.getInstance() 
	 * or the first access to SingletonHolder.INSTANCE, not before.
	 */
    private static class WSNotificationExtensionReaderHolder {     	
		private final static WSNotificationExtensionReader INSTANCE = new WSNotificationExtensionReader();
	}
    
    /**
	 * Return an unique - respect to the Singleton design pattern - instance  
	 * of the {@link WSNotificationExtensionReader} class.  
	 * 
	 * @return a unique WSNotificationFactory instance. 
	 */
	public static WSNotificationExtensionReader getInstance() {
		return WSNotificationExtensionReaderHolder.INSTANCE;
	}
	
	
	/**
	 * 	Unmarshall {@link SOAParameterType} object from a {@link Document} representation fragment object 
  	 *
	 * @param javaObj {@link org.w3c.dom.Document} object representation of {@link SOAParameterType} Java type
	 * @return {@link SOAParameterType} object (type generated with jaxb tools) 
	 * @throws WSNotificationExtensionException
	 */
	public SOAParameterType readSOAParameterType(Document javaObj) throws WSNotificationExtensionException{
		SOAParameterType result = null;

		try {
			final Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

			final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.SOAParameterType> schemaBinding = unmarshaller.unmarshal(new DOMSource(javaObj), com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.SOAParameterType.class);
			result = new SOAParameterTypeImpl(schemaBinding.getValue(), null);
			/*
			 * com.ebmwebsourcing.wsstar.notification.jaxbextension.types.SOAParameterType jaxbTypeObj = (com.ebmwebsourcing.wsstar.notification.jaxbextension.types.SOAParameterType) unmarshaller.unmarshal(javaObj); result = new SOAParameterTypeImpl(jaxbTypeObj,null);
			 */

		} catch (final JAXBException e) {
			throw new WSNotificationExtensionException(e);
		}

		return result;
	}
	
	/**
	 * 	Unmarshall {@link ResourcesUuidType} object from a {@link Document} representation fragment object 
  	 *
	 * @param javaObj {@link org.w3c.dom.Document} object representation of {@link ResourcesUuidType} Java type
	 * @return {@link ResourcesUuidType} object (type generated with jaxb tools) 
	 * @throws WSNotificationExtensionException
	 */
	public ResourcesUuidType readResourcesUuidType(Document javaObj) throws WSNotificationExtensionException{
		ResourcesUuidType result = null;

		try {
			final Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

			final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.ResourcesUuidType> schemaBinding = unmarshaller.unmarshal(new DOMSource(javaObj), com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.ResourcesUuidType.class);
			result = new ResourcesUuidTypeImpl(schemaBinding.getValue(), null);
			/*
			 * com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ResourcesUuidType jaxbTypeObj = (com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ResourcesUuidType) unmarshaller.unmarshal(javaObj); result = new ResourcesUuidTypeImpl(jaxbTypeObj,null);
			 */
		} catch (final JAXBException e) {
			throw new WSNotificationExtensionException(e);
		}

		return result;
	}
		
	/**
	 * 	Unmarshall {@link ProcessPolicyType} object from a {@link Document} representation fragment object 
  	 *
	 * @param javaObj {@link org.w3c.dom.Document} object representation of {@link ProcessPolicyType} Java type
	 * @return {@link ProcessPolicyType} object (type generated with jaxb tools) 
	 * @throws WSNotificationExtensionException
	 */
	public ProcessPolicyType readProcessPolicyType(Document javaObj) throws WSNotificationExtensionException{
		ProcessPolicyType result = null;

		try {
			final Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

			final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.ProcessPolicyType> schemaBinding = unmarshaller.unmarshal(new DOMSource(javaObj), com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.ProcessPolicyType.class);
			result = new ProcessPolicyTypeImpl(schemaBinding.getValue(), null);
			/*
			 * com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ProcessPolicyType jaxbTypeObj = (com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ProcessPolicyType) unmarshaller.unmarshal(javaObj); result = new ProcessPolicyTypeImpl(jaxbTypeObj,null);
			 */
		} catch (final JAXBException e) {
			throw new WSNotificationExtensionException(e);
		}
		return result;
	}
	
	/**
	 * 	Unmarshall {@link ContextPolicyType} object from a {@link Document} representation fragment object 
  	 *
	 * @param javaObj {@link org.w3c.dom.Document} object representation of {@link ContextPolicyType} Java type
	 * @return {@link ContextPolicyType} object (type generated with jaxb tools) 
	 * @throws WSNotificationExtensionException
	 */
	public ContextPolicyType readContextPolicyType(Document javaObj) throws WSNotificationExtensionException{
		ContextPolicyType result = null;

		try {
			final Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

			final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.ContextPolicyType> schemaBinding = unmarshaller.unmarshal(new DOMSource(javaObj), com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.ContextPolicyType.class);
			result = new ContextPolicyTypeImpl(schemaBinding.getValue(), null);
			/*
			 * com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ProcessPolicyType jaxbTypeObj = (com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ProcessPolicyType) unmarshaller.unmarshal(javaObj); result = new ProcessPolicyTypeImpl(jaxbTypeObj,null);
			 */
		} catch (final JAXBException e) {
			throw new WSNotificationExtensionException(e);
		}
		return result;
	}
	
	/**
	 * 	Unmarshall {@link XsltStyleSheetType} object from a {@link Document} representation fragment object 
  	 *
	 * @param javaObj {@link org.w3c.dom.Document} object representation of {@link XsltStyleSheetType} Java type
	 * @return {@link XsltStyleSheetType} object (type generated with jaxb tools) 
	 * @throws WSNotificationExtensionException
	 */
	public XsltStyleSheetType readXsltStyleSheetType(Document javaObj) throws WSNotificationExtensionException{
		XsltStyleSheetType result = null;

		try {
			final Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

			final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.XsltStyleSheetType> schemaBinding = unmarshaller.unmarshal(new DOMSource(javaObj), com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.XsltStyleSheetType.class);
			result = new XsltStyleSheetTypeImpl(schemaBinding.getValue(), null);

			/*
			 * com.ebmwebsourcing.wsstar.notification.jaxbextension.types.XsltStyleSheetType jaxbTypeObj = (com.ebmwebsourcing.wsstar.notification.jaxbextension.types.XsltStyleSheetType) unmarshaller.unmarshal(javaObj); result = new XsltStyleSheetTypeImpl(jaxbTypeObj,null);
			 */
		} catch (final JAXBException e) {
			throw new WSNotificationExtensionException(e);
		}

		return result;
	}
	
	/**
	 * 	Unmarshall {@link TerminationTimeType} object from a {@link Document} representation fragment object 
  	 *
	 * @param javaObj {@link org.w3c.dom.Document} object representation of {@link TerminationTimeType} Java type
	 * @return {@link TerminationTimeType} object (type generated with jaxb tools) 
	 * @throws WSNotificationExtensionException
	 */
	public TerminationTimeType readTerminationTimeType(Document javaObj) throws WSNotificationExtensionException{
		TerminationTimeType result = null;

		try {
			final Unmarshaller unmarshaller = this.notifJaxbContext.createWSNotificationUnmarshaller();

			final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.TerminationTimeType> schemaBinding = unmarshaller.unmarshal(new DOMSource(javaObj), com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.TerminationTimeType.class);
			result = new TerminationTimeTypeImpl(schemaBinding.getValue(), null);
			
			
			  /* com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.TerminationTimeType jaxbTypeObj = (com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.TerminationTimeType) unmarshaller.unmarshal(javaObj); 
			   * result = new TerminationTimeTypeImpl(jaxbTypeObj,null);
			   */
		} catch (final JAXBException e) {
			throw new WSNotificationExtensionException(e);
		}

		return result;
	}
}
