/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.service.basenotification.impl;


import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessage;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessageResponse;

import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Message;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl.GetCurrentMessageImpl;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;
import com.ebmwebsourcing.wsstar.notification.service.basenotification.WsnbNotificationProducer;

import com.ebmwebsourcing.wsstar.notification.service.fault.WSNotificationFault;
import com.ebmwebsourcing.wsstar.notification.service.topic.WstopTopicManager;
import com.ebmwebsourcing.wsstar.notification.service.util.WSNotificationNotImplementedException;
import com.ebmwebsourcing.wsstar.notification.service.util.WSNotificationTopicManagerBadUsageException;


/**
 * @author tdejean - eBM WebSourcing
 *
 */
public class NotificationProducerMgr implements WsnbNotificationProducer/*,WsnbSubscriptionManager*/ {

	private Logger logger;
	private String notificationProducerEdp = "http://www.ebmwebsourcing.com/subscriptionManager/default";
	private QName notificationProducerService = new QName("http://www.ebmwebsourcing.com/default","NotificationProducerService");
	private QName notificationProducerInterface = new QName("http://www.ebmwebsourcing.com/default","NotificationProducer");	

	private WstopTopicManager topicsMgr;
	private SubscriptionManagerMgr subsMgr;

	private Map<String, Message> notifMessageContentList = null;
	
	public NotificationProducerMgr(Logger logger, WstopTopicManager topicsMgr, SubscriptionManagerMgr subsMgr) {
		super();
		this.logger = logger;
		this.topicsMgr = topicsMgr;
		this.subsMgr = subsMgr;
		this.notifMessageContentList = new HashMap<String, Message>();
	}
	
	public NotificationProducerMgr(Logger logger, SubscriptionManagerMgr subsMgr) {
		super();
		this.logger = logger;
		this.topicsMgr = null;
		this.subsMgr = subsMgr;
		this.notifMessageContentList = new HashMap<String, Message>();
	}

	public void setNotificationProducerEdp(
			String notificationProducerEdp) {
		this.notificationProducerEdp = notificationProducerEdp;		
	}
	
	public String getNotificationProducerEdp() {
		return notificationProducerEdp;
	}
	
	public void setNotificationProducerService(
			QName notificationProducerService) {
		this.notificationProducerService = notificationProducerService;		
	}
	
	public QName getNotificationProducerService() {
		return notificationProducerService;
	}
	
	public void setNotificationProducerInterface(
			QName notificationProducerInterface) {
		this.notificationProducerInterface = notificationProducerInterface;
	}
	
	public QName getNotificationProducerInterfaceQName() {
		return this.notificationProducerInterface;
	}	
	
	public WstopTopicManager getTopicsMgr() {
		return topicsMgr;
	}
	
	public void setTopicsMgr(WstopTopicManager topicsMgr) {
		this.topicsMgr = topicsMgr;
	}
	
	public SubscriptionManagerMgr getSubsMgr() {
		return subsMgr;
	}
	
	/* (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.service.basenotification.WsnbNotificationProducer#getCurrentMessage(com.ebmwebsourcing.wsstar.notification.service.test.wsnotification.base.GetCurrentMessage)
	 */
	public GetCurrentMessageResponse getCurrentMessage(GetCurrentMessage request) throws WSNotificationException, WSNotificationFault {
		logger.log(Level.FINE, "performs a \"GetCurrentMessage\" request ...");
		//TODO : implement this method !!!
		//throw new WSNotificationNotImplementedException(this.getClass().getName(),"GetCurrentMessage");
		
		if (this.topicsMgr == null)
			throw new WSNotificationTopicManagerBadUsageException(this.getClass().getSimpleName(),"subscribe()");
   
		GetCurrentMessageResponse response = null;
		// TODO:
		// 	1°/ get CurrentMessage uuid from TopicManager according to the given Topic expression
		//	2°/ build the GetCurrentMessageResponse and return it
		
		TopicExpressionType topic = request.getTopic();
		
		String curMegUuid = this.topicsMgr.getNotifContentUuid(topic,false);
		
		Message msg = this.notifMessageContentList.get(curMegUuid);

		response = WSNotificationFactory.getInstance().createGetCurrentMessageResponse();
		
		response.setNotifMessageContent(msg);
		
		return response;
	}

	public void setCurrentMessage(TopicExpressionType topic, Message notifMessage) throws WSNotificationException, WSNotificationFault {
		// TODO :
		// 1°/ ask topicManager if a previous currentMessage exists for this topic :
		//	 getCurrentMessageUuid() from TopicManagerMgr and check if it is null or not
		// 2°/ if currentMessageUuid is null then 
		//						- generate new one
		//	   else 
		//						- used the existing one
		// 3°/ store(replace) the pair <uuid,Message> in hasMap
		// 4°/ store/(replace) the currentMessageUuid in the topicManager's "supportedTopicSet base" 
						
		String currentMessageUuid = this.topicsMgr.getNotifContentUuid(topic,true);
	
		if ((currentMessageUuid == null) || (currentMessageUuid.length()==0))
			currentMessageUuid = UUID.randomUUID().toString();		
		this.topicsMgr.storeNotifContentUuid(topic, currentMessageUuid);						
		this.notifMessageContentList.put(currentMessageUuid, notifMessage);		
	}
	
	
	/* (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.service.basenotification.WsnbNotificationProducer#subscribe(com.ebmwebsourcing.wsstar.notification.service.test.wsnotification.base.Subscribe)
	 */
	public SubscribeResponse subscribe(Subscribe request) throws WSNotificationException, WSNotificationFault, WSNotificationExtensionException{
		logger.log(Level.FINE, "performs a \"Subscribe\" request ...");
		//TODO : implement this method !!!
		logger.log(Level.FINE, "\"Subscribe\" method implementation in progress !" );

		if (this.topicsMgr == null)
			throw new WSNotificationTopicManagerBadUsageException(this.getClass().getSimpleName(),"subscribe()");
   
        // ---- temporary code :
		SubscribeResponse reponse = null;
		
		// ---- create new Publisher registration :
		TopicExpressionType topic = request.getFilter().getTopicExpression();
		try {
			
			String subscriptionId = "";
			if (request.getConsumerReference().getReferenceParameters() != null){
				ResourcesUuidType rUuids = WsnSpecificTypeHelper.getResourcesUuidType(request.getConsumerReference().getReferenceParameters());
				if ((rUuids != null) && rUuids.getUuids().size() == 1){
					subscriptionId = rUuids.getUuids().get(0);
				} else
					subscriptionId = UUID.randomUUID().toString();
			} else
				subscriptionId = UUID.randomUUID().toString();
									
			this.topicsMgr.storeNewSubscription(topic, subscriptionId);
			
			EndpointReferenceType subsRef = this.subsMgr.createAndStoreSubscriptionResource(subscriptionId, request); 			
						
			reponse = WSNotificationFactory.getInstance().createSubscribeResponse();
			reponse.setSubscriptionReference(subsRef);
		} catch (WSAddressingException e) {			
			throw new WSNotificationException(e);
		} catch (WSNotificationFault fault) {
			throw fault;
		}
				
		/*
		// ---- Temporaire :
		int randomFault = 0;//RandomUtils.nextInt(13);

		switch (randomFault) {
		case 0:
			try {
				String subscriptionId = "uuid:" + UUID.randomUUID();
				SubscriptionManagerRP subscription = null;
				// ------- Generate UUID as endpoint reference for Subscription :
				EndpointReferenceType subsRef = WSNotificationFactory.getInstance().createEndpointReferenceType();
				subsRef.setAddress(EndpointParameterType.DEFAULT_PETALS_ADDRESS);		

				ReferenceParametersType ref;

				ref = subsRef.newReferenceParameters();

				subsRef.setReferenceParameters(ref);
				EndpointParameterType endpointParam = ref.newEndpointParameterType();
				ref.setEndpointParameterType(endpointParam);	                                    
				endpointParam.setServiceName(this.subscriptionsMgrServiceQName);
				endpointParam.setInterfaceName(this.subscriptionsMgrInterfaceQName);
				endpointParam.setEndpoint(this.subscriptionsMgrEdpAddress);
				endpointParam.addResourceUuid(subscriptionId);

				// -- Create Subscription resource to manage 
				subscription = WSNotificationFactory.getInstance().createSubscriptionManagerRP();
				subscription.setConsumerReference(request.getConsumerReference());
				subscription.setFilter(request.getFilter());
				subscription.setCreationTime((new GregorianCalendar()).getTime());

				this.subscriptions.put(subscriptionId, subscription);			
				reponse = WSNotificationFactory.getInstance().createSubscribeResponse();
				reponse.setSubscriptionReference(subsRef);
			} catch (WSAddressingException e) {			
				throw new WSNotificationException(e);
			}
			break;
		case 1: 
			throw new ResourceUnknownFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE,
					WsnFaultMessageConstants.WsnbSubcribeFaultDescriptions.RESOURCE_UNKNOWN_FAULT_DESC);
		case 2:
			throw new InvalidFilterFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE,
					WsnFaultMessageConstants.WsnbSubcribeFaultDescriptions.INVALID_FILTER_FAULT_DESC);
		case 3:
			throw new TopicExpressionDialectUnknownFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE,
					WsnFaultMessageConstants.WsnbSubcribeFaultDescriptions.TOPIC_EXPRESSION_DIALECT_UNKNOWN_FAULT_DESC);
		case 4:
			throw new InvalidTopicExpressionFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE,
					WsnFaultMessageConstants.WsnbSubcribeFaultDescriptions.INVALID_TOPIC_EXPRESSION_FAULT_DESC);		
		case 5:
			throw new TopicNotSupportedFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE,
					WsnFaultMessageConstants.WsnbSubcribeFaultDescriptions.TOPIC_NOT_SUPPORTED_FAULT_DESC);		
		case 6:
			throw new InvalidProducerPropertiesExpressionFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE,
					WsnFaultMessageConstants.WsnbSubcribeFaultDescriptions.INVALID_PRODUCER_PROPERTIES_EXPRESSION_FAULT_DESC);		
		case 7:
			throw new InvalidMessageContentExpressionFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE,
					WsnFaultMessageConstants.WsnbSubcribeFaultDescriptions.INVALID_MESSAGE_CONTENT_EXPRESSION_FAULT_DESC);		
		case 8:
			throw new UnrecognizedPolicyRequestFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE,
					WsnFaultMessageConstants.WsnbSubcribeFaultDescriptions.UNRECOGNIZED_POLICY_REQUEST_FAULT_DESC);		
		case 9:
			throw new UnsupportedPolicyRequestFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE,
					WsnFaultMessageConstants.WsnbSubcribeFaultDescriptions.UNSUPPORTED_POLICY_REQUEST_FAULT_DESC);		
		case 10:
			throw new NotifyMessageNotSupportedFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE,
					WsnFaultMessageConstants.WsnbSubcribeFaultDescriptions.NOTIFY_MESSAGE_NOT_SUPPORTED_FAULT_DESC);					
		case 11:
			throw new UnacceptableInitialTerminationTimeFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE,
					WsnFaultMessageConstants.WsnbSubcribeFaultDescriptions.UNACCEPTABLE_INITIAL_TERMINATION_TIME_FAULT_DESC);		
		case 12:
			throw new SubscribeCreationFailedFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE,
					WsnFaultMessageConstants.WsnbSubcribeFaultDescriptions.SUBSCRIBE_CREATION_FAILED_FAULT_DESC);		
		}*/
		return reponse;
	}
	
}
