/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.service.topic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map.Entry;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.XPath;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;

import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class XPathAnalyzer {

	private static Logger log = Logger.getLogger(XPathAnalyzer.class.getName());

	private XPath engine;

	private NamespaceContext xpathContext;

	public XPathAnalyzer() {

	}

	public /*Element*/List<?> evaluate(final String xpathExpression, final Element source, final NamespaceMapperImpl context) throws WSNotificationException {
		final List<String> xpathExpressions = new ArrayList<String>();
		xpathExpressions.add(xpathExpression);
		return this.evaluate(xpathExpressions, source, context);
	}

	public /*Element*/List<?> evaluate(final List<String> xpathExpressions, final Element source, final NamespaceMapperImpl context) throws WSNotificationException {
		List<?> target = null;
		//Element target = null;
		try {
			if(source != null) {
				for(final String xpathExpression: xpathExpressions) {
					this.engine = new JDOMXPath(xpathExpression);

					this.xpathContext = new SimpleNamespaceContext();

					for(final Entry<String, String> entry: context.getNamespaces().entrySet()) {
						((SimpleNamespaceContext)this.xpathContext).addNamespace(entry.getKey(), entry.getValue());
					}

					this.engine.setNamespaceContext(this.xpathContext);

					final Object res = this.engine.selectNodes(source);
					if (res instanceof List) {
						target = (List<?>)res;
						if (log.isLoggable(Level.FINE)) {
							log.fine("this xpath expression " + xpathExpression + " matchs with: \n " + new XMLOutputter(Format.getPrettyFormat()).outputString(source));
						}
						break;
					}
				}
				if (target == null && log.isLoggable(Level.FINE)) {
					log.fine("No xpath expressions " + xpathExpressions + " match with: \n " + new XMLOutputter(Format.getPrettyFormat()).outputString(source));
				}
			}
		} catch (final JaxenException e) {
			throw new WSNotificationException(e);
		}

		return target;
	}

}
