/**
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction;

import java.net.URI;
import java.util.List;

import org.w3c.dom.Element;

/**
 * Interface related to "EndpointReferenceType" WS-Addressing type
 * Thought to be the most "user-friendly" as possible according to
 * WS-Addressing specification content and especially its associated
 * XML Schema 
 * 
 * @author Thierry Déjean - EBM Websourcing
 */
public interface EndpointReferenceType {

	/**
	 * Get the endpoint address value
	 * 
	 * Note : never null according to WS-Addressing specification 
	 * 
	 * @return the endpoint address value as an {@link URI} object 
	 */
	URI getAddress();

	/**
	 * Set the endpoint address value
	 *  
	 * Note : must not be null according to WS-Addressing specification 
	 * 
	 * @param the address value, provided as {@link URI} to set
	 */
	void setAddress(URI value);

	/**
	 * Get the endpoint reference parameters value
	 * 
	 * @return the reference parameters value as a {@link ReferenceParametersType} object 
	 */
	ReferenceParametersType getReferenceParameters();
	
	/**
	 * Set the endpoint reference parameters value 
	 * 
	 * @param the reference parameter value, provided as {@link ReferenceParametersType} to set
	 */
	void setReferenceParameters(ReferenceParametersType value);

	/**
	 * Get the endpoint metadata value
	 * 
	 * @return the metadata value as a {@link MetadataType} object 
	 */
	MetadataType getMetadata();

	/**
	 * Set the endpoint metadata value 
	 * 
	 * @param the metadata value, provided as {@link MetadataType} to set
	 */
	void setMetadata(MetadataType value);

	/**
	 * Get the endpoint extensions elements
	 * 
	 * @return list of endpoint extensions as list of {@link Element} objects
	 */
	List<Element> getAny();

	/**
	 * Add an endpoint extension element
	 * 
	 * @param anyAsElt the extension to add, provided as a {@link Element} object
	 */
	void addAny(Element anyAsElt);

	/**
	 * Add a list of endpoint extension elements
	 *	
	 * @param anyAsElts the list of extension - as list of {@Element} - to add
	 */
	void addAllAny(List<Element> anyAsElts); 

}
