/**
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction;

import java.io.File;
import java.net.URI;

import org.w3c.dom.Document;
import org.xml.sax.InputSource;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.utils.WsaException;

/**
 * Interface of the Reader that must provide methods to "unmarshall" WS-Addressing
 * types from common representation formats : {@link Document},{@link File},....     
 * These methods can be seen as "input methods"
 * 
 * @author Thierry Déjean - EBM Websourcing
 *
 */
public interface WsaReader {

	/**
	 * Unmarshall a {@link EndpointReferenceType} object from
	 * its {@link Document} representation.
	 * 
	 * @param document the {@link Document} representation of the endpoint 
	 * @return the unmarshalled endpoint associated to the given {@link Document} representation
	 * @throws WsaException
	 */
	EndpointReferenceType readEndpointReferenceType(Document document) throws WsaException;
	
	/**
	 * Unmarshall a {@link EndpointReferenceType} object from
	 * its {@link InputSource} representation.
	 * 
	 * @param source the {@link InputSource} representation of the endpoint
	 * @return the unmarshalled endpoint associated to the given {@link InputSource} representation
	 * @throws WsaException
	 */
	EndpointReferenceType readEndpointReferenceType(InputSource source) throws WsaException;
	
	/**
	 * Unmarshall a {@link EndpointReferenceType} object from
	 * its {@link File} representation.
	 * 
	 * Note : method that can be used to implement persistence mechanism
	 * 
	 * @param file the {@link File} representation of the endpoint
	 * @return unmarshalled endpoint associated to the given {@link File} representation
	 * @throws WsaException
	 */
	EndpointReferenceType readEndpointReferenceType(File file) throws WsaException;
	
	/**
	 * Unmarshall a {@link EndpointReferenceType} object from
	 * a reprensetation located at a specific {@link URI}
	 * 
	 * @param uri the location, provided as an {@link URI}, of the endpoint representation 
	 * @return unmarshalled endpoint associated the representation located at the given {@link URI}
	 * @throws WsaException
	 */
	EndpointReferenceType readEndpointReferenceType(URI uri) throws WsaException;
}
