/**
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction;

import org.w3c.dom.Document;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.utils.WsaException;

/**
 * Interface of the Writer that must provide methods to "marshall" WS-Addressing
 * types to common representation formats : {@link Document},{@link File},....     
 * These methods can be seen as "output methods"
 * 
 * @author Thierry Déjean - EBM Websourcing
 *
 */
public interface WsaWriter {

	/**
	 * marshall a {@link EndpointReferenceType} object to  a {@link Document} representation object.
	 * 
	 * @param endpoint the {@link EndpointReferenceType} object to marshall
	 * @return an {@link Document} representation object of the endpoint
	 * @throws WsaException
	 */
	Document writeEndpointReferenceTypeAsDOM(EndpointReferenceType endpoint) throws WsaException;
	
	/**
	 * marshall a {@link EndpointReferenceType} object to  a {@link String} representation object.
	 *
	 * @param endpoint the {@link EndpointReferenceType} object to marshall
	 * @return an {@link String} representation object of the endpoint
	 * @throws WsaException
	 */
	String writeEndpointReferenceTypeAsString(EndpointReferenceType endpoint) throws WsaException;
	
	/**
	 * marshall a {@link EndpointReferenceType} object as a {@link File} representation 
	 * and write it to File System
	 * 
	 * @param endpoint the {@link EndpointReferenceType} object to marshall
	 * @param path the path - location on the filesystem - where the endpoint must be written 
	 * @throws WsaException
	 */
	void writeEndpointReferenceTypeToFilesystem(EndpointReferenceType endpoint,String path) throws WsaException;
	
}
