/**
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.addressing.datatypes.api.implementor;

import java.net.URI;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.MetadataType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.WsaReader;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.WsaWriter;

/**
 * Interface of the "model's factory" that must provide creation methods
 * of WS-Addressing Types, called by the "RefinedAbstraction"(see "Bridge"
 * design pattern details for more details ).
 * Mainly expected methods are those which help to build {@link EndpointReferenceType}, 
 * {@link ReferenceParametersType} and {@link MetadataType} typed objects.
 * Also provide getters for {@link WsaReader} and {WsaWriter} objects.
 * 
 * NOTE : the "model's factory" is implemented following the "Bridge" design pattern
 * and the "WsaModelFactory" class represents the "implementor" part    
 * 
 * @author Thierry Déjean - EBM Websourcing
 *
 */
public interface WsaModelFactory {
	
	/**
	 * create a minimal {@link EndpointReferenceType} object, respect to
	 * "model implementation", with only mandatory fields set
	 *  
	 * @param address of the endpoint to create, as a {@link URI} object   
	 * 
	 * @return an {@link EndpointReferenceType} object with address set
	 */
	EndpointReferenceType createWsaModelEndpointReferenceType(URI address);
	
	/**
	 * create a minimal - means empty - {@link EndpointReferenceType} object,
	 * respect to "model implementation"
	 * 
	 * @return an empty {@link ReferenceParametersType} object
	 */
	ReferenceParametersType createWsaModelReferenceParametersType();

	/**
	 * create a minimal - means empty - {@link MetadataType} object,
	 * respect to "model implementation"
	 * 
	 * @return an empty {@link MetadataType} object
	 */
	MetadataType createWsaModelMetadataType();
	
	/**
	 * Get a instance of {@link WsaReader} class ,
	 * respect to "model implementation"
	 * 
	 * @return an instance of of {@link WsaReader} class
	 */
	WsaReader getWsaModelReader();
	
	/**
	 * Get a instance of {@link WsaWriter} class,
	 * respect to "model implementation"
	 * 
	 * @return an instance of of {@link WsaWriter} class
	 */
	WsaWriter getWsaModelWriter();
}
