/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.addressing.datatypes.api.test;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.MetadataType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.WsaFactory;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.WsaReader;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.WsaWriter;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.implementor.WsaModelFactory;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.refinedabstraction.RefinedWsaFactory;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.test.WsaUnitTestsUtils;
import com.ebmwebsourcing.wsstar.addressing.datatypes.api.utils.WsaException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.UUID;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class AbsWsaTypesUnitTests
extends TestCase {
    protected boolean isDebug = false;
    private WsaFactory factory;
    protected WsaModelFactory modelFactoryImpl;
    private WsaReader reader;
    private WsaWriter writer;

    protected void setUp() throws Exception {
        super.setUp();
        this.initRefinedWsaFactory();
    }

    protected abstract void setWsaModelFactory();

    public final void initRefinedWsaFactory() {
        if (this.modelFactoryImpl == null) {
            this.setWsaModelFactory();
        }
        AbsWsaTypesUnitTests.assertNotNull((String)(WsaUnitTestsUtils.getFailedMessagePrefix("W3C \"WS-Addressing\"") + "the \"WsaModelFactory\" implementation Object has not been set.\n" + "Please provide an instance of \"WsaModelFactory\" implementatio class"), (Object)this.modelFactoryImpl);
        if (this.factory == null) {
            this.factory = RefinedWsaFactory.getInstance((WsaModelFactory)this.modelFactoryImpl);
        }
        if (this.reader == null) {
            this.reader = this.factory.getWsaReader();
        }
        if (this.writer == null) {
            this.writer = this.factory.getWsaWriter();
        }
    }

    protected final EndpointReferenceType createDefaultEndpointReferenceType() {
        EndpointReferenceType result = null;
        URI edpAddress = null;
        try {
            edpAddress = new URI("http://myURL/for/test::MyServiceName@myEndpointAddress");
            result = this.factory.createEndpointReferenceType(edpAddress);
            ReferenceParametersType refParam = this.factory.createReferenceParametersType();
            WsaUnitTestsUtils.addSomeReferenceParameters(refParam);
            result.setReferenceParameters(refParam);
            MetadataType metadata = this.factory.createMetadataType();
            WsaUnitTestsUtils.addSomeMetadata(metadata);
            result.setMetadata(metadata);
            WsaUnitTestsUtils.addSomeExtensions(result);
            Assert.assertNotNull((String)(WsaUnitTestsUtils.getFailedMessagePrefix("W3C \"WS-Addressing\"") + "The \"createEndpointReferenceType(...)\" methode of the factory has return a null Object !!"), (Object)result);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static final void checkEndpointReferenceType(EndpointReferenceType expectedEdp, EndpointReferenceType toCheckEdp, String specificationRef, boolean isDebug) {
        URI expectedURI = expectedEdp.getAddress();
        URI toCheckURI = toCheckEdp.getAddress();
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckEndpoint address : " + toCheckURI.toString() + "\n[DEBUG] --> expectedEndpoint address : " + expectedURI.toString() + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix(specificationRef) + "endpoints have different address values\n" + "\t(-> toCheckEdp address : " + toCheckURI.toString() + "\n\t-> expectedEdp address : " + expectedURI.toString() + ")"), (boolean)toCheckURI.equals(expectedURI));
        ReferenceParametersType expectedRefParams = expectedEdp.getReferenceParameters();
        ReferenceParametersType toCheckRefParams = toCheckEdp.getReferenceParameters();
        List expectedRefParList = expectedRefParams != null ? expectedRefParams.getAny() : null;
        List toCheckRefParList = toCheckRefParams != null ? toCheckRefParams.getAny() : null;
        int expectedRefParmaCount = expectedRefParList != null ? expectedRefParList.size() : -1;
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix(specificationRef) + "endpoints have different referenceParameters values\n" + "\t(-> toCheckEdp referenceParameters count : " + (toCheckRefParList != null ? Integer.valueOf(toCheckRefParList.size()) : "none") + "\n\t-> expectedEdp referenceParameters count : " + (expectedRefParmaCount == -1 ? "none" : Integer.valueOf(expectedRefParmaCount)) + ")"), (toCheckRefParList == null && expectedRefParList == null || toCheckRefParList.size() == expectedRefParmaCount ? 1 : 0) != 0);
        for (int i = 0; i < expectedRefParmaCount; ++i) {
            String toCheckRefParamItem = WsaUnitTestsUtils.formatToComparison((Element)toCheckRefParList.get(i));
            String expectedRefParamItem = WsaUnitTestsUtils.formatToComparison((Element)expectedRefParList.get(i));
            if (isDebug) {
                System.out.println("[DEBUG] --> toCheckRefParamItem : " + toCheckRefParamItem + "\n[DEBUG] --> expectedRefParamItem : " + expectedRefParamItem + "\n");
            }
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix(specificationRef) + "endpoints references parametes content are different \n" + "\t(-> toCheckEdp referenceParameter #" + i + " : " + toCheckRefParamItem + "\n\t-> expectedEdp referenceParameter #" + i + " : " + expectedRefParamItem + ")"), (boolean)toCheckRefParamItem.equals(expectedRefParamItem));
        }
        MetadataType expectedMetadata = expectedEdp.getMetadata();
        MetadataType toCheckMetadata = toCheckEdp.getMetadata();
        List expectedMetadataList = expectedMetadata != null ? expectedMetadata.getAny() : null;
        List toCheckMetadataList = toCheckMetadata != null ? toCheckMetadata.getAny() : null;
        int expectedMetadataCount = expectedMetadataList != null ? expectedMetadataList.size() : -1;
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix(specificationRef) + "endpoints have different metadata values\n" + "\t(-> toCheckEdp metadata count : " + (toCheckMetadataList != null ? Integer.valueOf(toCheckMetadataList.size()) : "none") + "\n\t-> expectedEdp metadata count : " + (expectedMetadataCount == -1 ? "none" : Integer.valueOf(expectedMetadataCount)) + ")"), (toCheckMetadataList == null && expectedMetadataList == null || toCheckMetadataList.size() == expectedMetadataCount ? 1 : 0) != 0);
        for (int i = 0; i < expectedMetadataCount; ++i) {
            String toCheckMetadataItem = WsaUnitTestsUtils.formatToComparison((Element)toCheckMetadataList.get(i));
            String expectedMetadataItem = WsaUnitTestsUtils.formatToComparison((Element)expectedMetadataList.get(i));
            if (isDebug) {
                System.out.println("[DEBUG] --> toCheckMetadataItem : " + toCheckMetadataItem + "\n[DEBUG] --> expectedMetadataItem : " + expectedMetadataItem + "\n");
            }
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix(specificationRef) + "endpoints metadata content are different \n" + "\t(-> toCheckEdp metadata item #" + i + " : " + toCheckMetadataItem + "\n\t-> expectedEdp metadata item #" + i + " : " + expectedMetadataItem + ")"), (boolean)toCheckMetadataItem.equals(expectedMetadataItem));
        }
        List expectedAnyList = expectedEdp.getAny();
        List toCheckAnyList = toCheckEdp.getAny();
        int expectedAnyCount = expectedAnyList != null ? expectedAnyList.size() : -1;
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix(specificationRef) + "endpoints have different metadata values\n" + "\t(-> toCheckEdp extensions count : " + (toCheckAnyList != null ? Integer.valueOf(toCheckAnyList.size()) : "none") + "\n\t-> expectedEdp extensions count : " + (expectedAnyCount == -1 ? "none" : Integer.valueOf(expectedAnyCount)) + ")"), (toCheckAnyList == null && expectedAnyList == null || toCheckAnyList.size() == expectedAnyCount ? 1 : 0) != 0);
        for (int i = 0; i < expectedAnyCount; ++i) {
            String toCheckAnyItem = WsaUnitTestsUtils.formatToComparison((Element)toCheckAnyList.get(i));
            String expectedAnyItem = WsaUnitTestsUtils.formatToComparison((Element)expectedAnyList.get(i));
            if (isDebug) {
                System.out.println("[DEBUG] --> toCheckAnyItem : " + toCheckAnyItem + "\n[DEBUG] --> expectedAnyItem : " + expectedAnyItem + "\n");
            }
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix(specificationRef) + "endpoints metadata content are different \n" + "\t(-> toCheckEdp extension item #" + i + " : " + toCheckAnyItem + "\n\t-> expectedEdp extension item #" + i + " : " + expectedAnyItem + ")"), (boolean)toCheckAnyItem.equals(expectedAnyItem));
        }
    }

    @Test
    public final void testCreateWriteAsDOMReadEnpointReferenceType() throws WsaException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM EndpointReferenceType\" ~~~~~~~ \n");
        EndpointReferenceType defaultCreatedEdp = this.createDefaultEndpointReferenceType();
        Document endpointAsDOM = this.writer.writeEndpointReferenceTypeAsDOM(defaultCreatedEdp);
        try {
            WsaUnitTestsUtils.validateResult(endpointAsDOM, WsaUnitTestsUtils.WSA_XML_SCHEMAS_PATHS, "W3C \"WS-Addressing\"", EndpointReferenceType.class, this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix("W3C \"WS-Addressing\"") + e.getMessage()));
        }
        EndpointReferenceType readEndpointReference = this.reader.readEndpointReferenceType(endpointAsDOM);
        AbsWsaTypesUnitTests.checkEndpointReferenceType(defaultCreatedEdp, readEndpointReference, "W3C \"WS-Addressing\"", this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM EndpointReferenceType\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteToFSReadFromFSEnpointReferenceType() {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-Filesystem and read-from-Filesystem EndpointReferenceType\" ~~~~~~~ \n");
        try {
            File persistenceRepository = WsaUnitTestsUtils.createTempTestDirectory("SaveEndpointReference");
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix("W3C \"WS-Addressing\"") + "the persistence directory has not been found on filesystem !"), (persistenceRepository.exists() && persistenceRepository.isDirectory() ? 1 : 0) != 0);
            EndpointReferenceType defaultCreatedEdp = this.createDefaultEndpointReferenceType();
            String endpointFileName = "endpoint-" + UUID.randomUUID().toString();
            this.writer.writeEndpointReferenceTypeToFilesystem(defaultCreatedEdp, persistenceRepository.getAbsolutePath() + File.separatorChar + endpointFileName);
            File endpointAsFile = new File(persistenceRepository.getAbsolutePath() + File.separatorChar + endpointFileName);
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix("W3C \"WS-Addressing\"") + "The endpoint has not been written on Filesystem\n" + "\tNo file named \"" + endpointFileName + "\" has been found"), (endpointAsFile.exists() && endpointAsFile.length() > 0L ? 1 : 0) != 0);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to Filesystem\") passed !\n");
            EndpointReferenceType readEndpointReference = this.reader.readEndpointReferenceType(endpointAsFile);
            AbsWsaTypesUnitTests.checkEndpointReferenceType(defaultCreatedEdp, readEndpointReference, "W3C \"WS-Addressing\"", this.isDebug);
            System.out.println("\t Unit Test Step 2 (\"read from Filesystem\") passed !");
            if (!this.isDebug) {
                WsaUnitTestsUtils.deleteExistingTestDirectory(persistenceRepository);
            }
            System.out.println("\n\t OK, unit test \"Create, Write-to-Filesystem and read-from-Filesystem EndpointReferenceType\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
        }
        catch (WsaException e) {
            e.printStackTrace();
        }
    }
}

