package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import org.w3c.dom.Element;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.impl.impl.EndpointReferenceTypeImpl;
import com.ebmwebsourcing.wsstar.addressing.datatypes.impl.utils.WsaUtils;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.WsnbJAXBContext;

public class NotificationMessageHolderTypeImpl implements
		NotificationMessageHolderType {

	private com.ebmwebsourcing.wsstar.jaxb.notification.base.NotificationMessageHolderType jaxbTypeObj;
//	private static Logger logger  = Logger.getLogger(NotificationMessageHolderTypeImpl.class.getSimpleName());
	
	/**
	 * Default constructor
	 */
	protected NotificationMessageHolderTypeImpl(Message message) {		
		this.jaxbTypeObj = WsnbJAXBContext.WSNB_JAXB_FACTORY.createNotificationMessageHolderType();
		this.jaxbTypeObj.setMessage(NotificationMessageHolderTypeImpl.MessageImpl.toJaxbModel(message));
		
	}

	protected NotificationMessageHolderTypeImpl(com.ebmwebsourcing.wsstar.jaxb.notification.base.NotificationMessageHolderType jaxbTypeObj){
		this.jaxbTypeObj = jaxbTypeObj;
	}
	
	protected final com.ebmwebsourcing.wsstar.jaxb.notification.base.NotificationMessageHolderType getJaxbTypeObj() {
		return jaxbTypeObj;
	}
	
	@Override
	public final TopicExpressionType getTopic() {
		com.ebmwebsourcing.wsstar.jaxb.notification.base.TopicExpressionType fromJaxbModel = this.jaxbTypeObj.getTopic();		
		return (fromJaxbModel!=null)?new TopicExpressionTypeImpl(fromJaxbModel):null;
	}

	@Override
	public final void setTopic(TopicExpressionType concreteTopic) {
		this.jaxbTypeObj.setTopic(TopicExpressionTypeImpl.toJaxbModel(concreteTopic));
	}

	@Override
	public final Message getMessage() {		
		return new NotificationMessageHolderTypeImpl.MessageImpl(this.jaxbTypeObj.getMessage());
	}

	@Override
	public final void setMessage(Message msg) {
		this.jaxbTypeObj.setMessage(NotificationMessageHolderTypeImpl.MessageImpl.toJaxbModel(msg));
	}

	@Override
	public final EndpointReferenceType getSubscriptionReference() {			
		return WsaUtils.fromJaxbModelEndpointToApiEndpoint(this.jaxbTypeObj.getSubscriptionReference(), this.getClass());		
	}

	@Override
	public final void setSubscriptionReference(EndpointReferenceType endpoint) {
		this.jaxbTypeObj.setSubscriptionReference(EndpointReferenceTypeImpl.toJaxbModel(endpoint));
	}

	@Override
	public final EndpointReferenceType getProducerReference() {		
		return WsaUtils.fromJaxbModelEndpointToApiEndpoint(this.jaxbTypeObj.getProducerReference(),this.getClass());
	}

	@Override
	public final void setProducerReference(EndpointReferenceType endpoint) {
		this.jaxbTypeObj.setProducerReference(EndpointReferenceTypeImpl.toJaxbModel(endpoint));
	}

	/**
	 * A way to create a  {@link com.ebmwebsourcing.wsstar.jaxb.notification.base.NotificationMessageHolderType}
	 *  "Jaxb model type" object from a {@link NotificationMessageHolderType} "api type" one  
	 * @param apiTypeObj
	 * @return
	 */
	public static com.ebmwebsourcing.wsstar.jaxb.notification.base.NotificationMessageHolderType toJaxbModel(
			NotificationMessageHolderType apiTypeObj) {
		com.ebmwebsourcing.wsstar.jaxb.notification.base.NotificationMessageHolderType jaxbTypeObj = null;
		
		if (apiTypeObj instanceof NotificationMessageHolderTypeImpl){
			jaxbTypeObj = ((NotificationMessageHolderTypeImpl)apiTypeObj).getJaxbTypeObj();
		}
		else {
			jaxbTypeObj = WsnbJAXBContext.WSNB_JAXB_FACTORY.createNotificationMessageHolderType();
			
			// ~~~~ Set Message ~~~~~
			jaxbTypeObj.setMessage(NotificationMessageHolderTypeImpl.MessageImpl.toJaxbModel(apiTypeObj.getMessage()));
			
			// ~~~~ Set Topic (optional) ~~~~~
			TopicExpressionType topicExpr = apiTypeObj.getTopic();
			if (topicExpr != null){
				jaxbTypeObj.setTopic(TopicExpressionTypeImpl.toJaxbModel(topicExpr)); 
			}
			// ~~~~ Set ProducerReference (optional) ~~~~~
			EndpointReferenceType producerRef = apiTypeObj.getProducerReference();
			if (producerRef != null){	
				jaxbTypeObj.setProducerReference(EndpointReferenceTypeImpl.toJaxbModel(producerRef));
			}
			// ~~~~ Set SubscriptionReference (optional) ~~~~~
			EndpointReferenceType subscriptionRef = apiTypeObj.getSubscriptionReference();
			if (subscriptionRef != null){
				jaxbTypeObj.setSubscriptionReference(EndpointReferenceTypeImpl.toJaxbModel(subscriptionRef));
			}
		}
		return jaxbTypeObj;
	}
	
	public static class MessageImpl implements NotificationMessageHolderType.Message {
		
		private com.ebmwebsourcing.wsstar.jaxb.notification.base.NotificationMessageHolderType.Message jaxbTypeObj;
		//private static Logger logger  = Logger.getLogger(NotificationMessageHolderTypeImpl.MessageImpl.class.getSimpleName());
		
		/**
		 * Default constructor
		 */
		protected MessageImpl(Element content) {		
			this.jaxbTypeObj = WsnbJAXBContext.WSNB_JAXB_FACTORY.createNotificationMessageHolderTypeMessage();
			this.jaxbTypeObj.setAny(content);		
		}

		protected MessageImpl(com.ebmwebsourcing.wsstar.jaxb.notification.base.NotificationMessageHolderType.Message jaxbTypeObj){
			this.jaxbTypeObj = jaxbTypeObj;
		}
		
		protected final com.ebmwebsourcing.wsstar.jaxb.notification.base.NotificationMessageHolderType.Message getJaxbTypeObj() {
			return jaxbTypeObj;
		}
		
		@Override
		public final Element getAny() {
			Object jaxbAny = this.jaxbTypeObj.getAny();
			return (jaxbAny instanceof Element)?(Element)jaxbAny:null;
		}

		@Override
		public final void setAny(Element value) {
			this.jaxbTypeObj.setAny(value);
		}
		
		/**
		 * A way to create a  {@link com.ebmwebsourcing.wsstar.jaxb.notification.base.NotificationMessageHolderType.Message}
		 *  "Jaxb model type" object from a {@link NotificationMessageHolderType.Message} "api type" one  
		 * @param apiTypeObj
		 * @return
		 */
		public static com.ebmwebsourcing.wsstar.jaxb.notification.base.NotificationMessageHolderType.Message toJaxbModel(
				Message apiTypeObj) {
			com.ebmwebsourcing.wsstar.jaxb.notification.base.NotificationMessageHolderType.Message jaxbTypeObj = null;
			
			if (apiTypeObj instanceof NotificationMessageHolderTypeImpl.MessageImpl) {
				jaxbTypeObj = ((NotificationMessageHolderTypeImpl.MessageImpl)apiTypeObj).getJaxbTypeObj();
			} else {
				jaxbTypeObj = WsnbJAXBContext.WSNB_JAXB_FACTORY.createNotificationMessageHolderTypeMessage();
				
				jaxbTypeObj.setAny(apiTypeObj.getAny());				
			}
			return jaxbTypeObj;
		}
		
	}
	
}
