package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import java.util.Date;
import java.util.logging.Logger;

import javax.xml.datatype.XMLGregorianCalendar;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.abstraction.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.datatypes.impl.impl.EndpointReferenceTypeImpl;
import com.ebmwebsourcing.wsstar.addressing.datatypes.impl.utils.WsaUtils;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.WsnbJAXBContext;

public class SubscribeResponseImpl implements SubscribeResponse {

	private com.ebmwebsourcing.wsstar.jaxb.notification.base.SubscribeResponse jaxbTypeObj;
	private static Logger logger  = Logger.getLogger(SubscribeResponseImpl.class.getSimpleName());
	
	/**
	 * Default constructor
	 */
	protected SubscribeResponseImpl(EndpointReferenceType subscriptionRef) {		
		this.jaxbTypeObj = WsnbJAXBContext.WSNB_JAXB_FACTORY.createSubscribeResponse();		
		this.jaxbTypeObj.setSubscriptionReference(EndpointReferenceTypeImpl.toJaxbModel(subscriptionRef));
	}

	protected SubscribeResponseImpl(com.ebmwebsourcing.wsstar.jaxb.notification.base.SubscribeResponse jaxbTypeObj){
		this.jaxbTypeObj = jaxbTypeObj;
	}
	
	protected final com.ebmwebsourcing.wsstar.jaxb.notification.base.SubscribeResponse getJaxbTypeObj() {
		return jaxbTypeObj;
	}
	
	@Override
	public final Date getCurrentTime() {
		Date currentTime = null;
		XMLGregorianCalendar jaxbCurrTime = this.jaxbTypeObj.getCurrentTime();
		if (jaxbCurrTime != null){
			currentTime = jaxbCurrTime.toGregorianCalendar().getTime();
		}
		return currentTime;
	}

	@Override
	public final void setCurrentTime(Date value) {
		this.jaxbTypeObj.setCurrentTime(WsrfbfUtils.toXMLGregorianCalendar(value, SubscribeResponseImpl.logger));
	}

	@Override
	public final EndpointReferenceType getSubscriptionReference() {
		return WsaUtils.fromJaxbModelEndpointToApiEndpoint(this.jaxbTypeObj.getSubscriptionReference(),this.getClass());
	}

	@Override
	public final void setSubscriptionReference(EndpointReferenceType value) {
		this.jaxbTypeObj.setSubscriptionReference(EndpointReferenceTypeImpl.toJaxbModel(value));
	}

	@Override
	public final Date getTerminationTime() {
		Date terminationTime = null;
		XMLGregorianCalendar jaxbTermTime = this.jaxbTypeObj.getTerminationTime();
		if (jaxbTermTime != null){
			terminationTime = jaxbTermTime.toGregorianCalendar().getTime();
		}
		return terminationTime;
	}

	@Override
	public final void setTerminationTime(Date termTime) {
		this.jaxbTypeObj.setTerminationTime(WsrfbfUtils.toXMLGregorianCalendar(termTime, SubscribeResponseImpl.logger));
	}
	
	/**
	 * A way to create a  {@link com.ebmwebsourcing.wsstar.notification.base.SubscribeResponse}
	 *  "Jaxb model type" object from a {@link SubscribeResponse} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static com.ebmwebsourcing.wsstar.jaxb.notification.base.SubscribeResponse toJaxbModel(SubscribeResponse apiTypeObj) {

		com.ebmwebsourcing.wsstar.jaxb.notification.base.SubscribeResponse jaxbTypeObj = null;
		
		if (apiTypeObj instanceof SubscribeResponseImpl){
			jaxbTypeObj = ((SubscribeResponseImpl)apiTypeObj).getJaxbTypeObj();
		} else { 
			jaxbTypeObj = WsnbJAXBContext.WSNB_JAXB_FACTORY.createSubscribeResponse();

			// ~~~~ set SubscriptionReference ~~~~
			jaxbTypeObj.setSubscriptionReference(EndpointReferenceTypeImpl.toJaxbModel(apiTypeObj.getSubscriptionReference()));
			
			// ~~~~ Set CurrentTime ~~~~~
			Date apiCurrentTime = apiTypeObj.getCurrentTime();
			if (apiCurrentTime != null){
				jaxbTypeObj.setCurrentTime(WsrfbfUtils.toXMLGregorianCalendar(apiCurrentTime,SubscribeResponseImpl.logger));
			}
			//~~~~~ Set TerminationTime ~~~~~
			Date apiTerminationTime = apiTypeObj.getTerminationTime();
			if (apiTerminationTime != null){
				jaxbTypeObj.setTerminationTime(WsrfbfUtils.toXMLGregorianCalendar(apiTerminationTime,SubscribeResponseImpl.logger));
			}
		}
		return jaxbTypeObj;
	}
}
