/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java;

import java.io.IOException;
import java.io.InputStream;
import org.ws4d.java.attachment.AttachmentException;
import org.ws4d.java.attachment.AttachmentFactory;
import org.ws4d.java.attachment.AttachmentStore;
import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.CommunicationManagerRegistry;
import org.ws4d.java.communication.TimeoutException;
import org.ws4d.java.communication.monitor.MonitorStreamFactory;
import org.ws4d.java.communication.monitor.ResourceLoader;
import org.ws4d.java.concurrency.ThreadPool;
import org.ws4d.java.configuration.FrameworkProperties;
import org.ws4d.java.configuration.Properties;
import org.ws4d.java.dispatch.DeviceServiceRegistry;
import org.ws4d.java.dispatch.MessageInformer;
import org.ws4d.java.eventing.ClientSubscription;
import org.ws4d.java.eventing.EventingException;
import org.ws4d.java.eventing.EventingFactory;
import org.ws4d.java.io.fs.FileSystem;
import org.ws4d.java.presentation.Presentation;
import org.ws4d.java.security.SecurityManager;
import org.ws4d.java.service.ProxyFactory;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.Toolkit;
import org.ws4d.java.util.WS4DIllegalStateException;
import org.ws4d.java.util.WatchDog;

public final class DPWSFramework {
    public static final int CLIENT_MODULE = 1;
    public static final int SERVICE_MODULE = 2;
    public static final int EVENTING_MODULE = 4;
    public static final int PLATFORM_SE_MODULE = 8;
    public static final int PLATFORM_CLDC_MODULE = 16;
    public static final int ATTACHMENT_MODULE = 32;
    public static final int SECURITY_MODULE = 64;
    public static final int PRESENTATION_MODULE = 128;
    public static final int COMMUNICATION_DPWS_MODULE = 256;
    private static final boolean HAVE_CLIENT_MODULE;
    private static final boolean HAVE_SERVICE_MODULE;
    private static final boolean HAVE_EVENTING_MODULE;
    private static final boolean HAVE_PLATFORM_SE_MODULE;
    private static final boolean HAVE_PLATFORM_CLDC_MODULE;
    private static final boolean HAVE_ATTACHMENT_MODULE;
    private static final boolean HAVE_PRESENTATION_MODULE;
    private static final boolean HAVE_COMMUNICATION_DPWS_MODULE;
    private static final boolean HAVE_SECURITY_MODULE;
    private static final int KILL_WAIT_TIME = 2000;
    private static final Object LOCAL_FILE_SYSTEM_LOCK;
    private static final Object ATTACHMENT_FACTORY_LOCK;
    private static final Object EVENTING_FACTORY_LOCK;
    private static final Object PROXY_FACTORY_LOCK;
    private static volatile boolean running;
    private static ThreadPool threadpool;
    private static final Properties properties;
    private static MonitorStreamFactory monitorFactory;
    private static Toolkit toolkit;
    private static FileSystem localFileSystem;
    private static AttachmentFactory attachmentFactory;
    private static EventingFactory eventingFactory;
    private static ProxyFactory proxyFactory;
    private static SecurityManager securityManager;
    private static Presentation presentation;
    private static String propertiesPath;
    private static HashSet subscriptions;
    private static int haltPhase;
    private static boolean killingThread;

    public static synchronized void start(String[] stringArray) {
        if (running) {
            return;
        }
        try {
            CommunicationManagerRegistry.loadAll();
            if (stringArray != null && stringArray.length >= 1) {
                propertiesPath = stringArray[0];
            }
            if (propertiesPath != null) {
                try {
                    properties.init(propertiesPath);
                }
                catch (Exception exception) {
                    Log.printStackTrace(exception);
                }
            } else {
                properties.init();
            }
            threadpool = new ThreadPool(FrameworkProperties.getInstance().getThreadPoolSize());
            DPWSFramework.createToolkit();
            boolean bl = DPWSFramework.getThreadPool().executeOrAbort(WatchDog.getInstance());
            if (!bl) {
                throw new RuntimeException("Cannot start the watchdog.");
            }
            MessageInformer.getInstance().start();
            CommunicationManagerRegistry.startAll();
            running = true;
            Log.info("DPWS Framework ready.");
        }
        catch (Exception exception) {
            Log.info("DPWS Framework not started.");
            Log.printStackTrace(exception);
        }
    }

    public static synchronized void stop() {
        DPWSFramework.stopInternal(false, 0);
    }

    public static synchronized void kill() {
        DPWSFramework.stopInternal(true, 0);
    }

    private static int getHaltPhase() {
        return haltPhase;
    }

    private static void setHaltPhase(int n) {
        if (killingThread) {
            return;
        }
        haltPhase = n;
    }

    private static void killNow() {
        killingThread = true;
    }

    private static void stopInternal(boolean bl, int n) {
        if (!running) {
            return;
        }
        if (!bl && running) {
            Thread thread = new Thread(){

                public void run() {
                    try {
                        Thread.sleep(2000L);
                        DPWSFramework.killNow();
                        DPWSFramework.stopInternal(true, DPWSFramework.getHaltPhase());
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            };
            thread.start();
        }
        if (bl && running) {
            if (n == 0) {
                Log.info("Killing DPWS Framework...");
            } else {
                Log.info("Killing DPWS Framework because stop does not work...");
            }
        } else {
            Log.info("Stopping DPWS Framework...");
        }
        if (n <= 0 && running) {
            if (Log.isDebug()) {
                Log.debug("Unsubscribing from all event sources.", 4);
            }
            DPWSFramework.unsubscribeAll();
            DPWSFramework.setHaltPhase(1);
        }
        if (n <= 1 && running) {
            if (DPWSFramework.supportsConfiguration(6)) {
                DeviceServiceRegistry.tearDown();
            }
            DPWSFramework.setHaltPhase(2);
        }
        if (n <= 2 && running) {
            if (bl) {
                if (Log.isDebug()) {
                    Log.debug("Killing communication managers.", 4);
                }
                CommunicationManagerRegistry.killAll();
            } else {
                if (Log.isDebug()) {
                    Log.debug("Stopping communication managers.", 4);
                }
                CommunicationManagerRegistry.stopAll();
            }
            DPWSFramework.setHaltPhase(3);
        }
        if (n <= 3 && running) {
            if (Log.isDebug()) {
                Log.debug("Stopping message informer.", 4);
            }
            MessageInformer.getInstance().stop();
            DPWSFramework.setHaltPhase(4);
        }
        if (n <= 4 && running) {
            if (Log.isDebug()) {
                Log.debug("Stopping watch dog.", 4);
            }
            WatchDog.getInstance().stop();
            DPWSFramework.setHaltPhase(5);
        }
        if (n <= 5 && running) {
            if (AttachmentStore.exists()) {
                try {
                    AttachmentStore.getInstance().cleanup();
                }
                catch (AttachmentException attachmentException) {
                    // empty catch block
                }
            }
            DPWSFramework.setHaltPhase(6);
        }
        if (n <= 6 && running) {
            if (Log.isDebug()) {
                Log.debug("Shutting down the threadpool.", 4);
            }
            threadpool.shutdown();
            DPWSFramework.setHaltPhase(7);
        }
        if (running) {
            threadpool = null;
            running = false;
            Log.info("DPWS Framework stopped.");
        }
    }

    public static boolean isRunning() {
        return running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addClientSubscrption(ClientSubscription clientSubscription) {
        HashSet hashSet = subscriptions;
        synchronized (hashSet) {
            subscriptions.add(clientSubscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeClientSubscrption(ClientSubscription clientSubscription) {
        HashSet hashSet = subscriptions;
        synchronized (hashSet) {
            subscriptions.remove(clientSubscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unsubscribeAll() {
        HashSet hashSet = subscriptions;
        synchronized (hashSet) {
            Iterator iterator = subscriptions.iterator();
            while (iterator.hasNext()) {
                ClientSubscription clientSubscription = (ClientSubscription)iterator.next();
                iterator.remove();
                try {
                    clientSubscription.unsubscribe();
                }
                catch (EventingException eventingException) {
                    eventingException.printStackTrace();
                }
                catch (TimeoutException timeoutException) {
                    timeoutException.printStackTrace();
                }
            }
        }
    }

    public static boolean hasModule(int n) {
        switch (n) {
            case 1: {
                return HAVE_CLIENT_MODULE;
            }
            case 2: {
                return HAVE_SERVICE_MODULE;
            }
            case 4: {
                return HAVE_EVENTING_MODULE;
            }
            case 8: {
                return HAVE_PLATFORM_SE_MODULE;
            }
            case 16: {
                return HAVE_PLATFORM_CLDC_MODULE;
            }
            case 32: {
                return HAVE_ATTACHMENT_MODULE;
            }
            case 64: {
                return HAVE_SECURITY_MODULE;
            }
            case 128: {
                return HAVE_PRESENTATION_MODULE;
            }
            case 256: {
                return HAVE_COMMUNICATION_DPWS_MODULE;
            }
        }
        return false;
    }

    public static boolean supportsConfiguration(int n) {
        if ((n & 1) != 0 && !HAVE_CLIENT_MODULE) {
            return false;
        }
        if ((n & 2) != 0 && !HAVE_SERVICE_MODULE) {
            return false;
        }
        if ((n & 4) != 0 && !HAVE_EVENTING_MODULE) {
            return false;
        }
        if ((n & 8) != 0 && !HAVE_PLATFORM_SE_MODULE) {
            return false;
        }
        return (n & 0x10) == 0 || HAVE_PLATFORM_CLDC_MODULE;
    }

    public static ThreadPool getThreadPool() {
        return threadpool;
    }

    public static CommunicationManager getCommunicationManager(String string) {
        if (!running) {
            throw new WS4DIllegalStateException("Framework not started correctly or not running.");
        }
        return CommunicationManagerRegistry.getManager(string);
    }

    public static ResourceLoader getResourceAsStream(URI uRI) throws IOException {
        if (uRI == null) {
            throw new IOException("What?! Cannot find 'null' file. Maybe /dev/null took it.");
        }
        if (uRI.getSchema().startsWith("local")) {
            String string = uRI.toString().substring("local".length() + 1);
            InputStream inputStream = uRI.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                try {
                    FileSystem fileSystem = DPWSFramework.getLocalFileSystem();
                    ResourceLoader resourceLoader = new ResourceLoader(fileSystem.readFile(string), null);
                    return resourceLoader;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            ResourceLoader resourceLoader = new ResourceLoader(inputStream, null);
            return resourceLoader;
        }
        if (uRI.getSchema().startsWith("file")) {
            try {
                FileSystem fileSystem = DPWSFramework.getLocalFileSystem();
                ResourceLoader resourceLoader = new ResourceLoader(fileSystem.readFile(uRI.getPath()), null);
                return resourceLoader;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (running) {
            Iterator iterator = CommunicationManagerRegistry.getLoadedManagers();
            while (iterator.hasNext()) {
                CommunicationManager communicationManager = (CommunicationManager)iterator.next();
                ResourceLoader resourceLoader = communicationManager.getResourceAsStream(uRI);
                if (resourceLoader == null) continue;
                return resourceLoader;
            }
        } else {
            Log.warn("Framework could not load the given location before everything is up and running.");
        }
        return null;
    }

    public static Toolkit getToolkit() {
        return toolkit;
    }

    public static Presentation getPresentation() {
        if (DPWSFramework.hasModule(128)) {
            try {
                Class<?> clazz = Class.forName("org.ws4d.java.presentation.DeviceServicePresentation");
                presentation = (Presentation)clazz.newInstance();
            }
            catch (Exception exception) {
                Log.error(exception.getMessage());
                Log.printStackTrace(exception);
            }
        }
        return presentation;
    }

    public static void setMonitorStreamFactory(MonitorStreamFactory monitorStreamFactory) {
        monitorFactory = monitorStreamFactory;
    }

    public static MonitorStreamFactory getMonitorStreamFactory() {
        return monitorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileSystem getLocalFileSystem() throws IOException {
        Object object = LOCAL_FILE_SYSTEM_LOCK;
        synchronized (object) {
            if (localFileSystem == null) {
                if (DPWSFramework.hasModule(8)) {
                    try {
                        Class<?> clazz = Class.forName("org.ws4d.java.platform.io.fs.SEFileSystem");
                        localFileSystem = (FileSystem)clazz.newInstance();
                    }
                    catch (Exception exception) {
                        throw new IOException(exception.toString());
                    }
                } else if (DPWSFramework.hasModule(16)) {
                    try {
                        Class<?> clazz = Class.forName("org.ws4d.java.platform.io.fs.CLDCFileSystem");
                        localFileSystem = (FileSystem)clazz.newInstance();
                    }
                    catch (Exception exception) {
                        throw new IOException(exception.toString());
                    }
                } else {
                    throw new IOException("The current runtime configuration doesn't contain support for a local file system.");
                }
            }
            return localFileSystem;
        }
    }

    public static SecurityManager getSecurityManager() {
        return securityManager;
    }

    public static void setPropertiesPath(String string) {
        propertiesPath = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AttachmentFactory getAttachmentFactory() throws IOException {
        Object object = ATTACHMENT_FACTORY_LOCK;
        synchronized (object) {
            if (attachmentFactory != null) {
                return attachmentFactory;
            }
            if (DPWSFramework.hasModule(32)) {
                try {
                    Class<?> clazz = Class.forName("org.ws4d.java.attachment.DefaultAttachmentFactory");
                    attachmentFactory = (AttachmentFactory)clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new IOException(exception.toString());
                }
            } else {
                throw new IOException("The current runtime configuration doesn't contain support for a attachments.");
            }
            return attachmentFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventingFactory getEventingFactory() throws IOException {
        Object object = EVENTING_FACTORY_LOCK;
        synchronized (object) {
            if (eventingFactory != null) {
                return eventingFactory;
            }
            if (DPWSFramework.hasModule(4)) {
                try {
                    Class<?> clazz = Class.forName("org.ws4d.java.eventing.DefaultEventingFactory");
                    eventingFactory = (EventingFactory)clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new IOException(exception.toString());
                }
            } else {
                throw new IOException("The current runtime configuration doesn't contain support for events.");
            }
            return eventingFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProxyFactory getProxyFactory() throws IOException {
        Object object = PROXY_FACTORY_LOCK;
        synchronized (object) {
            if (proxyFactory != null) {
                return proxyFactory;
            }
            if (DPWSFramework.hasModule(1)) {
                String string = FrameworkProperties.getInstance().getProxyServiceFactroryClass();
                if (string == null) {
                    string = "org.ws4d.java.service.DefaultProxyFactory";
                }
                boolean bl = true;
                while (bl) {
                    try {
                        Class<?> clazz = Class.forName(string);
                        proxyFactory = (ProxyFactory)clazz.newInstance();
                        bl = false;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Log.error("Configured Proxy Factory [" + string + "] not found, falling back to default implementation");
                    }
                    catch (Exception exception) {
                        Log.error("Unable to create instance of configured Proxy Factory [" + string + "], falling back to default implementation");
                        Log.printStackTrace(exception);
                    }
                    if (proxyFactory != null) continue;
                    string = "org.ws4d.java.service.DefaultProxyFactory";
                    bl = false;
                }
            } else {
                throw new IOException("The current runtime configuration doesn't contain support for a proxy factory.");
            }
            return proxyFactory;
        }
    }

    public static boolean onCldcLibrary() {
        try {
            Class.forName("com.sun.cldc.io.ConnectionBase");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static void createToolkit() {
        if (toolkit != null) {
            return;
        }
        if (DPWSFramework.hasModule(8) && !DPWSFramework.onCldcLibrary()) {
            try {
                Class<?> clazz = Class.forName("org.ws4d.java.platform.util.SEToolkit");
                toolkit = (Toolkit)clazz.newInstance();
            }
            catch (Exception exception) {
                Log.error(exception.getMessage());
                Log.printStackTrace(exception);
            }
        } else if (DPWSFramework.hasModule(16) && DPWSFramework.onCldcLibrary()) {
            try {
                Class<?> clazz = Class.forName("org.ws4d.java.platform.util.CLDCToolkit");
                toolkit = (Toolkit)clazz.newInstance();
            }
            catch (Exception exception) {
                Log.error(exception.getMessage());
                Log.printStackTrace(exception);
            }
        } else {
            Log.info("The current runtime configuration doesn't contain support for a platform toolkit.");
        }
    }

    private DPWSFramework() {
    }

    static {
        Class<?> clazz;
        boolean bl = false;
        try {
            Class.forName("org.ws4d.java.client.DefaultClient");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        HAVE_CLIENT_MODULE = bl;
        bl = false;
        try {
            Class.forName("org.ws4d.java.service.DefaultService");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        HAVE_SERVICE_MODULE = bl;
        bl = false;
        try {
            Class.forName("org.ws4d.java.eventing.DefaultEventingFactory");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        HAVE_EVENTING_MODULE = bl;
        bl = false;
        try {
            Class.forName("org.ws4d.java.communication.connection.tcp.SESocket");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        HAVE_PLATFORM_SE_MODULE = bl;
        bl = false;
        try {
            Class.forName("org.ws4d.java.communication.connection.tcp.CLDCSocket");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        HAVE_PLATFORM_CLDC_MODULE = bl;
        bl = false;
        try {
            Class.forName("org.ws4d.java.attachment.AbstractAttachment");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        HAVE_ATTACHMENT_MODULE = bl;
        bl = false;
        try {
            Class.forName("org.ws4d.java.presentation.DeviceServicePresentation");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        HAVE_PRESENTATION_MODULE = bl;
        bl = false;
        try {
            Class.forName("org.ws4d.java.security.DPWSSecurityManagerSE");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!bl) {
            try {
                Class.forName("org.ws4d.java.security.DPWSSecurityManagerCLDC");
                bl = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        HAVE_SECURITY_MODULE = bl;
        bl = false;
        try {
            Class.forName("org.ws4d.java.communication.DPWSCommunicationManager");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        HAVE_COMMUNICATION_DPWS_MODULE = bl;
        LOCAL_FILE_SYSTEM_LOCK = new Object();
        ATTACHMENT_FACTORY_LOCK = new Object();
        EVENTING_FACTORY_LOCK = new Object();
        PROXY_FACTORY_LOCK = new Object();
        running = false;
        threadpool = null;
        properties = Properties.getInstance();
        monitorFactory = null;
        toolkit = null;
        localFileSystem = null;
        attachmentFactory = null;
        eventingFactory = null;
        proxyFactory = null;
        securityManager = null;
        presentation = null;
        propertiesPath = null;
        subscriptions = new HashSet();
        haltPhase = 0;
        killingThread = false;
        bl = false;
        try {
            clazz = Class.forName("org.ws4d.java.security.DPWSSecurityManagerSE");
            securityManager = (SecurityManager)clazz.newInstance();
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        if (!bl) {
            try {
                clazz = Class.forName("org.ws4d.java.security.cldc.DPWSSecurityManagerCLDC");
                securityManager = (SecurityManager)clazz.newInstance();
                bl = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

