/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.attachment;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ws4d.java.attachment.AbstractAttachment;
import org.ws4d.java.attachment.AttachmentException;
import org.ws4d.java.attachment.IncomingAttachment;
import org.ws4d.java.attachment.OutgoingAttachment;
import org.ws4d.java.types.InternetMediaType;
import org.ws4d.java.util.IDGenerator;

class MemoryAttachment
extends AbstractAttachment
implements IncomingAttachment,
OutgoingAttachment {
    private byte[] bytes;

    MemoryAttachment(byte[] byArray) {
        this(byArray, (InternetMediaType)null);
    }

    MemoryAttachment(byte[] byArray, InternetMediaType internetMediaType) {
        this(byArray, IDGenerator.getUUID(), internetMediaType);
    }

    MemoryAttachment(byte[] byArray, String string) {
        this(byArray, IDGenerator.getUUID(), string);
    }

    MemoryAttachment(byte[] byArray, String string, InternetMediaType internetMediaType) {
        super(string, internetMediaType);
        this.bytes = byArray;
    }

    MemoryAttachment(byte[] byArray, String string, String string2) {
        this(byArray, string, MemoryAttachment.maskContentType(string2));
    }

    MemoryAttachment(AttachmentException attachmentException) {
        this(EMPTY_BYTE_ARRAY);
        this.setReadInException(attachmentException);
    }

    public final int getType() throws AttachmentException {
        return 2;
    }

    public void dispose() {
        this.bytes = null;
    }

    public byte[] getBytes() throws AttachmentException {
        if (this.readInException != null) {
            throw this.readInException;
        }
        return this.bytes == null ? EMPTY_BYTE_ARRAY : this.bytes;
    }

    public long size() throws AttachmentException {
        if (this.readInException != null) {
            throw this.readInException;
        }
        if (this.bytes == null) {
            return 0L;
        }
        return this.bytes.length;
    }

    public InputStream getInputStream() throws AttachmentException, IOException {
        if (this.readInException != null) {
            throw this.readInException;
        }
        if (this.bytes == null) {
            return EMPTY_STREAM;
        }
        return new ByteArrayInputStream(this.bytes);
    }

    public void serialize(OutputStream outputStream) throws IOException {
        if (this.bytes != null) {
            outputStream.write(this.bytes);
            this.dispose();
        }
    }

    public boolean isLocal() {
        return true;
    }

    public String getFilePath() throws AttachmentException {
        throw new AttachmentException("file system operations not supported for memory attachments");
    }

    public void save(String string) throws AttachmentException, IOException {
        throw new AttachmentException("file system operations not supported for memory attachments");
    }

    public boolean move(String string) throws AttachmentException {
        throw new AttachmentException("file system operations not supported for memory attachments");
    }
}

