/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.client;

import java.io.IOException;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.client.HelloListener;
import org.ws4d.java.client.SearchCallback;
import org.ws4d.java.client.SearchManager;
import org.ws4d.java.client.SearchParameter;
import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.CommunicationManagerRegistry;
import org.ws4d.java.communication.DefaultIncomingMessageListener;
import org.ws4d.java.communication.DiscoveryBinding;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.monitor.MonitorStreamFactory;
import org.ws4d.java.communication.monitor.MonitoringContext;
import org.ws4d.java.dispatch.DeviceServiceRegistry;
import org.ws4d.java.dispatch.HelloData;
import org.ws4d.java.dispatch.ServiceReferenceEventRegistry;
import org.ws4d.java.eventing.ClientSubscription;
import org.ws4d.java.eventing.EventListener;
import org.ws4d.java.eventing.EventSink;
import org.ws4d.java.eventing.EventingFactory;
import org.ws4d.java.message.discovery.HelloMessage;
import org.ws4d.java.service.Device;
import org.ws4d.java.service.Service;
import org.ws4d.java.service.parameter.ParameterValue;
import org.ws4d.java.service.reference.DeviceListener;
import org.ws4d.java.service.reference.DeviceReference;
import org.ws4d.java.service.reference.ServiceListener;
import org.ws4d.java.service.reference.ServiceReference;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.MessageIdBuffer;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.ProbeScopeSet;
import org.ws4d.java.types.QNameSet;
import org.ws4d.java.types.ScopeSet;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.WS4DIllegalStateException;

public class DefaultClient
implements DeviceListener,
ServiceListener,
SearchCallback,
EventListener,
HelloListener {
    private static final int[] INCOMING_MESSAGE_TYPES = new int[]{1, 2};
    HashMap helloReceivers = null;

    public DefaultClient() {
        if (!DPWSFramework.isRunning()) {
            throw new RuntimeException("Client Constructor: DPWSFramework isn't running!");
        }
    }

    public DataStructure getAllDiscoveryBindings() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = CommunicationManagerRegistry.getLoadedManagers();
        while (iterator.hasNext()) {
            CommunicationManager communicationManager = (CommunicationManager)iterator.next();
            try {
                ((DataStructure)arrayList).addAll(communicationManager.getDiscoveryBindings());
            }
            catch (IOException iOException) {
                Log.printStackTrace(iOException);
            }
        }
        return arrayList;
    }

    public EventSink getEventSink(DataStructure dataStructure) {
        EventingFactory eventingFactory = null;
        try {
            eventingFactory = DPWSFramework.getEventingFactory();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot return event sink. Eventing support not found.");
        }
        return eventingFactory.createEventSink((EventListener)this, dataStructure);
    }

    public EventSink generateEventSink(int n) {
        EventingFactory eventingFactory = null;
        try {
            eventingFactory = DPWSFramework.getEventingFactory();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot return event sink. Eventing support not found.");
        }
        return eventingFactory.createEventSink((EventListener)this, n);
    }

    public void deviceBye(DeviceReference deviceReference) {
        Log.info("Client: Overwrite deviceBye() to receive device status changes");
    }

    public void deviceCompletelyDiscovered(DeviceReference deviceReference) {
        Log.info("Client: Overwrite deviceCompletelyDiscovered() to receive device status changes");
    }

    public void deviceChanged(DeviceReference deviceReference) {
        Log.info("Client: Overwrite deviceChanged() to receive device status changes");
    }

    public void deviceRunning(DeviceReference deviceReference) {
        Log.info("Client: Overwrite deviceRunning() to receive device status changes");
    }

    public void deviceBuiltUp(DeviceReference deviceReference, Device device) {
        Log.info("Client: Overwrite deviceBuiltUp() to receive device status changes");
    }

    public void deviceCommunicationErrorOrReset(DeviceReference deviceReference) {
        Log.info("Client: Overwrite deviceCommunicationErrorOrReset() to receive device status changes");
    }

    public void serviceChanged(ServiceReference serviceReference, Service service) {
        Log.info("Client: Overwrite serviceChanged() to receive service status changes");
    }

    public void serviceCreated(ServiceReference serviceReference, Service service) {
        Log.info("Client: Overwrite serviceCreated() to receive service status changes");
    }

    public void serviceDisposed(ServiceReference serviceReference) {
        Log.info("Client: Overwrite serviceDisposed() to receive service status changes");
    }

    public void registerServiceListening() {
        ServiceReferenceEventRegistry.getInstance().registerServiceListening(this);
    }

    public void unregisterServiceListening() {
        ServiceReferenceEventRegistry.getInstance().unregisterServiceListening(this);
    }

    public DeviceReference getDeviceReference(EndpointReference endpointReference, DiscoveryBinding discoveryBinding) {
        return SearchManager.getDeviceReference(endpointReference, this, discoveryBinding);
    }

    public DeviceReference getDeviceReference(EndpointReference endpointReference) {
        return SearchManager.getDeviceReference(endpointReference, this, null);
    }

    public DeviceReference getDeviceReference(HelloData helloData) {
        return SearchManager.getDeviceReference(helloData, this);
    }

    public ServiceReference getServiceReference(EndpointReference endpointReference, String string) {
        return SearchManager.getServiceReference(endpointReference, string);
    }

    public void searchDevice(SearchParameter searchParameter) {
        SearchManager.searchDevice(searchParameter, this, this);
    }

    public void searchService(SearchParameter searchParameter) {
        SearchManager.searchDevice(searchParameter, this, this);
    }

    public synchronized void registerHelloListening() {
        try {
            Iterator iterator = CommunicationManagerRegistry.getLoadedManagers();
            while (iterator.hasNext()) {
                CommunicationManager communicationManager = (CommunicationManager)iterator.next();
                DataStructure dataStructure = communicationManager.getDiscoveryBindings();
                if (dataStructure == null) continue;
                Iterator iterator2 = dataStructure.iterator();
                while (iterator2.hasNext()) {
                    DiscoveryBinding discoveryBinding = (DiscoveryBinding)iterator2.next();
                    this.registerHelloListening(discoveryBinding);
                }
            }
        }
        catch (IOException iOException) {
            Log.error("Cannot register for incoming wsd:Hello messages. " + iOException.getMessage());
        }
    }

    public synchronized void registerHelloListening(SearchParameter searchParameter) {
        try {
            Iterator iterator = CommunicationManagerRegistry.getLoadedManagers();
            while (iterator.hasNext()) {
                CommunicationManager communicationManager = (CommunicationManager)iterator.next();
                DataStructure dataStructure = communicationManager.getDiscoveryBindings();
                if (dataStructure == null) continue;
                Iterator iterator2 = dataStructure.iterator();
                while (iterator2.hasNext()) {
                    DiscoveryBinding discoveryBinding = (DiscoveryBinding)iterator2.next();
                    this.registerHelloListening(searchParameter, discoveryBinding);
                }
            }
        }
        catch (IOException iOException) {
            Log.error("Cannot register for incoming wsd:Hello messages. " + iOException.getMessage());
        }
    }

    public synchronized void registerHelloListening(DiscoveryBinding discoveryBinding) {
        SearchParameter searchParameter = new SearchParameter();
        this.registerHelloListening(searchParameter, discoveryBinding);
    }

    public void registerHelloListening(SearchParameter searchParameter, DiscoveryBinding discoveryBinding) {
        this.registerHelloListening(searchParameter, discoveryBinding, this);
    }

    public synchronized void registerHelloListening(SearchParameter searchParameter, DiscoveryBinding discoveryBinding, HelloListener helloListener) {
        if (this.helloReceivers == null) {
            this.helloReceivers = new HashMap(3);
        }
        HelloRegisterKey helloRegisterKey = new HelloRegisterKey(searchParameter, discoveryBinding);
        HelloReceiver helloReceiver = new HelloReceiver(helloListener == null ? this : helloListener, searchParameter);
        if (this.helloReceivers.containsKey(helloRegisterKey)) {
            return;
        }
        this.helloReceivers.put(helloRegisterKey, helloReceiver);
        try {
            CommunicationManager communicationManager = CommunicationManagerRegistry.getManager(discoveryBinding.getCommunicationManagerId());
            communicationManager.registerDiscovery(INCOMING_MESSAGE_TYPES, discoveryBinding, helloReceiver);
        }
        catch (WS4DIllegalStateException wS4DIllegalStateException) {
            throw new RuntimeException(wS4DIllegalStateException.getMessage());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
        DeviceServiceRegistry.incAppSequenceUser();
    }

    public synchronized void unregisterHelloListening(DiscoveryBinding discoveryBinding) {
        SearchParameter searchParameter = new SearchParameter();
        this.unregisterHelloListening(searchParameter, discoveryBinding);
    }

    public synchronized void unregisterHelloListening(SearchParameter searchParameter) {
        try {
            Iterator iterator = CommunicationManagerRegistry.getLoadedManagers();
            while (iterator.hasNext()) {
                CommunicationManager communicationManager = (CommunicationManager)iterator.next();
                DataStructure dataStructure = communicationManager.getDiscoveryBindings();
                if (dataStructure == null) continue;
                Iterator iterator2 = dataStructure.iterator();
                while (iterator2.hasNext()) {
                    DiscoveryBinding discoveryBinding = (DiscoveryBinding)iterator2.next();
                    this.unregisterHelloListening(searchParameter, discoveryBinding);
                }
            }
        }
        catch (IOException iOException) {
            Log.error("Cannot unregister for incoming wsd:Hello messages. " + iOException.getMessage());
        }
    }

    public synchronized void unregisterHelloListening(SearchParameter searchParameter, DiscoveryBinding discoveryBinding) {
        if (this.helloReceivers != null && this.helloReceivers.size() > 0) {
            HelloRegisterKey helloRegisterKey = new HelloRegisterKey(searchParameter, discoveryBinding);
            HelloReceiver helloReceiver = (HelloReceiver)this.helloReceivers.remove(helloRegisterKey);
            if (helloReceiver == null) {
                return;
            }
            try {
                CommunicationManager communicationManager = CommunicationManagerRegistry.getManager(discoveryBinding.getCommunicationManagerId());
                communicationManager.unregisterDiscovery(INCOMING_MESSAGE_TYPES, discoveryBinding, helloReceiver);
            }
            catch (WS4DIllegalStateException wS4DIllegalStateException) {
                throw new RuntimeException(wS4DIllegalStateException.getMessage());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage());
            }
            DeviceServiceRegistry.decAppSequenceUser();
        }
    }

    public void helloReceived(HelloData helloData) {
        Log.info("Client: Overwrite helloReceived() to receive and handle the UUIDs of new HelloMessages");
    }

    public void deviceFound(DeviceReference deviceReference, SearchParameter searchParameter) {
        Log.info("Client: Overwrite deviceFound() to receive device discovery responses");
    }

    public void serviceFound(ServiceReference serviceReference, SearchParameter searchParameter) {
        Log.info("Client: Overwrite serviceFound() to receive service discovery responses");
    }

    public ParameterValue eventReceived(ClientSubscription clientSubscription, URI uRI, ParameterValue parameterValue) {
        Log.info("Client: Overwrite eventReceived() to receive and handle events");
        return null;
    }

    public void subscriptionEndReceived(ClientSubscription clientSubscription, URI uRI) {
        Log.info("Client: Overwrite subscriptionEndReceived() to receive and handle end of subscriptions");
    }

    public void subscriptionTimeoutReceived(ClientSubscription clientSubscription) {
        Log.info("Client: Overwrite subscriptionTimeoutReceived() to receive and handle subscription timeouts");
    }

    private final class HelloReceiver
    extends DefaultIncomingMessageListener {
        private final MessageIdBuffer messageIdBuffer = new MessageIdBuffer();
        private final SearchParameter search;
        private final HelloListener helloListener;

        public HelloReceiver(HelloListener helloListener, SearchParameter searchParameter) {
            this.helloListener = helloListener;
            this.search = searchParameter;
        }

        public void handle(HelloMessage helloMessage, ProtocolData protocolData) {
            QNameSet qNameSet = helloMessage.getDiscoveryData().getTypes();
            QNameSet qNameSet2 = this.search.getDeviceTypes();
            ScopeSet scopeSet = helloMessage.getScopes();
            ProbeScopeSet probeScopeSet = this.search.getScopes();
            boolean bl = false;
            boolean bl2 = false;
            if (qNameSet2 != null && qNameSet != null && qNameSet.containsAll(qNameSet2) || qNameSet2 == null) {
                bl = true;
            }
            int n = 0;
            if (probeScopeSet != null && scopeSet != null && scopeSet.containsAll(probeScopeSet) || probeScopeSet == null) {
                bl2 = true;
            }
            if (!bl && !bl2) {
                if (Log.isDebug()) {
                    Log.debug("Discarding Hello message! Message does not match the search criteria!", 2);
                }
                n = 3;
            }
            if (this.messageIdBuffer.containsOrEnqueue(helloMessage.getMessageId())) {
                if (Log.isDebug()) {
                    Log.debug("Discarding Hello message! Already saw this message ID!", 2);
                }
                n = 2;
            }
            if (n > 0) {
                MonitorStreamFactory monitorStreamFactory = DPWSFramework.getMonitorStreamFactory();
                if (monitorStreamFactory != null) {
                    MonitoringContext monitoringContext = monitorStreamFactory.getMonitoringContextIn(protocolData);
                    if (monitoringContext != null) {
                        monitorStreamFactory.discard(protocolData, monitoringContext, n);
                    } else {
                        Log.warn("Cannot get correct monitoring context for message generation.");
                    }
                }
                return;
            }
            this.helloListener.helloReceived(new HelloData(helloMessage, protocolData));
        }
    }

    private final class HelloRegisterKey {
        private final SearchParameter search;
        private final DiscoveryBinding binding;

        public HelloRegisterKey(SearchParameter searchParameter, DiscoveryBinding discoveryBinding) {
            this.search = searchParameter;
            this.binding = discoveryBinding;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + (this.binding == null ? 0 : this.binding.hashCode());
            n = 31 * n + (this.search == null ? 0 : this.search.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            HelloRegisterKey helloRegisterKey = (HelloRegisterKey)object;
            if (!this.getOuterType().equals(helloRegisterKey.getOuterType())) {
                return false;
            }
            if (this.binding == null ? helloRegisterKey.binding != null : !this.binding.equals(helloRegisterKey.binding)) {
                return false;
            }
            return !(this.search == null ? helloRegisterKey.search != null : !this.search.equals(helloRegisterKey.search));
        }

        private DefaultClient getOuterType() {
            return DefaultClient.this;
        }
    }
}

