/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.client;

import org.ws4d.java.DPWSFramework;
import org.ws4d.java.client.SearchCallback;
import org.ws4d.java.client.SearchMap;
import org.ws4d.java.client.SearchParameter;
import org.ws4d.java.client.SearchPath;
import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.CommunicationManagerRegistry;
import org.ws4d.java.communication.DefaultResponseCallback;
import org.ws4d.java.communication.Discovery;
import org.ws4d.java.communication.DiscoveryBinding;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.ProtocolDomain;
import org.ws4d.java.communication.ResponseCallback;
import org.ws4d.java.communication.TimeoutException;
import org.ws4d.java.dispatch.DeviceServiceRegistry;
import org.ws4d.java.dispatch.DuplicateServiceReferenceException;
import org.ws4d.java.dispatch.HelloData;
import org.ws4d.java.dispatch.OutDispatcher;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.discovery.ProbeMatch;
import org.ws4d.java.message.discovery.ProbeMatchesMessage;
import org.ws4d.java.message.discovery.ProbeMessage;
import org.ws4d.java.service.Device;
import org.ws4d.java.service.reference.DeviceListener;
import org.ws4d.java.service.reference.DeviceReference;
import org.ws4d.java.service.reference.ServiceReference;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.ProbeScopeSet;
import org.ws4d.java.types.QNameSet;
import org.ws4d.java.types.URI;
import org.ws4d.java.types.XAddressInfo;
import org.ws4d.java.types.XAddressInfoSet;
import org.ws4d.java.util.Log;

public final class SearchManager {
    public static DeviceReference getDeviceReference(EndpointReference endpointReference, URI uRI, DeviceListener deviceListener, String string) {
        XAddressInfo xAddressInfo = new XAddressInfo(uRI, string);
        DeviceReference deviceReference = DeviceServiceRegistry.getDeviceReference(endpointReference, new XAddressInfoSet(xAddressInfo), true);
        if (deviceListener != null) {
            deviceReference.addListener(deviceListener);
        }
        if (Log.isDebug()) {
            Log.debug("Device reference created from " + uRI + " over " + string);
        }
        return deviceReference;
    }

    public static DeviceReference getDeviceReference(EndpointReference endpointReference, URI uRI, DeviceListener deviceListener, DiscoveryBinding discoveryBinding) {
        String string = discoveryBinding.getCommunicationManagerId();
        XAddressInfo xAddressInfo = new XAddressInfo(uRI, string);
        DeviceReference deviceReference = DeviceServiceRegistry.getDeviceReference(endpointReference, new XAddressInfoSet(xAddressInfo), true);
        if (deviceListener != null) {
            deviceReference.addListener(deviceListener);
        }
        DeviceServiceRegistry.register(discoveryBinding);
        if (Log.isDebug()) {
            Log.debug("Device reference created from " + uRI + " over " + string);
        }
        return deviceReference;
    }

    public static DeviceReference getDeviceReference(EndpointReference endpointReference, DeviceListener deviceListener, DiscoveryBinding discoveryBinding) {
        DeviceReference deviceReference = DeviceServiceRegistry.getDeviceReference(endpointReference);
        if (deviceListener != null) {
            deviceReference.addListener(deviceListener);
        }
        DeviceServiceRegistry.register(discoveryBinding);
        return deviceReference;
    }

    public static DeviceReference getDeviceReference(HelloData helloData, DeviceListener deviceListener) {
        DeviceReference deviceReference = DeviceServiceRegistry.getDeviceReference(helloData);
        if (deviceListener != null) {
            deviceReference.addListener(deviceListener);
        }
        Iterator iterator = CommunicationManagerRegistry.getLoadedManagers();
        while (iterator.hasNext()) {
            CommunicationManager communicationManager = (CommunicationManager)iterator.next();
            DeviceServiceRegistry.register(communicationManager.getDiscoveryBindingForProtocolData(helloData.getProtocolData()));
        }
        return deviceReference;
    }

    public static ServiceReference getServiceReference(EndpointReference endpointReference, String string) {
        return DeviceServiceRegistry.getServiceReference(endpointReference, string, true);
    }

    public static ServiceReference createServiceReference(EndpointReference endpointReference, QNameSet qNameSet, String string) throws DuplicateServiceReferenceException {
        return DeviceServiceRegistry.createServiceReference(endpointReference, qNameSet, string, null);
    }

    public static void searchService(SearchParameter searchParameter, SearchCallback searchCallback) {
        SearchManager.searchDevice(searchParameter, searchCallback, null);
    }

    public static void searchDevice(SearchParameter searchParameter, SearchCallback searchCallback, DeviceListener deviceListener) {
        if (searchCallback == null) {
            throw new NullPointerException("callback is null");
        }
        if (searchParameter == null) {
            searchParameter = new SearchParameter();
        }
        if ((searchParameter.getSearchMode() & 1) != 0) {
            SearchManager.searchLocalReferences(searchParameter, searchCallback, deviceListener);
        }
        if ((searchParameter.getSearchMode() & 2) != 0) {
            DataStructure dataStructure;
            SearchMap searchMap;
            ProbeScopeSet probeScopeSet;
            ProbeMessage probeMessage = new ProbeMessage(CommunicationManager.ID_NULL);
            QNameSet qNameSet = searchParameter.getDeviceTypes();
            if (qNameSet != null) {
                probeMessage.setTypes(qNameSet);
            }
            if ((probeScopeSet = searchParameter.getScopes()) != null) {
                probeMessage.setScopes(probeScopeSet);
            }
            if ((searchMap = searchParameter.getSearchMap()) != null) {
                dataStructure = new HashSet();
                Iterator iterator = searchMap.getPaths().iterator();
                while (iterator.hasNext()) {
                    SearchPath searchPath = (SearchPath)iterator.next();
                    ProtocolDomain protocolDomain = Discovery.getDomain(searchPath.getTechnologyIdentifier(), searchPath.getDomainIdentifier());
                    if (protocolDomain != null) {
                        dataStructure.add(protocolDomain);
                        continue;
                    }
                    Log.warn("No protocol domain found for search path " + searchPath);
                }
            } else {
                dataStructure = Discovery.getDefaultOutputDomains();
            }
            OutDispatcher.getInstance().send(probeMessage, null, dataStructure, (ResponseCallback)new SearchManagerCallback(null, searchParameter, searchCallback, deviceListener));
        }
    }

    public static DataStructure getLocalDevices() {
        return DeviceServiceRegistry.getLocalDeviceReferences(null, null);
    }

    private static void searchLocalReferences(final SearchParameter searchParameter, final SearchCallback searchCallback, final DeviceListener deviceListener) {
        QNameSet qNameSet = searchParameter.getServiceTypes();
        if (qNameSet != null && qNameSet.size() > 0) {
            DataStructure dataStructure = DeviceServiceRegistry.getLocalServiceReferences(searchParameter.getServiceTypes(), searchParameter.getDeviceTypes(), searchParameter.getScopes());
            Iterator iterator = dataStructure.iterator();
            while (iterator.hasNext()) {
                final ServiceReference serviceReference = (ServiceReference)iterator.next();
                try {
                    final DeviceReference deviceReference = serviceReference.getService().getParentDeviceReference();
                    DPWSFramework.getThreadPool().execute(new Runnable(){

                        public void run() {
                            if (deviceReference != null) {
                                deviceReference.addListener(deviceListener);
                            }
                            searchCallback.serviceFound(serviceReference, searchParameter);
                        }
                    });
                }
                catch (TimeoutException timeoutException) {
                    Log.printStackTrace(timeoutException);
                }
            }
        } else {
            DataStructure dataStructure = DeviceServiceRegistry.getLocalDeviceReferences(searchParameter.getDeviceTypes(), searchParameter.getScopes());
            Iterator iterator = dataStructure.iterator();
            while (iterator.hasNext()) {
                final DeviceReference deviceReference = (DeviceReference)iterator.next();
                deviceReference.addListener(deviceListener);
                DPWSFramework.getThreadPool().execute(new Runnable(){

                    public void run() {
                        searchCallback.deviceFound(deviceReference, searchParameter);
                    }
                });
            }
        }
    }

    private SearchManager() {
    }

    private static class SearchManagerCallback
    extends DefaultResponseCallback {
        private final SearchParameter search;
        private final SearchCallback callback;
        private final DeviceListener listener;
        private volatile boolean noneFound = true;

        SearchManagerCallback(XAddressInfo xAddressInfo, SearchParameter searchParameter, SearchCallback searchCallback, DeviceListener deviceListener) {
            super(xAddressInfo);
            this.search = searchParameter;
            this.callback = searchCallback;
            this.listener = deviceListener;
        }

        public void handle(Message message, ProbeMatchesMessage probeMatchesMessage, ProtocolData protocolData) {
            block5: {
                Object object;
                block4: {
                    this.noneFound = false;
                    Object object2 = CommunicationManagerRegistry.getLoadedManagers();
                    while (object2.hasNext()) {
                        object = (CommunicationManager)object2.next();
                        DeviceServiceRegistry.register(object.getDiscoveryBindingForProtocolData(protocolData));
                    }
                    object2 = this.search.getServiceTypes();
                    if (object2 == null || ((QNameSet)object2).size() <= 0) break block4;
                    object = probeMatchesMessage.getProbeMatches().iterator();
                    while (object.hasNext()) {
                        ProbeMatch probeMatch = (ProbeMatch)object.next();
                        final DeviceReference deviceReference = DeviceServiceRegistry.getUpdatedDeviceReference(probeMatch, probeMatchesMessage, protocolData);
                        DPWSFramework.getThreadPool().execute(new Runnable(){

                            public void run() {
                                SearchManagerCallback.this.informOnServiceFound(deviceReference);
                            }
                        });
                    }
                    break block5;
                }
                object = probeMatchesMessage.getProbeMatches();
                if (object == null) break block5;
                Iterator iterator = ((DataStructure)object).iterator();
                while (iterator.hasNext()) {
                    ProbeMatch probeMatch = (ProbeMatch)iterator.next();
                    final DeviceReference deviceReference = DeviceServiceRegistry.getUpdatedDeviceReference(probeMatch, probeMatchesMessage, protocolData);
                    if (this.listener != null) {
                        deviceReference.addListener(this.listener);
                    }
                    DPWSFramework.getThreadPool().execute(new Runnable(){

                        public void run() {
                            SearchManagerCallback.this.callback.deviceFound(deviceReference, SearchManagerCallback.this.search);
                        }
                    });
                }
            }
        }

        public void handleTimeout(Message message) {
            if (this.noneFound) {
                if (Log.isDebug()) {
                    Log.debug("Search timeout for query: " + this.search, 4);
                } else {
                    Log.info("Search timeout.");
                }
            }
        }

        private void informOnServiceFound(DeviceReference deviceReference) {
            try {
                Device device = deviceReference.getDevice();
                Iterator iterator = device.getServiceReferences();
                while (iterator.hasNext()) {
                    ServiceReference serviceReference = (ServiceReference)iterator.next();
                    if (!this.search.getServiceTypes().isContainedBy(serviceReference.getPortTypes())) continue;
                    if (this.listener != null) {
                        deviceReference.addListener(this.listener);
                    }
                    this.callback.serviceFound(serviceReference, this.search);
                }
            }
            catch (TimeoutException timeoutException) {
                Log.printStackTrace(timeoutException);
            }
        }
    }
}

