/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.client;

import org.ws4d.java.client.SearchMap;
import org.ws4d.java.message.discovery.DiscoveryMessage;
import org.ws4d.java.types.ProbeScopeSet;
import org.ws4d.java.types.QNameSet;
import org.ws4d.java.types.ScopeSet;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.StringUtil;

public class SearchParameter {
    public static final byte MODE_LOCAL = 1;
    public static final byte MODE_REMOTE = 2;
    public static final byte MODE_LOCAL_AND_REMOTE = 3;
    private byte searchMode = (byte)3;
    private SearchMap searchMap;
    private QNameSet deviceTypes = null;
    private ProbeScopeSet scopes = null;
    private QNameSet serviceTypes = null;
    private Object referenceObject = null;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(StringUtil.formatClassName(this.getClass()));
        stringBuffer.append(" [ deviceTypes=").append(this.deviceTypes);
        stringBuffer.append(", scopes=").append(this.scopes);
        stringBuffer.append(", serviceTypes=").append(this.serviceTypes);
        stringBuffer.append(", searchMap=").append(this.searchMap);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public byte getSearchMode() {
        return this.searchMode;
    }

    public void setSearchMode(byte by) {
        if ((by & 3) == 0) {
            Log.warn("invalid search mode: " + by + ", setting to default");
            by = (byte)3;
        }
        this.searchMode = by;
    }

    public SearchMap getSearchMap() {
        return this.searchMap;
    }

    public void setSearchMap(SearchMap searchMap) {
        this.searchMap = searchMap;
    }

    public QNameSet getDeviceTypes() {
        return this.deviceTypes;
    }

    public void setDeviceTypes(QNameSet qNameSet) {
        this.deviceTypes = qNameSet;
    }

    public ProbeScopeSet getScopes() {
        return this.scopes;
    }

    public void setScopes(ProbeScopeSet probeScopeSet) {
        this.scopes = probeScopeSet;
    }

    public QNameSet getServiceTypes() {
        return this.serviceTypes;
    }

    public void setServiceTypes(QNameSet qNameSet) {
        this.serviceTypes = qNameSet;
    }

    public Object getReferenceObject() {
        return this.referenceObject;
    }

    public void setReferenceObject(Object object) {
        this.referenceObject = object;
    }

    protected boolean matchesSearch(DiscoveryMessage discoveryMessage) {
        QNameSet qNameSet = discoveryMessage.getTypes();
        if (this.deviceTypes == null || this.deviceTypes.isEmpty() || qNameSet != null && qNameSet.containsAll(this.deviceTypes)) {
            ScopeSet scopeSet;
            return this.scopes == null || this.scopes.isEmpty() || (scopeSet = discoveryMessage.getScopes()) != null && !scopeSet.isEmpty() && scopeSet.containsAll(this.scopes);
        }
        return false;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.deviceTypes == null ? 0 : this.deviceTypes.hashCode());
        n = 31 * n + (this.referenceObject == null ? 0 : this.referenceObject.hashCode());
        n = 31 * n + (this.scopes == null ? 0 : this.scopes.hashCode());
        n = 31 * n + (this.searchMap == null ? 0 : this.searchMap.hashCode());
        n = 31 * n + this.searchMode;
        n = 31 * n + (this.serviceTypes == null ? 0 : this.serviceTypes.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SearchParameter searchParameter = (SearchParameter)object;
        if (this.deviceTypes == null ? searchParameter.deviceTypes != null : !this.deviceTypes.equals(searchParameter.deviceTypes)) {
            return false;
        }
        if (this.referenceObject == null ? searchParameter.referenceObject != null : !this.referenceObject.equals(searchParameter.referenceObject)) {
            return false;
        }
        if (this.scopes == null ? searchParameter.scopes != null : !this.scopes.equals(searchParameter.scopes)) {
            return false;
        }
        if (this.searchMap == null ? searchParameter.searchMap != null : !this.searchMap.equals(searchParameter.searchMap)) {
            return false;
        }
        if (this.searchMode != searchParameter.searchMode) {
            return false;
        }
        return !(this.serviceTypes == null ? searchParameter.serviceTypes != null : !this.serviceTypes.equals(searchParameter.serviceTypes));
    }
}

