/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication;

import java.io.IOException;
import org.ws4d.java.attachment.AttachmentException;
import org.ws4d.java.attachment.AttachmentStore;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.monitor.MonitoringContext;
import org.ws4d.java.communication.protocol.mime.MIMEBodyHeader;
import org.ws4d.java.communication.protocol.mime.MIMEEntityInput;
import org.ws4d.java.communication.protocol.mime.MIMEHandler;
import org.ws4d.java.structures.Queue;
import org.ws4d.java.util.Log;

public final class AttachmentStoreHandler
implements MIMEHandler {
    private static AttachmentStore attachmentStore;
    private static AttachmentException instantiationException;
    private static MIMEHandler instance;

    public static synchronized MIMEHandler getInstance() {
        if (instance == null) {
            try {
                attachmentStore = AttachmentStore.getInstance();
            }
            catch (AttachmentException attachmentException) {
                instantiationException = attachmentException;
                Log.printStackTrace(attachmentException);
            }
            instance = new AttachmentStoreHandler();
        }
        return instance;
    }

    private AttachmentStoreHandler() {
    }

    public void handleRequest(MIMEEntityInput mIMEEntityInput, Queue queue, ProtocolData protocolData, MonitoringContext monitoringContext) throws IOException {
        this.handleMIME(mIMEEntityInput, protocolData);
    }

    public void handleResponse(MIMEEntityInput mIMEEntityInput, ProtocolData protocolData, MonitoringContext monitoringContext) throws IOException {
        this.handleMIME(mIMEEntityInput, protocolData);
    }

    private void handleMIME(MIMEEntityInput mIMEEntityInput, ProtocolData protocolData) throws IOException {
        if (attachmentStore == null) {
            throw new IOException(instantiationException.getMessage());
        }
        MIMEBodyHeader mIMEBodyHeader = mIMEEntityInput.getEntityHeader();
        String string = mIMEBodyHeader.getHeaderFieldValue("Content-ID");
        if (string == null) {
            throw new IOException("MIME Entity header mises a Content-ID.");
        }
        String string2 = mIMEBodyHeader.getHeaderFieldValue("Content-Transfer-Encoding");
        if (string2 == null || !"binary".equals(string2)) {
            throw new IOException("Content-Transfer-Encoding of MIME Entity not set to \"binary\".");
        }
        String string3 = mIMEBodyHeader.getHeaderFieldValue("Content-Type");
        attachmentStore.store(protocolData.getCurrentMIMEContext(), string, string3, string2, mIMEEntityInput.getBodyInputStream());
    }
}

