/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication;

import org.ws4d.java.communication.DiscoveryBinding;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.types.URI;

public class DPWSDiscoveryBinding
implements DiscoveryBinding {
    public static final IPAddress DPWS_MCAST_GROUP_IPv4 = new IPAddress("239.255.255.250", false, false, false);
    public static final IPAddress DPWS_MCAST_GROUP_IPv6 = new IPAddress("[FF02::C]", false, true, false);
    public static final int IPV6 = 6;
    public static final int IPV4 = 4;
    private String iface;
    protected IPAddress ipAddress = null;
    protected int ipVersion = -1;
    public static final int DISCOVERY_BINDING = 2;
    protected int port = -1;
    protected URI transportAddress = null;

    public DPWSDiscoveryBinding(int n, String string) {
        this.ipAddress = n == 6 ? DPWS_MCAST_GROUP_IPv6 : DPWS_MCAST_GROUP_IPv4;
        this.port = 3702;
        this.iface = string;
        this.ipVersion = n;
    }

    public URI getTransportAddress() {
        if (this.transportAddress == null) {
            this.transportAddress = new URI("http://" + this.getHostAddress() + ":" + this.port);
        }
        return this.transportAddress;
    }

    public String getIface() {
        return this.iface;
    }

    public String getCommunicationManagerId() {
        return "DPWS";
    }

    public int hashCode() {
        int n = 31 + (this.iface == null ? 0 : this.iface.hashCode());
        n = 31 * n + this.ipVersion;
        return n;
    }

    public IPAddress getHostAddress() {
        return this.ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public int getType() {
        return 2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DPWSDiscoveryBinding dPWSDiscoveryBinding = (DPWSDiscoveryBinding)object;
        if (this.iface == null ? dPWSDiscoveryBinding.iface != null : !this.iface.equals(dPWSDiscoveryBinding.iface)) {
            return false;
        }
        return this.ipVersion == dPWSDiscoveryBinding.ipVersion;
    }

    public String toString() {
        return (this.ipVersion == 6 ? "IPv6" : "IPv4") + " - " + this.iface;
    }
}

