/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication;

import org.ws4d.java.communication.ProtocolInfo;
import org.ws4d.java.configuration.DPWSProperties;
import org.ws4d.java.structures.HashSet;

public class DPWSProtocolInfo
extends ProtocolInfo {
    public static final int DPWS_VERSION_NOT_SET = -1;
    private static int preferredVersion = -1;
    private int httpRequestChunkedMode;
    private int httpResponseChunkedMode;

    public static int getPreferredVersion() {
        return preferredVersion;
    }

    public static void setPreferredVersion(int n) {
        preferredVersion = n;
    }

    public DPWSProtocolInfo() {
        if (preferredVersion == -1) {
            HashSet hashSet = DPWSProperties.getInstance().getSupportedDPWSVersions();
            if (hashSet.contains(new Integer(0))) {
                this.version = 0;
            } else if (hashSet.size() >= 1) {
                this.version = (Integer)hashSet.iterator().next();
            }
        } else {
            this.version = preferredVersion;
        }
        this.httpRequestChunkedMode = DPWSProperties.getInstance().getHTTPRequestChunkedMode();
        this.httpResponseChunkedMode = DPWSProperties.getInstance().getHTTPResponseChunkedMode();
    }

    public DPWSProtocolInfo(int n) {
        this.version = n;
        this.httpRequestChunkedMode = DPWSProperties.getInstance().getHTTPRequestChunkedMode();
        this.httpResponseChunkedMode = DPWSProperties.getInstance().getHTTPResponseChunkedMode();
    }

    private DPWSProtocolInfo(DPWSProtocolInfo dPWSProtocolInfo) {
        this.version = dPWSProtocolInfo.version;
        this.httpRequestChunkedMode = dPWSProtocolInfo.httpRequestChunkedMode;
        this.httpResponseChunkedMode = dPWSProtocolInfo.httpResponseChunkedMode;
    }

    public String getDisplayName() {
        switch (this.version) {
            case 0: {
                return "DPWS1.1";
            }
            case 1: {
                return "DPWS2006";
            }
        }
        return "Unknown DPWS Version";
    }

    public int getHttpRequestChunkedMode() {
        return this.httpRequestChunkedMode;
    }

    public void setHttpRequestChunkedMode(int n) {
        this.httpRequestChunkedMode = n;
    }

    public int getHttpResponseChunkedMode() {
        return this.httpResponseChunkedMode;
    }

    public void setHttpResponseChunkedMode(int n) {
        this.httpResponseChunkedMode = n;
    }

    public void merge(ProtocolInfo protocolInfo) {
        if (protocolInfo == null) {
            return;
        }
        if (preferredVersion != -1 && this.version != preferredVersion && protocolInfo.getVersion() == preferredVersion) {
            this.version = preferredVersion;
        } else if (0 == protocolInfo.getVersion()) {
            this.version = protocolInfo.getVersion();
        }
    }

    public ProtocolInfo newClone() {
        return new DPWSProtocolInfo(this);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.httpRequestChunkedMode;
        n = 31 * n + this.httpResponseChunkedMode;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DPWSProtocolInfo dPWSProtocolInfo = (DPWSProtocolInfo)object;
        if (this.httpRequestChunkedMode != dPWSProtocolInfo.httpRequestChunkedMode) {
            return false;
        }
        return this.httpResponseChunkedMode == dPWSProtocolInfo.httpResponseChunkedMode;
    }
}

