/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.connection.ip;

import java.io.IOException;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.ip.NetworkInterface;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LinkedList;
import org.ws4d.java.structures.List;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.StringUtil;

public abstract class IPNetworkDetection {
    protected static List networkinterfaces = null;
    protected static HashMap addresses = null;
    protected static IPAddress iPv4LoopbackAddress = null;
    private static IPNetworkDetection instance = null;

    public static IPNetworkDetection getInstance() {
        if (instance == null) {
            try {
                Class<?> clazz = Class.forName("org.ws4d.java.communication.connection.ip.PlatformIPNetworkDetection");
                instance = (IPNetworkDetection)clazz.newInstance();
            }
            catch (Exception exception) {
                Log.error("Unable to instantiate PlatformIPNetworkDetection: " + exception);
                throw new RuntimeException(exception.getMessage());
            }
        }
        return instance;
    }

    public final synchronized Iterator getNetworkInterfaces() {
        if (networkinterfaces == null) {
            try {
                this.detectInterfaces();
            }
            catch (IOException iOException) {
                Log.printStackTrace(iOException);
            }
        }
        return networkinterfaces.iterator();
    }

    public final synchronized Iterator getAddresses() {
        if (addresses == null) {
            try {
                this.detectAddresses();
            }
            catch (IOException iOException) {
                Log.printStackTrace(iOException);
            }
        }
        return addresses.entrySet().iterator();
    }

    public Iterator getAddresses(String string, String string2) {
        Iterator iterator = this.getNetworkInterfaces();
        LinkedList linkedList = new LinkedList();
        while (iterator.hasNext()) {
            NetworkInterface networkInterface = (NetworkInterface)iterator.next();
            if (string2 != null && !StringUtil.equalsIgnoreCase(networkInterface.getName(), string2)) continue;
            Iterator iterator2 = networkInterface.getAddresses();
            while (iterator2.hasNext()) {
                IPAddress iPAddress = (IPAddress)iterator2.next();
                if (string != null && (iPAddress.isIPv6() || !StringUtil.equalsIgnoreCase(string, "inet4")) && (!iPAddress.isIPv6() || !StringUtil.equalsIgnoreCase(string, "inet6"))) continue;
                linkedList.add(iPAddress);
            }
        }
        return linkedList.iterator();
    }

    public synchronized IPAddress getIPAddress(String string) {
        IPAddress iPAddress;
        if (addresses == null) {
            try {
                this.detectAddresses();
            }
            catch (IOException iOException) {
                Log.printStackTrace(iOException);
            }
        }
        if ((iPAddress = (IPAddress)addresses.get(string)) == null && string.indexOf(58) != -1 && string.charAt(0) != '[') {
            string = "[" + string + "]";
            iPAddress = (IPAddress)addresses.get(string);
        }
        if (iPAddress == null) {
            iPAddress = (IPAddress)addresses.get(this.getCanonicalAddress(string));
        }
        if (iPAddress == null && iPv4LoopbackAddress != null && string.startsWith("127.")) {
            return iPv4LoopbackAddress;
        }
        if (iPAddress == null && Log.isError()) {
            Iterator iterator = addresses.keySet().iterator();
            String string2 = "";
            while (iterator.hasNext()) {
                string2 = string2 + iterator.next();
                if (!iterator.hasNext()) continue;
                string2 = string2 + ", ";
            }
            Log.error("IPAddress object not found for " + string + ". Addresses found: " + string2);
            if (Log.isDebug()) {
                Log.printStackTrace(new Exception());
            }
        }
        return iPAddress;
    }

    public abstract String getCanonicalAddress(String var1);

    abstract void detectInterfaces() throws IOException;

    abstract void detectAddresses() throws IOException;
}

