/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.connection.ip;

import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LinkedList;

public class NetworkInterface {
    private DataStructure addresses = null;
    private String name = null;
    private final boolean supportsMulticast;
    private final boolean isUP;
    private final boolean isLoopback;

    public NetworkInterface(String string, boolean bl, boolean bl2, boolean bl3) {
        this.name = string;
        this.supportsMulticast = bl;
        this.isUP = bl2;
        this.isLoopback = bl3;
    }

    public String getName() {
        return this.name;
    }

    public void addAddress(IPAddress iPAddress) {
        if (this.addresses == null) {
            this.addresses = new LinkedList();
        }
        this.addresses.add(iPAddress);
    }

    public Iterator getAddresses() {
        if (this.addresses == null || this.addresses.size() == 0) {
            return null;
        }
        return this.addresses.iterator();
    }

    public boolean supportsMulticast() {
        return this.supportsMulticast;
    }

    public boolean isUp() {
        return this.isUP;
    }

    public boolean isLoopback() {
        return this.isLoopback;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getName());
        stringBuffer.append(" < ");
        Iterator iterator = this.addresses.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            stringBuffer.append(string);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" >");
        return stringBuffer.toString();
    }
}

