/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.connection.ip;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.ip.IPNetworkDetection;
import org.ws4d.java.communication.connection.ip.NetworkInterface;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LinkedList;
import org.ws4d.java.util.Log;

public class PlatformIPNetworkDetection
extends IPNetworkDetection {
    PlatformIPNetworkDetection() {
    }

    public String getCanonicalAddress(String string) {
        try {
            return InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    void detectInterfaces() throws IOException {
        if (Log.isDebug()) {
            Log.debug("Start interface detection...");
        }
        if (networkinterfaces != null) {
            networkinterfaces.clear();
        } else {
            networkinterfaces = new LinkedList();
        }
        Enumeration<java.net.NetworkInterface> enumeration = java.net.NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            java.net.NetworkInterface networkInterface = enumeration.nextElement();
            NetworkInterface networkInterface2 = new NetworkInterface(networkInterface.getName(), networkInterface.supportsMulticast(), networkInterface.isUp(), networkInterface.isLoopback());
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                networkInterface2.addAddress(new IPAddress(inetAddress.getHostAddress(), inetAddress.isLoopbackAddress(), inetAddress instanceof Inet6Address, inetAddress.isLinkLocalAddress()));
            }
            if (networkInterface2.getAddresses() == null) continue;
            networkinterfaces.add(networkInterface2);
            if (!Log.isDebug()) continue;
            Log.debug("Interface found: " + networkInterface2);
        }
        if (Log.isDebug()) {
            Log.debug("Interface detection done.");
        }
    }

    void detectAddresses() throws IOException {
        if (networkinterfaces == null) {
            this.detectInterfaces();
        }
        Iterator iterator = networkinterfaces.iterator();
        if (addresses != null) {
            addresses.clear();
        } else {
            addresses = new HashMap();
        }
        iPv4LoopbackAddress = null;
        while (iterator.hasNext()) {
            NetworkInterface networkInterface = (NetworkInterface)iterator.next();
            Iterator iterator2 = networkInterface.getAddresses();
            while (iterator2.hasNext()) {
                IPAddress iPAddress = (IPAddress)iterator2.next();
                String string = iPAddress.getAddress();
                if (iPAddress.isLoopback() && !iPAddress.isIPv6() && iPAddress.getAddress().startsWith("127.")) {
                    iPv4LoopbackAddress = iPAddress;
                }
                addresses.put(string, iPAddress);
                if (!iPAddress.isIPv6()) continue;
                addresses.put(iPAddress.getAddressWithoutNicId(), iPAddress);
            }
        }
    }
}

