/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.connection.tcp;

import java.io.IOException;
import java.net.InetAddress;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.tcp.SESocket;
import org.ws4d.java.communication.connection.tcp.ServerSocket;
import org.ws4d.java.communication.connection.tcp.Socket;

public class SEServerSocket
implements ServerSocket {
    private IPAddress ipAddress = null;
    private int port = -1;
    java.net.ServerSocket server = null;
    protected static final int PORT_RETRIES = 3;

    public SEServerSocket(IPAddress iPAddress, int n) throws IOException {
        InetAddress inetAddress = InetAddress.getByName(iPAddress.getAddress());
        try {
            this.server = new java.net.ServerSocket(n, 0, inetAddress);
            if (n == 0) {
                n = this.server.getLocalPort();
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage() + " for " + iPAddress + " at port " + n);
        }
        this.ipAddress = iPAddress;
        this.port = n;
    }

    public Socket accept() throws IOException {
        return new SESocket(this.server.accept(), this.getIPAddress());
    }

    public void close() throws IOException {
        this.server.close();
    }

    public IPAddress getIPAddress() {
        return this.ipAddress;
    }

    public int getPort() {
        return this.port;
    }
}

