/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.connection.tcp;

import java.io.IOException;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.tcp.TCPConnectionHandler;
import org.ws4d.java.communication.connection.tcp.TCPListener;
import org.ws4d.java.structures.HashMap;

public class TCPServer {
    private static final HashMap listeners = new HashMap();

    public static synchronized TCPListener open(IPAddress iPAddress, int n, TCPConnectionHandler tCPConnectionHandler) throws IOException {
        return TCPServer.open(iPAddress, n, tCPConnectionHandler, false, null);
    }

    public static synchronized TCPListener open(IPAddress iPAddress, int n, TCPConnectionHandler tCPConnectionHandler, boolean bl, String string) throws IOException {
        String string2;
        TCPListener tCPListener;
        if (iPAddress == null) {
            throw new IOException("Cannot create TCP listener. No IP address given.");
        }
        if (n < 0 || n > 65535) {
            throw new IOException("Cannot create TCP listener Port number invalid.");
        }
        if (n == 0) {
            tCPListener = new TCPListener(iPAddress, n, tCPConnectionHandler, bl, string);
            string2 = iPAddress.getAddress() + "@" + tCPListener.getPort();
        } else {
            string2 = iPAddress.getAddress() + "@" + n;
            tCPListener = (TCPListener)listeners.get(string2);
            if (tCPListener != null) {
                throw new IOException("Cannot create TCP listener for " + iPAddress + " and port " + n + ". This address is already in use.");
            }
            tCPListener = new TCPListener(iPAddress, n, tCPConnectionHandler, bl, string);
        }
        listeners.put(string2, tCPListener);
        tCPListener.start();
        return tCPListener;
    }

    public static synchronized void close(IPAddress iPAddress, int n) throws IOException {
        if (iPAddress == null) {
            return;
        }
        if (n < 1 || n > 65535) {
            return;
        }
        TCPListener tCPListener = null;
        tCPListener = (TCPListener)listeners.remove(iPAddress.getAddress() + "@" + n);
        if (tCPListener == null) {
            return;
        }
        tCPListener.stop();
    }
}

