/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.monitor;

import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.Resource;
import org.ws4d.java.communication.monitor.MonitoringContext;
import org.ws4d.java.communication.monitor.StreamMonitor;
import org.ws4d.java.message.Message;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.types.URI;

public abstract class MonitorStreamFactory {
    public static HashMap inMon = new HashMap();
    public static HashMap outMon = new HashMap();

    public abstract StreamMonitor createInputMonitor();

    public abstract StreamMonitor createOutputMonitor();

    public final synchronized StreamMonitor getInputMonitor(ProtocolData protocolData) {
        StreamMonitor streamMonitor = (StreamMonitor)inMon.get(protocolData.getInstanceId());
        if (streamMonitor == null) {
            streamMonitor = this.createInputMonitor();
            inMon.put(protocolData.getInstanceId(), streamMonitor);
        }
        return streamMonitor;
    }

    public final synchronized StreamMonitor getOutputMonitor(ProtocolData protocolData) {
        StreamMonitor streamMonitor = (StreamMonitor)outMon.get(protocolData.getInstanceId());
        if (streamMonitor == null) {
            streamMonitor = this.createOutputMonitor();
            outMon.put(protocolData.getInstanceId(), streamMonitor);
        }
        return streamMonitor;
    }

    public final synchronized void resetMonitoringContextIn(ProtocolData protocolData) {
        StreamMonitor streamMonitor = (StreamMonitor)inMon.get(protocolData.getInstanceId());
        if (streamMonitor != null) {
            streamMonitor.setMonitoringContext(null);
        }
    }

    public final synchronized void resetMonitoringContextOut(ProtocolData protocolData) {
        StreamMonitor streamMonitor = (StreamMonitor)outMon.get(protocolData.getInstanceId());
        if (streamMonitor != null) {
            streamMonitor.setMonitoringContext(null);
        }
    }

    public final synchronized MonitoringContext getNewMonitoringContextIn(ProtocolData protocolData) {
        StreamMonitor streamMonitor = (StreamMonitor)inMon.get(protocolData.getInstanceId());
        MonitoringContext monitoringContext = new MonitoringContext(protocolData);
        if (streamMonitor != null) {
            streamMonitor.setMonitoringContext(monitoringContext);
        }
        return monitoringContext;
    }

    public final synchronized MonitoringContext getNewMonitoringContextOut(ProtocolData protocolData) {
        StreamMonitor streamMonitor = (StreamMonitor)outMon.get(protocolData.getInstanceId());
        MonitoringContext monitoringContext = new MonitoringContext(protocolData);
        if (streamMonitor != null) {
            streamMonitor.setMonitoringContext(monitoringContext);
        }
        return monitoringContext;
    }

    public final synchronized MonitoringContext getMonitoringContextIn(ProtocolData protocolData) {
        StreamMonitor streamMonitor = (StreamMonitor)inMon.get(protocolData.getInstanceId());
        if (streamMonitor != null) {
            return streamMonitor.getMonitoringContext();
        }
        return null;
    }

    public final synchronized MonitoringContext getMonitoringContextOut(ProtocolData protocolData) {
        StreamMonitor streamMonitor = (StreamMonitor)outMon.get(protocolData.getInstanceId());
        if (streamMonitor != null) {
            return streamMonitor.getMonitoringContext();
        }
        return null;
    }

    public final synchronized void linkIn(ProtocolData protocolData, StreamMonitor streamMonitor) {
        inMon.put(protocolData.getInstanceId(), streamMonitor);
    }

    public final synchronized void linkOut(ProtocolData protocolData, StreamMonitor streamMonitor) {
        outMon.put(protocolData.getInstanceId(), streamMonitor);
    }

    public final synchronized void received(ProtocolData protocolData, MonitoringContext monitoringContext, Message message) {
        StreamMonitor streamMonitor = (StreamMonitor)inMon.get(protocolData.getInstanceId());
        if (streamMonitor != null) {
            streamMonitor.assign(monitoringContext, message);
        }
    }

    public final synchronized void discard(ProtocolData protocolData, MonitoringContext monitoringContext, int n) {
        StreamMonitor streamMonitor = (StreamMonitor)inMon.get(protocolData.getInstanceId());
        if (streamMonitor != null) {
            streamMonitor.discard(monitoringContext, n);
        }
    }

    public final synchronized void send(ProtocolData protocolData, MonitoringContext monitoringContext, Message message) {
        StreamMonitor streamMonitor = (StreamMonitor)outMon.get(protocolData.getInstanceId());
        if (streamMonitor != null) {
            streamMonitor.assign(monitoringContext, message);
        }
    }

    public final synchronized void receivedFault(ProtocolData protocolData, MonitoringContext monitoringContext, Exception exception) {
        StreamMonitor streamMonitor = (StreamMonitor)inMon.get(protocolData.getInstanceId());
        if (streamMonitor != null) {
            streamMonitor.fault(monitoringContext, exception);
        }
    }

    public final synchronized void sendFault(ProtocolData protocolData, MonitoringContext monitoringContext, Exception exception) {
        StreamMonitor streamMonitor = (StreamMonitor)outMon.get(protocolData.getInstanceId());
        if (streamMonitor != null) {
            streamMonitor.fault(monitoringContext, exception);
        }
    }

    public final synchronized void sendResource(ProtocolData protocolData, MonitoringContext monitoringContext, Resource resource) {
        StreamMonitor streamMonitor = (StreamMonitor)outMon.get(protocolData.getInstanceId());
        if (streamMonitor != null) {
            streamMonitor.resource(monitoringContext, resource);
        }
    }

    public final synchronized void requestResource(ProtocolData protocolData, MonitoringContext monitoringContext, URI uRI) {
        StreamMonitor streamMonitor = (StreamMonitor)outMon.get(protocolData.getInstanceId());
        if (streamMonitor != null) {
            streamMonitor.request(monitoringContext, uRI);
        }
    }

    public final synchronized void receivedResource(ProtocolData protocolData, MonitoringContext monitoringContext, Resource resource) {
        StreamMonitor streamMonitor = (StreamMonitor)inMon.get(protocolData.getInstanceId());
        if (streamMonitor != null) {
            streamMonitor.resource(monitoringContext, resource);
        }
    }
}

