/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.monitor;

import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.monitor.MonitorStreamFactory;
import org.ws4d.java.communication.monitor.MonitoringContext;
import org.ws4d.java.communication.protocol.soap.generator.MessageReceiver;
import org.ws4d.java.message.FaultMessage;
import org.ws4d.java.message.InvokeMessage;
import org.ws4d.java.message.discovery.ByeMessage;
import org.ws4d.java.message.discovery.HelloMessage;
import org.ws4d.java.message.discovery.ProbeMatchesMessage;
import org.ws4d.java.message.discovery.ProbeMessage;
import org.ws4d.java.message.discovery.ResolveMatchesMessage;
import org.ws4d.java.message.discovery.ResolveMessage;
import org.ws4d.java.message.eventing.GetStatusMessage;
import org.ws4d.java.message.eventing.GetStatusResponseMessage;
import org.ws4d.java.message.eventing.RenewMessage;
import org.ws4d.java.message.eventing.RenewResponseMessage;
import org.ws4d.java.message.eventing.SubscribeMessage;
import org.ws4d.java.message.eventing.SubscribeResponseMessage;
import org.ws4d.java.message.eventing.SubscriptionEndMessage;
import org.ws4d.java.message.eventing.UnsubscribeMessage;
import org.ws4d.java.message.eventing.UnsubscribeResponseMessage;
import org.ws4d.java.message.metadata.GetMessage;
import org.ws4d.java.message.metadata.GetMetadataMessage;
import org.ws4d.java.message.metadata.GetMetadataResponseMessage;
import org.ws4d.java.message.metadata.GetResponseMessage;
import org.ws4d.java.service.OperationDescription;

public class MonitoredMessageReceiver
implements MessageReceiver {
    private MessageReceiver receiver = null;
    private MonitoringContext context = null;
    private MonitorStreamFactory monFac = null;

    public MonitoredMessageReceiver(MessageReceiver messageReceiver, MonitoringContext monitoringContext) {
        this.receiver = messageReceiver;
        this.context = monitoringContext;
        this.monFac = DPWSFramework.getMonitorStreamFactory();
    }

    public void receive(HelloMessage helloMessage, ProtocolData protocolData) {
        this.receiver.receive(helloMessage, protocolData);
        if (this.monFac != null) {
            this.monFac.received(protocolData, this.context, helloMessage);
        }
    }

    public void receive(ByeMessage byeMessage, ProtocolData protocolData) {
        this.receiver.receive(byeMessage, protocolData);
        if (this.monFac != null) {
            this.monFac.received(protocolData, this.context, byeMessage);
        }
    }

    public void receive(ProbeMessage probeMessage, ProtocolData protocolData) {
        if (this.monFac != null) {
            this.monFac.received(protocolData, this.context, probeMessage);
        }
        this.receiver.receive(probeMessage, protocolData);
    }

    public void receive(ProbeMatchesMessage probeMatchesMessage, ProtocolData protocolData) {
        if (this.monFac != null) {
            this.monFac.received(protocolData, this.context, probeMatchesMessage);
        }
        this.receiver.receive(probeMatchesMessage, protocolData);
    }

    public void receive(ResolveMessage resolveMessage, ProtocolData protocolData) {
        if (this.monFac != null) {
            this.monFac.received(protocolData, this.context, resolveMessage);
        }
        this.receiver.receive(resolveMessage, protocolData);
    }

    public void receive(ResolveMatchesMessage resolveMatchesMessage, ProtocolData protocolData) {
        if (this.monFac != null) {
            this.monFac.received(protocolData, this.context, resolveMatchesMessage);
        }
        this.receiver.receive(resolveMatchesMessage, protocolData);
    }

    public void receive(GetMessage getMessage, ProtocolData protocolData) {
        if (this.monFac != null) {
            this.monFac.received(protocolData, this.context, getMessage);
        }
        this.receiver.receive(getMessage, protocolData);
    }

    public void receive(GetResponseMessage getResponseMessage, ProtocolData protocolData) {
        if (this.monFac != null) {
            this.monFac.received(protocolData, this.context, getResponseMessage);
        }
        this.receiver.receive(getResponseMessage, protocolData);
    }

    public void receive(GetMetadataMessage getMetadataMessage, ProtocolData protocolData) {
        if (this.monFac != null) {
            this.monFac.received(protocolData, this.context, getMetadataMessage);
        }
        this.receiver.receive(getMetadataMessage, protocolData);
    }

    public void receive(GetMetadataResponseMessage getMetadataResponseMessage, ProtocolData protocolData) {
        if (this.monFac != null) {
            this.monFac.received(protocolData, this.context, getMetadataResponseMessage);
        }
        this.receiver.receive(getMetadataResponseMessage, protocolData);
    }

    public void receive(SubscribeMessage subscribeMessage, ProtocolData protocolData) {
        if (this.monFac != null) {
            this.monFac.received(protocolData, this.context, subscribeMessage);
        }
        this.receiver.receive(subscribeMessage, protocolData);
    }

    public void receive(SubscribeResponseMessage subscribeResponseMessage, ProtocolData protocolData) {
        if (this.monFac != null) {
            this.monFac.received(protocolData, this.context, subscribeResponseMessage);
        }
        this.receiver.receive(subscribeResponseMessage, protocolData);
    }

    public void receive(GetStatusMessage getStatusMessage, ProtocolData protocolData) {
        if (this.monFac != null) {
            this.monFac.received(protocolData, this.context, getStatusMessage);
        }
        this.receiver.receive(getStatusMessage, protocolData);
    }

    public void receive(GetStatusResponseMessage getStatusResponseMessage, ProtocolData protocolData) {
        if (this.monFac != null) {
            this.monFac.received(protocolData, this.context, getStatusResponseMessage);
        }
        this.receiver.receive(getStatusResponseMessage, protocolData);
    }

    public void receive(RenewMessage renewMessage, ProtocolData protocolData) {
        if (this.monFac != null) {
            this.monFac.received(protocolData, this.context, renewMessage);
        }
        this.receiver.receive(renewMessage, protocolData);
    }

    public void receive(RenewResponseMessage renewResponseMessage, ProtocolData protocolData) {
        if (this.monFac != null) {
            this.monFac.received(protocolData, this.context, renewResponseMessage);
        }
        this.receiver.receive(renewResponseMessage, protocolData);
    }

    public void receive(UnsubscribeMessage unsubscribeMessage, ProtocolData protocolData) {
        if (this.monFac != null) {
            this.monFac.received(protocolData, this.context, unsubscribeMessage);
        }
        this.receiver.receive(unsubscribeMessage, protocolData);
    }

    public void receive(UnsubscribeResponseMessage unsubscribeResponseMessage, ProtocolData protocolData) {
        if (this.monFac != null) {
            this.monFac.received(protocolData, this.context, unsubscribeResponseMessage);
        }
        this.receiver.receive(unsubscribeResponseMessage, protocolData);
    }

    public void receive(SubscriptionEndMessage subscriptionEndMessage, ProtocolData protocolData) {
        if (this.monFac != null) {
            this.monFac.received(protocolData, this.context, subscriptionEndMessage);
        }
        this.receiver.receive(subscriptionEndMessage, protocolData);
    }

    public void receive(InvokeMessage invokeMessage, ProtocolData protocolData) {
        if (this.monFac != null) {
            this.monFac.received(protocolData, this.context, invokeMessage);
        }
        this.receiver.receive(invokeMessage, protocolData);
    }

    public void receive(FaultMessage faultMessage, ProtocolData protocolData) {
        if (this.monFac != null) {
            this.monFac.received(protocolData, this.context, faultMessage);
        }
        this.receiver.receive(faultMessage, protocolData);
    }

    public void receiveFailed(Exception exception, ProtocolData protocolData) {
        if (this.monFac != null) {
            this.monFac.receivedFault(protocolData, this.context, exception);
        }
        this.receiver.receiveFailed(exception, protocolData);
    }

    public void sendFailed(Exception exception, ProtocolData protocolData) {
        if (this.monFac != null) {
            this.monFac.receivedFault(protocolData, this.context, exception);
        }
        this.receiver.sendFailed(exception, protocolData);
    }

    public OperationDescription getOperation(String string) {
        return this.receiver.getOperation(string);
    }
}

