/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.http;

import java.io.IOException;
import java.io.OutputStream;

public class HTTPOutputStream
extends OutputStream {
    private long length = 0L;
    private OutputStream out = null;
    private boolean write = false;

    public HTTPOutputStream(OutputStream outputStream, long l) {
        this.length = l;
        this.out = outputStream;
    }

    public void setLength(long l) {
        if (this.write) {
            throw new IndexOutOfBoundsException("Cannot set length for the HTTP output stream. Bytes are already written to this stream.");
        }
        this.length = l;
    }

    public void write(int n) throws IOException {
        if (this.length > 0L) {
            --this.length;
            this.out.write(n);
            this.write = true;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.length - (long)n2 >= 0L) {
            this.out.write(byArray, n, n2);
            this.length -= (long)n2;
            this.write = true;
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.flush();
        this.out.close();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.out == null ? 0 : this.out.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HTTPOutputStream hTTPOutputStream = (HTTPOutputStream)object;
        return !(this.out == null ? hTTPOutputStream.out != null : !this.out.equals(hTTPOutputStream.out));
    }
}

