/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.DPWSProtocolData;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.ProtocolException;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.tcp.Socket;
import org.ws4d.java.communication.connection.tcp.SocketFactory;
import org.ws4d.java.communication.monitor.MonitorStreamFactory;
import org.ws4d.java.communication.monitor.MonitoredInputStream;
import org.ws4d.java.communication.monitor.MonitoredOutputStream;
import org.ws4d.java.communication.monitor.MonitoringContext;
import org.ws4d.java.communication.monitor.ResourceLoader;
import org.ws4d.java.communication.protocol.http.ChunkedOutputStream;
import org.ws4d.java.communication.protocol.http.HTTPInputStream;
import org.ws4d.java.communication.protocol.http.HTTPResponseUtil;
import org.ws4d.java.communication.protocol.http.HTTPUtil;
import org.ws4d.java.communication.protocol.http.header.HTTPRequestHeader;
import org.ws4d.java.communication.protocol.http.header.HTTPResponseHeader;
import org.ws4d.java.security.DPWSSecurityManager;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.types.InternetMediaType;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.Log;

public class HTTPRequestUtil {
    protected static final String FAULT_METHOD_NOT_SUPPORTED = "HTTP Method not supported.";
    protected static final String FAULT_UNEXPECTED_END = "Unexpected end of stream.";
    protected static final String FAULT_MALFORMED_REQUEST = "Malformed HTTP request line.";
    protected static final String FAULT_MALFORMED_HEADERFIELD = "Malformed HTTP header field.";
    protected static final String FAULT_MALFORMED_CHUNK = "Malformed HTTP chunk header.";
    protected static final String[] supportedMethods = new String[]{"GET", "HEAD", "POST"};
    protected static int delta = -1;

    private HTTPRequestUtil() {
    }

    public static HTTPRequestHeader handleRequest(InputStream inputStream) throws IOException, ProtocolException {
        String string = null;
        String string2 = null;
        String string3 = null;
        string = HTTPUtil.readElement(inputStream, delta);
        if (string == null || string.length() == 0) {
            return null;
        }
        boolean bl = false;
        for (int i = 0; i < supportedMethods.length; ++i) {
            if (!string.equals(supportedMethods[i])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new ProtocolException("HTTP Method not supported. (" + string + ")");
        }
        string2 = HTTPUtil.readElement(inputStream);
        string3 = HTTPUtil.readRequestVersion(inputStream);
        HashMap hashMap = new HashMap();
        HTTPUtil.readHeaderFields(inputStream, hashMap);
        return new HTTPRequestHeader(string, string2, string3, hashMap, null);
    }

    public static URI createRequestURI(String string, String string2) {
        String string3 = "http://" + string2;
        URI uRI = new URI(string3);
        URI uRI2 = new URI(string, uRI);
        return uRI2;
    }

    public static HTTPRequestHeader getDPWSPOSTHeader(String string) {
        HashMap hashMap = new HashMap();
        InternetMediaType internetMediaType = new InternetMediaType("application", "soap+xml");
        hashMap.put("Content-Type", internetMediaType.getMediaType());
        HTTPRequestHeader hTTPRequestHeader = new HTTPRequestHeader("POST", string, "HTTP/1.1", hashMap);
        return hTTPRequestHeader;
    }

    public static HTTPRequestHeader getDPWSGETHeader(String string) {
        HashMap hashMap = new HashMap();
        InternetMediaType internetMediaType = new InternetMediaType("application", "soap+xml");
        hashMap.put("Content-Type", internetMediaType.getMediaType());
        HTTPRequestHeader hTTPRequestHeader = new HTTPRequestHeader("GET", string, "HTTP/1.1", hashMap);
        return hTTPRequestHeader;
    }

    public static OutputStream writeRequest(OutputStream outputStream, String string, String string2, InternetMediaType internetMediaType, boolean bl, boolean bl2) throws IOException {
        return HTTPRequestUtil.writeRequest(outputStream, string, string2, null, internetMediaType, bl, bl2);
    }

    public static OutputStream writeRequest(OutputStream outputStream, String string, String string2, HashMap hashMap, InternetMediaType internetMediaType, boolean bl, boolean bl2) throws IOException {
        if (string == null || !string.equals("GET") && !string.equals("POST")) {
            throw new IOException("No HTTP method set.");
        }
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        HTTPRequestHeader hTTPRequestHeader = null;
        hTTPRequestHeader = string.equals("POST") ? new HTTPRequestHeader("POST", string2, "HTTP/1.1", hashMap) : new HTTPRequestHeader("GET", string2, "HTTP/1.1", hashMap);
        if (Log.isDebug()) {
            Log.debug("<O> " + hTTPRequestHeader.toString(), 1);
        }
        hTTPRequestHeader.addHeaderFieldValue("Content-Type", internetMediaType.toString());
        if (bl) {
            hTTPRequestHeader.addHeaderFieldValue("Transfer-Encoding", "chunked");
            hTTPRequestHeader.toStream(outputStream);
            return new ChunkedOutputStream(outputStream, bl2);
        }
        hTTPRequestHeader.toStream(outputStream);
        return outputStream;
    }

    public static ResourceLoader getResourceAsStream(String string) throws IOException, ProtocolException {
        if (string.toLowerCase().startsWith("http")) {
            Object object;
            Object object2;
            URI uRI = new URI(string);
            if (Log.isDebug()) {
                Log.debug("<O> Accessing resource over HTTP from " + string, 1);
            }
            MonitorStreamFactory monitorStreamFactory = DPWSFramework.getMonitorStreamFactory();
            Socket socket = null;
            if (DPWSFramework.hasModule(64) && string.toLowerCase().startsWith("https")) {
                object2 = DPWSFramework.getSecurityManager();
                if (!(object2 instanceof DPWSSecurityManager)) {
                    throw new IOException("Security manager is not valid for DPWS.");
                }
                socket = ((DPWSSecurityManager)object2).getSecureSocket(uRI);
            } else {
                socket = SocketFactory.getInstance().createSocket(new IPAddress(uRI.getHost()), uRI.getPort());
            }
            object2 = null;
            object2 = socket.getRemoteAddress() == null ? new DPWSProtocolData(null, false, socket.getLocalAddress().getAddressWithoutNicId(), socket.getLocalPort(), null, socket.getRemotePort(), true) : new DPWSProtocolData(null, false, socket.getLocalAddress().getAddressWithoutNicId(), socket.getLocalPort(), socket.getRemoteAddress().getAddressWithoutNicId(), socket.getRemotePort(), true);
            final OutputStream outputStream = DPWSFramework.getMonitorStreamFactory() != null ? new MonitoredOutputStream(socket.getOutputStream(), (ProtocolData)object2) : socket.getOutputStream();
            if (monitorStreamFactory != null) {
                monitorStreamFactory.getNewMonitoringContextOut((ProtocolData)object2);
            }
            HTTPRequestHeader hTTPRequestHeader = new HTTPRequestHeader("GET", uRI.getPath(), "HTTP/1.1");
            hTTPRequestHeader.addHeaderFieldValue("Host", uRI.getHost());
            hTTPRequestHeader.addHeaderFieldValue("Connection", "close");
            hTTPRequestHeader.toStream(outputStream);
            outputStream.flush();
            if (monitorStreamFactory != null) {
                object = monitorStreamFactory.getMonitoringContextOut((ProtocolData)object2);
                monitorStreamFactory.requestResource((ProtocolData)object2, (MonitoringContext)object, uRI);
            }
            object = null;
            if (Log.isDebug()) {
                object = socket.getRemoteAddress() + "@" + socket.getRemotePort();
                Log.debug("<O> " + hTTPRequestHeader + " to " + (String)object, 1);
            }
            DPWSProtocolData dPWSProtocolData = (DPWSProtocolData)((DPWSProtocolData)object2).createSwappedProtocolData();
            InputStream inputStream = socket.getInputStream();
            if (DPWSFramework.getMonitorStreamFactory() != null) {
                inputStream = new MonitoredInputStream(inputStream, dPWSProtocolData);
            }
            if (monitorStreamFactory != null) {
                monitorStreamFactory.getNewMonitoringContextIn(dPWSProtocolData);
            }
            HTTPResponseHeader hTTPResponseHeader = null;
            try {
                hTTPResponseHeader = HTTPResponseUtil.handleResponse(inputStream);
            }
            catch (ProtocolException protocolException) {
                Log.printStackTrace(protocolException);
            }
            if (hTTPResponseHeader == null) {
                throw new IOException("No HTTP response found.");
            }
            if (Log.isDebug()) {
                if (object == null) {
                    object = socket.getRemoteAddress() + "@" + socket.getRemotePort();
                }
                Log.debug("<I> " + hTTPResponseHeader + " from " + (String)object, 1);
            }
            String string2 = hTTPResponseHeader.getHeaderFieldValue("Transfer-Encoding");
            String string3 = hTTPResponseHeader.getHeaderFieldValue("Content-Length");
            int n = 0;
            if (string3 != null) {
                n = Integer.parseInt(string3.trim());
            }
            HTTPInputStream hTTPInputStream = new HTTPInputStream(inputStream, string2, n){

                public void close() throws IOException {
                    outputStream.close();
                    super.close();
                }
            };
            if (hTTPResponseHeader.getStatus() == 200) {
                ResourceLoader resourceLoader = new ResourceLoader(hTTPInputStream, (ProtocolData)object2);
                return resourceLoader;
            }
            if (hTTPResponseHeader.getStatus() == 301 || hTTPResponseHeader.getStatus() == 303 || hTTPResponseHeader.getStatus() == 307) {
                String string4 = hTTPResponseHeader.getHeaderFieldValue("Location");
                if (string4 == null) {
                    throw new IOException("HTTP Response malformed.");
                }
                ResourceLoader resourceLoader = HTTPRequestUtil.getResourceAsStream(string4);
                return resourceLoader;
            }
        }
        return null;
    }

    public static void writeLastChunk(OutputStream outputStream) throws IOException {
        if (outputStream instanceof ChunkedOutputStream) {
            ChunkedOutputStream.writeLastChunk((ChunkedOutputStream)outputStream);
        }
    }

    static {
        for (int i = 0; i < supportedMethods.length; ++i) {
            if (supportedMethods[i].length() <= delta) continue;
            delta = supportedMethods[i].length();
        }
    }
}

