/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ws4d.java.communication.ProtocolException;
import org.ws4d.java.communication.connection.tcp.TCPClient;
import org.ws4d.java.communication.connection.tcp.TCPConnection;
import org.ws4d.java.communication.protocol.http.ChunkedOutputStream;
import org.ws4d.java.communication.protocol.http.HTTPClientDestination;
import org.ws4d.java.communication.protocol.http.HTTPInputStream;
import org.ws4d.java.communication.protocol.http.HTTPOutputStream;
import org.ws4d.java.communication.protocol.http.HTTPResponseUtil;
import org.ws4d.java.communication.protocol.http.header.HTTPRequestHeader;
import org.ws4d.java.communication.protocol.http.header.HTTPResponseHeader;
import org.ws4d.java.util.Sync;

public class SimpleHTTPClient {
    private TCPConnection connection = null;
    private volatile InputStream in = null;
    private OutputStream out = null;
    private Object lock = new Object();
    private TCPClient client = null;
    private HTTPRequestHeader requestHeader = null;
    private HTTPResponseHeader responseHeader = null;
    private String request = "/";
    private boolean keepalive = true;
    private InputStream inBody = null;
    private HTTPClientDestination destination = null;

    public SimpleHTTPClient(HTTPClientDestination hTTPClientDestination) {
        this.destination = hTTPClientDestination;
    }

    public String getPresetRequest() {
        return this.request;
    }

    public synchronized void explicitConnect() throws IOException {
        if (this.connection == null) {
            this.client = TCPClient.connect(this.destination.getHost(), this.destination.getPort(), this.destination.isSecure(), this.destination.getAlias());
            this.connection = this.client.getConnection();
        }
    }

    public synchronized void resetConnection() {
        if (this.connection != null) {
            this.connection = null;
        }
    }

    public OutputStream exchange() throws IOException {
        return this.exchange(this.request);
    }

    public OutputStream exchange(String string) throws IOException {
        return this.exchange("GET", string);
    }

    public OutputStream exchange(String string, String string2) throws IOException {
        HTTPRequestHeader hTTPRequestHeader = new HTTPRequestHeader(string, string2, "HTTP/1.1");
        if (hTTPRequestHeader.getHeaderFieldValue("Host") == null) {
            hTTPRequestHeader.addHeaderFieldValue("Host", this.destination.getHost().getAddressWithoutNicId() + ':' + this.destination.getPort());
        }
        if (hTTPRequestHeader.getHeaderFieldValue("User-Agent") == null) {
            hTTPRequestHeader.addHeaderFieldValue("User-Agent", "JMEDS HTTP Client");
        }
        return this.exchange(hTTPRequestHeader, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream exchange(HTTPRequestHeader hTTPRequestHeader, boolean bl) throws IOException {
        String string;
        String string2;
        String string3;
        String string4;
        Object object;
        if (!this.keepalive) {
            throw new IOException("Cannot send new request. Server requested to close the connection.");
        }
        Object object2 = this;
        synchronized (object2) {
            if (this.connection == null) {
                this.client = TCPClient.connect(this.destination.getHost(), this.destination.getPort(), this.destination.isSecure(), this.destination.getAlias());
                this.connection = this.client.getConnection();
            }
            object = this.lock;
            synchronized (object) {
                this.in = this.connection.getInputStream();
                this.out = this.connection.getOutputStream();
                this.lock.notifyAll();
            }
        }
        object2 = hTTPRequestHeader.getHeaderFieldValue("Content-Length");
        object = hTTPRequestHeader.getHeaderFieldValue("Transfer-Encoding");
        int n = 0;
        if (object2 != null) {
            n = Integer.parseInt(((String)object2).trim());
        }
        if ("close".equals(string4 = hTTPRequestHeader.getHeaderFieldValue("Connection"))) {
            this.keepalive = false;
        }
        if ((string3 = hTTPRequestHeader.getHeaderFieldValue("User-Agent")) == null) {
            hTTPRequestHeader.addHeaderFieldValue("User-Agent", "JMEDS HTTP Client");
        }
        if ((string2 = hTTPRequestHeader.getHeaderFieldValue("Host")) == null) {
            hTTPRequestHeader.addHeaderFieldValue("Host", this.destination.getHost().getAddressWithoutNicId() + ':' + this.destination.getPort());
        }
        this.requestHeader = hTTPRequestHeader;
        if (bl) {
            hTTPRequestHeader.toStream(this.out);
            this.out.flush();
        }
        if ("100-continue".equals(string = hTTPRequestHeader.getHeaderFieldValue("Expect"))) {
            try {
                HTTPResponseHeader hTTPResponseHeader = HTTPResponseUtil.handleResponse(this.in);
                if (hTTPResponseHeader.getStatus() != 100) {
                    this.responseHeader = hTTPResponseHeader;
                    return new HTTPOutputStream(this.out, 0L);
                }
            }
            catch (ProtocolException protocolException) {
                throw new IOException("Cannot handle HTTP respone for continue: " + protocolException.getMessage());
            }
        }
        if ("chunked".equals(object)) {
            return new ChunkedOutputStream(this.out, false);
        }
        return new HTTPOutputStream(this.out, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHeader() throws IOException {
        SimpleHTTPClient simpleHTTPClient = this;
        synchronized (simpleHTTPClient) {
            if (this.connection == null) {
                this.client = TCPClient.connect(this.destination.getHost(), this.destination.getPort(), this.destination.isSecure(), this.destination.getAlias());
                this.connection = this.client.getConnection();
            }
            Object object = this.lock;
            synchronized (object) {
                this.in = this.connection.getInputStream();
                this.out = this.connection.getOutputStream();
                this.lock.notifyAll();
            }
        }
        this.requestHeader.toStream(this.out);
        this.out.flush();
    }

    public TCPClient getTCPClient() {
        return this.client;
    }

    public HTTPRequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPResponseHeader getResponseHeader() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            while (this.in == null) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
        try {
            this.responseHeader = HTTPResponseUtil.handleResponse(this.in);
        }
        catch (ProtocolException protocolException) {
            throw new IOException(protocolException.getMessage());
        }
        object = this.responseHeader.getHeaderFieldValue("Connection");
        if ("close".equals(object)) {
            this.keepalive = false;
        }
        return this.responseHeader;
    }

    public InputStream getResponseBody() {
        return this.getResponseBody(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResponseBody(Sync sync) {
        Object object = this.lock;
        synchronized (object) {
            while (this.in == null) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
        object = this.responseHeader.getHeaderFieldValue("Transfer-Encoding");
        String string = this.responseHeader.getHeaderFieldValue("Content-Length");
        int n = 0;
        if (string != null) {
            n = Integer.parseInt(string.trim());
        }
        this.inBody = new HTTPInputStream(this.in, (String)object, n, sync);
        return this.inBody;
    }

    public boolean isKeepAlive() {
        return this.keepalive;
    }

    public synchronized void close() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public int hashCode() {
        return this.destination.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SimpleHTTPClient simpleHTTPClient = (SimpleHTTPClient)object;
        if (this.destination.getHost() == null ? simpleHTTPClient.destination.getHost() != null : !this.destination.getHost().equals(simpleHTTPClient.destination.getHost())) {
            return false;
        }
        return this.destination.getPort() == simpleHTTPClient.destination.getPort();
    }

    public boolean isSecure() {
        return this.destination.isSecure();
    }

    public String getAlias() {
        return this.destination.getAlias();
    }

    HTTPClientDestination getDestination() {
        return this.destination;
    }
}

