/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.soap.generator;

import java.io.IOException;
import java.io.OutputStream;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.CommunicationUtil;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.protocol.soap.generator.DefaultMessageSerializer;
import org.ws4d.java.communication.protocol.soap.generator.Message2SOAPGenerator;
import org.ws4d.java.communication.protocol.soap.generator.MessageSerializer;
import org.ws4d.java.configuration.FrameworkProperties;
import org.ws4d.java.constants.ConstantsHelper;
import org.ws4d.java.io.xml.XmlSerializer;
import org.ws4d.java.io.xml.XmlSerializerImplementation;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.SOAPHeader;
import org.ws4d.java.security.SecurityManager;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.types.ByteArrayBuffer;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.WS4DIllegalStateException;
import org.xmlpull.v1.IllegalStateException;

public class DefaultMessage2SOAPGenerator
implements Message2SOAPGenerator {
    protected static final HashMap BYTE_ARRAY_POOL = new HashMap(10);
    protected XmlSerializer serializer = new XmlSerializerImplementation();
    protected MessageSerializer msgSerializer = new DefaultMessageSerializer();
    protected ConstantsHelper helper = null;

    public void generateSOAPMessage(OutputStream outputStream, Message message, ProtocolData protocolData) throws IllegalArgumentException, WS4DIllegalStateException, IOException {
        if (message == null) {
            return;
        }
        this.setOutput(outputStream);
        this.internalGenerateSOAPMessage(message, protocolData);
    }

    public ByteArrayBuffer generateSOAPMessage(Message message, ProtocolData protocolData) throws IOException {
        if (message == null) {
            return null;
        }
        ReusableByteArrayOutputStream reusableByteArrayOutputStream = DefaultMessage2SOAPGenerator.getByteStream();
        reusableByteArrayOutputStream.reset();
        this.setOutput(reusableByteArrayOutputStream);
        this.internalGenerateSOAPMessage(message, protocolData);
        return new ByteArrayBuffer(reusableByteArrayOutputStream.getBuffer(), reusableByteArrayOutputStream.getCurrentSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ReusableByteArrayOutputStream getByteStream() {
        HashMap hashMap = BYTE_ARRAY_POOL;
        synchronized (hashMap) {
            Thread thread = Thread.currentThread();
            ReusableByteArrayOutputStream reusableByteArrayOutputStream = (ReusableByteArrayOutputStream)BYTE_ARRAY_POOL.get(thread);
            if (reusableByteArrayOutputStream == null) {
                reusableByteArrayOutputStream = new ReusableByteArrayOutputStream();
                BYTE_ARRAY_POOL.put(thread, reusableByteArrayOutputStream);
            }
            return reusableByteArrayOutputStream;
        }
    }

    protected DefaultMessage2SOAPGenerator() {
    }

    protected void setOutput(OutputStream outputStream) throws IOException {
        this.serializer.setOutput(outputStream, "UTF-8");
    }

    protected void internalGenerateSOAPMessage(Message message, ProtocolData protocolData) throws IOException {
        Object object;
        CommunicationManager communicationManager = DPWSFramework.getCommunicationManager(protocolData.getCommunicationManagerId());
        CommunicationUtil communicationUtil = communicationManager.getCommunicationUtil();
        this.helper = communicationUtil.getHelper(message.getHeader().getProtocolInfo().getVersion());
        if (Log.isDebug()) {
            Log.debug("<O> Communicate over :" + message.getHeader().getProtocolInfo().getDisplayName() + ", Action: " + message.getAction() + ", Id: " + message.getMessageId(), 4);
        }
        if (message.getType() != 2 && message.getType() != 1 && message.getType() != 4 && message.getType() != 6 || !message.isSecure() && this.serializer.getType() != 0) {
            object = this.serializer;
            this.serializer = new XmlSerializerImplementation();
            this.serializer.setOutput(object.getOutput());
        } else if (message.isSecure() && (message.getType() == 2 || message.getType() == 1 || message.getType() == 4 || message.getType() == 6)) {
            try {
                object = this.serializer;
                if (!DPWSFramework.hasModule(64)) {
                    throw new Exception("DPWS Security Module not found. Unable to use canonical serializer.");
                }
                this.serializer = DPWSFramework.getSecurityManager().getNewCanonicalSerializer("BID1");
                this.serializer.setOutput(object.getOutput());
            }
            catch (Exception exception) {
                Log.printStackTrace(exception);
            }
        }
        this.serializer.startDocument("UTF-8", null);
        this.addStandardNamespaces(message);
        this.serializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Envelope");
        object = message.getHeader();
        if (object == null) {
            throw new WS4DIllegalStateException("No message header defined. Cannot serialize message.");
        }
        this.msgSerializer.serialize((SOAPHeader)object, this.serializer, protocolData);
        this.msgSerializer.serialize(message, this.serializer, protocolData);
        this.serializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Envelope");
        if (message.isSecure() && (message.getType() == 2 || message.getType() == 1 || message.getType() == 4 || message.getType() == 6)) {
            this.signMessageCompact(message);
        }
        this.serializer.flushCache();
        this.serializer.endDocument();
    }

    protected void addStandardNamespaces(Message message) throws IOException {
        this.serializer.setPrefix(this.helper.getDPWSNamespacePrefix(), this.helper.getDPWSNamespace());
        this.serializer.setPrefix("s12", "http://www.w3.org/2003/05/soap-envelope");
        this.serializer.setPrefix("wsa", this.helper.getWSANamespace());
        if (message.getType() >= 1 && message.getType() <= 6) {
            this.serializer.setPrefix("wsd", this.helper.getWSDNamespace());
        }
        if (message.getType() >= 301 && message.getType() <= 309) {
            this.serializer.setPrefix("wse", "http://schemas.xmlsoap.org/ws/2004/08/eventing");
        } else if (message.getType() == 201 || message.getType() == 202 || message.getType() == 102) {
            this.serializer.setPrefix("wsx", "http://schemas.xmlsoap.org/ws/2004/09/mex");
        }
    }

    protected void signMessageCompact(Message message) {
        SecurityManager securityManager = DPWSFramework.getSecurityManager();
        String string = securityManager.getBodySignature(this.serializer, message);
        try {
            this.serializer.injectSecurityStart();
            this.serializer.startTag("http://schemas.xmlsoap.org/ws/2005/04/discovery", "Security");
            this.serializer.startTag("http://schemas.xmlsoap.org/ws/2005/04/discovery", "Sig");
            this.serializer.attribute(null, "Scheme", "http://schemas.xmlsoap.org/ws/2005/04/discovery/rsa");
            this.serializer.attribute(null, "Refs", "BID1");
            this.serializer.attribute(null, "Sig", string);
            this.serializer.endTag("http://schemas.xmlsoap.org/ws/2005/04/discovery", "Sig");
            this.serializer.endTag("http://schemas.xmlsoap.org/ws/2005/04/discovery", "Security");
            this.serializer.injectSecurityDone();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static class ReusableByteArrayOutputStream
    extends OutputStream {
        private final byte[] buf = new byte[FrameworkProperties.getInstance().getMaxDatagramSize()];
        private int pointer = 0;

        ReusableByteArrayOutputStream() {
        }

        public void write(int n) throws IOException {
            if (this.pointer == this.buf.length) {
                throw new IOException("Buffer size exceeded");
            }
            this.buf[this.pointer++] = (byte)n;
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.pointer + (n2 - n) >= this.buf.length) {
                throw new IOException("Buffer size exceeded (current=" + this.buf.length + ", new to store=" + (n2 - n));
            }
            System.arraycopy(byArray, n, this.buf, this.pointer, n2);
            this.pointer += n2;
        }

        public void close() throws IOException {
            this.reset();
        }

        void reset() {
            this.pointer = 0;
        }

        byte[] getBuffer() {
            return this.buf;
        }

        int getCurrentSize() {
            return this.pointer;
        }
    }
}

