/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.soap.generator;

import java.io.IOException;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.CommunicationUtil;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.VersionMismatchException;
import org.ws4d.java.communication.protocol.soap.generator.MessageParser;
import org.ws4d.java.constants.ConstantsHelper;
import org.ws4d.java.io.xml.ElementHandler;
import org.ws4d.java.io.xml.ElementParser;
import org.ws4d.java.message.FaultMessage;
import org.ws4d.java.message.InvokeMessage;
import org.ws4d.java.message.SOAPHeader;
import org.ws4d.java.message.discovery.ByeMessage;
import org.ws4d.java.message.discovery.HelloMessage;
import org.ws4d.java.message.discovery.ProbeMatch;
import org.ws4d.java.message.discovery.ProbeMatchesMessage;
import org.ws4d.java.message.discovery.ProbeMessage;
import org.ws4d.java.message.discovery.ResolveMatch;
import org.ws4d.java.message.discovery.ResolveMatchesMessage;
import org.ws4d.java.message.discovery.ResolveMessage;
import org.ws4d.java.message.eventing.GetStatusMessage;
import org.ws4d.java.message.eventing.GetStatusResponseMessage;
import org.ws4d.java.message.eventing.RenewMessage;
import org.ws4d.java.message.eventing.RenewResponseMessage;
import org.ws4d.java.message.eventing.SubscribeMessage;
import org.ws4d.java.message.eventing.SubscribeResponseMessage;
import org.ws4d.java.message.eventing.SubscriptionEndMessage;
import org.ws4d.java.message.eventing.UnsubscribeMessage;
import org.ws4d.java.message.eventing.UnsubscribeResponseMessage;
import org.ws4d.java.message.metadata.GetMessage;
import org.ws4d.java.message.metadata.GetMetadataMessage;
import org.ws4d.java.message.metadata.GetMetadataResponseMessage;
import org.ws4d.java.message.metadata.GetResponseMessage;
import org.ws4d.java.service.Fault;
import org.ws4d.java.service.OperationDescription;
import org.ws4d.java.service.parameter.ParameterDefinition;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.List;
import org.ws4d.java.types.AppSequence;
import org.ws4d.java.types.AttributedURI;
import org.ws4d.java.types.CustomizeMDataHandler;
import org.ws4d.java.types.Delivery;
import org.ws4d.java.types.DiscoveryData;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.EndpointReference2004;
import org.ws4d.java.types.EprInfo;
import org.ws4d.java.types.EprInfoSet;
import org.ws4d.java.types.Filter;
import org.ws4d.java.types.HostMData;
import org.ws4d.java.types.HostedMData;
import org.ws4d.java.types.MetadataMData;
import org.ws4d.java.types.ProbeScopeSet;
import org.ws4d.java.types.QName;
import org.ws4d.java.types.QNameSet;
import org.ws4d.java.types.ReferenceParametersMData;
import org.ws4d.java.types.RelationshipMData;
import org.ws4d.java.types.ScopeSet;
import org.ws4d.java.types.ThisDeviceMData;
import org.ws4d.java.types.ThisModelMData;
import org.ws4d.java.types.URI;
import org.ws4d.java.types.URISet;
import org.ws4d.java.types.UnknownDataContainer;
import org.ws4d.java.types.XAddressInfo;
import org.ws4d.java.types.XAddressInfoSet;
import org.ws4d.java.util.Log;
import org.ws4d.java.wsdl.WSDL;
import org.xmlpull.v1.XmlPullParserException;

class DefaultMessageParser
extends MessageParser {
    DefaultMessageParser() {
    }

    public SOAPHeader parseSOAPHeader(ElementParser elementParser, ProtocolData protocolData, ConstantsHelper constantsHelper) throws XmlPullParserException, IOException, VersionMismatchException {
        return this.parseSOAPHeader(elementParser, constantsHelper, protocolData);
    }

    public HelloMessage parseHelloMessage(SOAPHeader sOAPHeader, ElementParser elementParser, ProtocolData protocolData, ConstantsHelper constantsHelper) throws XmlPullParserException, IOException {
        DiscoveryData discoveryData = new DiscoveryData();
        this.parse(discoveryData, elementParser, "Hello", constantsHelper, protocolData.getCommunicationManagerId());
        HelloMessage helloMessage = new HelloMessage(sOAPHeader, discoveryData);
        if (helloMessage.getHeader().getSignature() != null) {
            String[] stringArray = new String[helloMessage.getXAddressInfoSet().size()];
            Iterator iterator = helloMessage.getXAddressInfoSet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                stringArray[n] = ((XAddressInfo)iterator.next()).getXAddress().toString();
                ++n;
            }
            helloMessage.getHeader().setValidated(DPWSFramework.getSecurityManager().validateMessage(helloMessage.getHeader().getSignature(), protocolData, helloMessage.getEndpointReference(), stringArray));
        }
        return helloMessage;
    }

    public ByeMessage parseByeMessage(SOAPHeader sOAPHeader, ElementParser elementParser, ProtocolData protocolData, ConstantsHelper constantsHelper) throws XmlPullParserException, IOException {
        DiscoveryData discoveryData = new DiscoveryData();
        this.parse(discoveryData, elementParser, "Bye", constantsHelper, protocolData.getCommunicationManagerId());
        ByeMessage byeMessage = new ByeMessage(sOAPHeader, discoveryData);
        if (byeMessage.getHeader().getSignature() != null) {
            String[] stringArray = new String[byeMessage.getXAddressInfoSet().size()];
            Iterator iterator = byeMessage.getXAddressInfoSet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                stringArray[n] = ((XAddressInfo)iterator.next()).getXAddress().toString();
                ++n;
            }
            byeMessage.getHeader().setValidated(DPWSFramework.getSecurityManager().validateMessage(byeMessage.getHeader().getSignature(), protocolData, byeMessage.getEndpointReference(), stringArray));
        }
        return byeMessage;
    }

    public ProbeMessage parseProbeMessage(SOAPHeader sOAPHeader, ElementParser elementParser, ProtocolData protocolData, ConstantsHelper constantsHelper) throws XmlPullParserException, IOException {
        ProbeMessage probeMessage = new ProbeMessage(sOAPHeader);
        this.parseUnknownAttributes(probeMessage, elementParser);
        while (elementParser.nextTag() != 3) {
            String string = elementParser.getNamespace();
            String string2 = elementParser.getName();
            if (constantsHelper.getWSDNamespace().equals(string)) {
                if ("Types".equals(string2)) {
                    probeMessage.setTypes(this.parseQNameSet(elementParser));
                    String string3 = sOAPHeader.getCommunicationManagerID();
                    CommunicationManager communicationManager = DPWSFramework.getCommunicationManager(string3);
                    CommunicationUtil communicationUtil = communicationManager.getCommunicationUtil();
                    communicationUtil.changeIncomingProbe(probeMessage);
                    continue;
                }
                if ("Scopes".equals(string2)) {
                    probeMessage.setScopes(this.parseNextProbeScopeSet(elementParser));
                    continue;
                }
                this.parseUnknownElement(probeMessage, elementParser, string, string2);
                continue;
            }
            this.parseUnknownElement(probeMessage, elementParser, string, string2);
        }
        return probeMessage;
    }

    public ProbeMatchesMessage parseProbeMatchesMessage(SOAPHeader sOAPHeader, ElementParser elementParser, ProtocolData protocolData, ConstantsHelper constantsHelper) throws XmlPullParserException, IOException {
        String[] stringArray;
        Object object;
        ProbeMatchesMessage probeMatchesMessage = new ProbeMatchesMessage(sOAPHeader);
        this.parseUnknownAttributes(probeMatchesMessage, elementParser);
        while (elementParser.nextTag() != 3) {
            object = elementParser.getNamespace();
            String string = elementParser.getName();
            if (constantsHelper.getWSDNamespace().equals(object)) {
                if ("ProbeMatch".equals(string)) {
                    stringArray = new ProbeMatch();
                    this.parse((DiscoveryData)stringArray, elementParser, "ProbeMatch", constantsHelper, protocolData.getCommunicationManagerId());
                    probeMatchesMessage.addProbeMatch((ProbeMatch)stringArray);
                    continue;
                }
                this.parseUnknownElement(probeMatchesMessage, elementParser, (String)object, string);
                continue;
            }
            this.parseUnknownElement(probeMatchesMessage, elementParser, (String)object, string);
        }
        if (DPWSFramework.hasModule(64) && probeMatchesMessage.getHeader().getSignature() != null && probeMatchesMessage.getProbeMatch(0) != null) {
            int n;
            object = new ArrayList();
            for (int i = 0; i < probeMatchesMessage.getProbeMatchCount(); ++i) {
                stringArray = probeMatchesMessage.getProbeMatch(i).getXAddressInfoSet().iterator();
                n = 0;
                while (stringArray.hasNext()) {
                    String string = ((XAddressInfo)stringArray.next()).getXAddress().toString();
                    if (!((ArrayList)object).contains(string)) {
                        ((ArrayList)object).add(string);
                    }
                    ++n;
                }
            }
            Iterator iterator = ((List)object).iterator();
            stringArray = new String[((List)object).size()];
            for (n = 0; n < ((List)object).size(); ++n) {
                stringArray[n] = iterator.next().toString();
            }
            probeMatchesMessage.setSecure(true);
            probeMatchesMessage.getHeader().setValidated(DPWSFramework.getSecurityManager().validateMessage(probeMatchesMessage.getHeader().getSignature(), protocolData, probeMatchesMessage.getProbeMatch(0).getEndpointReference(), stringArray));
        }
        return probeMatchesMessage;
    }

    public ResolveMessage parseResolveMessage(SOAPHeader sOAPHeader, ElementParser elementParser, ProtocolData protocolData, ConstantsHelper constantsHelper) throws XmlPullParserException, IOException {
        ResolveMessage resolveMessage = new ResolveMessage(sOAPHeader);
        this.parseUnknownAttributes(resolveMessage, elementParser);
        int n = elementParser.nextTag();
        if (n == 3) {
            throw new XmlPullParserException("Resolve is empty");
        }
        do {
            String string = elementParser.getNamespace();
            String string2 = elementParser.getName();
            if (constantsHelper.getWSANamespace().equals(string)) {
                if ("EndpointReference".equals(string2)) {
                    resolveMessage.setEndpointReference(this.parseEndpointReference(constantsHelper.getDPWSVersion(), elementParser));
                    continue;
                }
                this.parseUnknownElement(resolveMessage, elementParser, string, string2);
                continue;
            }
            this.parseUnknownElement(resolveMessage, elementParser, string, string2);
        } while ((n = elementParser.nextTag()) != 3);
        return resolveMessage;
    }

    public ResolveMatchesMessage parseResolveMatchesMessage(SOAPHeader sOAPHeader, ElementParser elementParser, ProtocolData protocolData, ConstantsHelper constantsHelper) throws XmlPullParserException, IOException {
        ResolveMatchesMessage resolveMatchesMessage = new ResolveMatchesMessage(sOAPHeader);
        this.parseUnknownAttributes(resolveMatchesMessage, elementParser);
        while (elementParser.nextTag() != 3) {
            String string = elementParser.getNamespace();
            String string2 = elementParser.getName();
            if (constantsHelper.getWSDNamespace().equals(string)) {
                if ("ResolveMatch".equals(string2)) {
                    ResolveMatch resolveMatch = new ResolveMatch();
                    this.parse(resolveMatch, elementParser, "ResolveMatch", constantsHelper, protocolData.getCommunicationManagerId());
                    resolveMatchesMessage.setResolveMatch(resolveMatch);
                    continue;
                }
                this.parseUnknownElement(resolveMatchesMessage, elementParser, string, string2);
                continue;
            }
            this.parseUnknownElement(resolveMatchesMessage, elementParser, string, string2);
        }
        if (resolveMatchesMessage.getHeader().getSignature() != null && resolveMatchesMessage.getResolveMatch() != null) {
            resolveMatchesMessage.getHeader().setValidated(DPWSFramework.getSecurityManager().validateMessage(resolveMatchesMessage.getHeader().getSignature(), protocolData, resolveMatchesMessage.getResolveMatch().getEndpointReference(), null));
        }
        return resolveMatchesMessage;
    }

    public InvokeMessage parseInvokeMessage(SOAPHeader sOAPHeader, ElementParser elementParser, ProtocolData protocolData, ConstantsHelper constantsHelper) throws XmlPullParserException, IOException {
        return null;
    }

    public GetStatusMessage parseGetStatusMessage(SOAPHeader sOAPHeader, ElementParser elementParser, ProtocolData protocolData, ConstantsHelper constantsHelper) throws XmlPullParserException, IOException {
        GetStatusMessage getStatusMessage = new GetStatusMessage(sOAPHeader);
        elementParser.nextGenericElement(getStatusMessage);
        return getStatusMessage;
    }

    public GetStatusResponseMessage parseGetStatusResponseMessage(SOAPHeader sOAPHeader, ElementParser elementParser, ProtocolData protocolData, ConstantsHelper constantsHelper) throws XmlPullParserException, IOException {
        GetStatusResponseMessage getStatusResponseMessage = new GetStatusResponseMessage(sOAPHeader);
        while (elementParser.nextTag() != 3) {
            String string = elementParser.getNamespace();
            String string2 = elementParser.getName();
            if ("http://schemas.xmlsoap.org/ws/2004/08/eventing".equals(string)) {
                if ("Expires".equals(string2)) {
                    getStatusResponseMessage.setExpires(elementParser.nextText());
                    continue;
                }
                this.parseUnknownElement(getStatusResponseMessage, elementParser, string, string2);
                continue;
            }
            this.parseUnknownElement(getStatusResponseMessage, elementParser, string, string2);
        }
        return getStatusResponseMessage;
    }

    public RenewMessage parseRenewMessage(SOAPHeader sOAPHeader, ElementParser elementParser, ProtocolData protocolData, ConstantsHelper constantsHelper) throws XmlPullParserException, IOException {
        RenewMessage renewMessage = new RenewMessage(sOAPHeader);
        this.parseUnknownAttributes(renewMessage, elementParser);
        while (elementParser.nextTag() != 3) {
            String string = elementParser.getNamespace();
            String string2 = elementParser.getName();
            if ("http://schemas.xmlsoap.org/ws/2004/08/eventing".equals(string)) {
                if ("Expires".equals(string2)) {
                    renewMessage.setExpires(elementParser.nextText());
                    continue;
                }
                this.parseUnknownElement(renewMessage, elementParser, string, string2);
                continue;
            }
            this.parseUnknownElement(renewMessage, elementParser, string, string2);
        }
        return renewMessage;
    }

    public RenewResponseMessage parseRenewResponseMessage(SOAPHeader sOAPHeader, ElementParser elementParser, ProtocolData protocolData, ConstantsHelper constantsHelper) throws XmlPullParserException, IOException {
        RenewResponseMessage renewResponseMessage = new RenewResponseMessage(sOAPHeader);
        while (elementParser.nextTag() != 3) {
            String string = elementParser.getNamespace();
            String string2 = elementParser.getName();
            if ("http://schemas.xmlsoap.org/ws/2004/08/eventing".equals(string)) {
                if ("Expires".equals(string2)) {
                    renewResponseMessage.setExpires(elementParser.nextText());
                    continue;
                }
                this.parseUnknownElement(renewResponseMessage, elementParser, string, string2);
                continue;
            }
            this.parseUnknownElement(renewResponseMessage, elementParser, string, string2);
        }
        return renewResponseMessage;
    }

    public SubscribeMessage parseSubscribeMessage(SOAPHeader sOAPHeader, ElementParser elementParser, ProtocolData protocolData, ConstantsHelper constantsHelper) throws XmlPullParserException, IOException {
        SubscribeMessage subscribeMessage = new SubscribeMessage(sOAPHeader);
        this.parseUnknownAttributes(subscribeMessage, elementParser);
        int n = elementParser.nextTag();
        if (n == 3) {
            throw new XmlPullParserException("Subscribe is empty");
        }
        do {
            String string = elementParser.getNamespace();
            String string2 = elementParser.getName();
            CommunicationManager communicationManager = DPWSFramework.getCommunicationManager(sOAPHeader.getCommunicationManagerID());
            CommunicationUtil communicationUtil = communicationManager.getCommunicationUtil();
            if ("http://schemas.xmlsoap.org/ws/2004/08/eventing".equals(string)) {
                if ("EndTo".equals(string2)) {
                    subscribeMessage.setEndTo(this.parseEndpointReference(sOAPHeader.getProtocolInfo().getVersion(), elementParser));
                    continue;
                }
                if ("Delivery".equals(string2)) {
                    subscribeMessage.setDelivery(this.parseDelivery(elementParser, communicationUtil.getHelper(sOAPHeader.getProtocolInfo().getVersion()), sOAPHeader.getCommunicationManagerID()));
                    continue;
                }
                if ("Expires".equals(string2)) {
                    subscribeMessage.setExpires(elementParser.nextText());
                    continue;
                }
                if ("Filter".equals(string2)) {
                    subscribeMessage.setFilter(this.parseFilter(elementParser, sOAPHeader.getCommunicationManagerID()));
                    continue;
                }
                this.parseUnknownElement(subscribeMessage, elementParser, string, string2);
                continue;
            }
            this.parseUnknownElement(subscribeMessage, elementParser, string, string2);
        } while ((n = elementParser.nextTag()) != 3);
        return subscribeMessage;
    }

    public SubscribeResponseMessage parseSubscribeResponseMessage(SOAPHeader sOAPHeader, ElementParser elementParser, ProtocolData protocolData, ConstantsHelper constantsHelper) throws XmlPullParserException, IOException {
        SubscribeResponseMessage subscribeResponseMessage = new SubscribeResponseMessage(sOAPHeader);
        this.parseUnknownAttributes(subscribeResponseMessage, elementParser);
        int n = elementParser.nextTag();
        if (n == 3) {
            throw new XmlPullParserException("SubscribeResponse is empty");
        }
        do {
            String string = elementParser.getNamespace();
            String string2 = elementParser.getName();
            if ("http://schemas.xmlsoap.org/ws/2004/08/eventing".equals(string)) {
                if ("SubscriptionManager".equals(string2)) {
                    subscribeResponseMessage.setSubscriptionManager(this.parseEndpointReference(sOAPHeader.getProtocolInfo().getVersion(), elementParser));
                    continue;
                }
                if ("Expires".equals(string2)) {
                    subscribeResponseMessage.setExpires(elementParser.nextText());
                    continue;
                }
                this.parseUnknownElement(subscribeResponseMessage, elementParser, string, string2);
                continue;
            }
            this.parseUnknownElement(subscribeResponseMessage, elementParser, string, string2);
        } while ((n = elementParser.nextTag()) != 3);
        return subscribeResponseMessage;
    }

    public SubscriptionEndMessage parseSubscriptionEndMessage(SOAPHeader sOAPHeader, ElementParser elementParser, ProtocolData protocolData, ConstantsHelper constantsHelper) throws XmlPullParserException, IOException {
        SubscriptionEndMessage subscriptionEndMessage = new SubscriptionEndMessage(sOAPHeader);
        this.parseUnknownAttributes(subscriptionEndMessage, elementParser);
        int n = elementParser.nextTag();
        if (n == 3) {
            throw new XmlPullParserException("SubscriptionEnd is empty");
        }
        do {
            String string = elementParser.getNamespace();
            String string2 = elementParser.getName();
            if ("http://schemas.xmlsoap.org/ws/2004/08/eventing".equals(string)) {
                if ("SubscriptionManager".equals(string2)) {
                    subscriptionEndMessage.setSubscriptionManager(this.parseEndpointReference(sOAPHeader.getProtocolInfo().getVersion(), elementParser));
                    continue;
                }
                if ("Status".equals(string2)) {
                    subscriptionEndMessage.setStatus(new URI(elementParser.nextText().trim()));
                    continue;
                }
                if ("Reason".equals(string2)) {
                    subscriptionEndMessage.setReason(elementParser.nextLocalizedString());
                    continue;
                }
                this.parseUnknownElement(subscriptionEndMessage, elementParser, string, string2);
                continue;
            }
            this.parseUnknownElement(subscriptionEndMessage, elementParser, string, string2);
        } while ((n = elementParser.nextTag()) != 3);
        return subscriptionEndMessage;
    }

    public UnsubscribeMessage parseUnsubscribeMessage(SOAPHeader sOAPHeader, ElementParser elementParser, ProtocolData protocolData, ConstantsHelper constantsHelper) throws XmlPullParserException, IOException {
        UnsubscribeMessage unsubscribeMessage = new UnsubscribeMessage(sOAPHeader);
        elementParser.nextGenericElement(unsubscribeMessage);
        return unsubscribeMessage;
    }

    public UnsubscribeResponseMessage parseUnsubscribeResponseMessage(SOAPHeader sOAPHeader, ElementParser elementParser, ProtocolData protocolData, ConstantsHelper constantsHelper) throws XmlPullParserException, IOException {
        return new UnsubscribeResponseMessage(sOAPHeader);
    }

    public GetMessage parseGetMessage(SOAPHeader sOAPHeader, ElementParser elementParser, ProtocolData protocolData, ConstantsHelper constantsHelper) throws XmlPullParserException, IOException {
        return new GetMessage(sOAPHeader);
    }

    public GetResponseMessage parseGetResponseMessage(SOAPHeader sOAPHeader, ElementParser elementParser, ProtocolData protocolData, ConstantsHelper constantsHelper) throws XmlPullParserException, IOException {
        GetResponseMessage getResponseMessage = new GetResponseMessage(sOAPHeader);
        System.out.println(getResponseMessage);
        this.parseUnknownAttributes(getResponseMessage, elementParser);
        int n = elementParser.nextTag();
        if (n == 3) {
            throw new XmlPullParserException("GetResponse is empty");
        }
        do {
            String string = elementParser.getNamespace();
            String string2 = elementParser.getName();
            if ("http://schemas.xmlsoap.org/ws/2004/09/mex".equals(string)) {
                if ("MetadataSection".equals(string2)) {
                    Object object;
                    Object object2;
                    String string3 = elementParser.getAttributeValue(null, "Dialect");
                    if (constantsHelper.getMetadataDialectThisModel().equals(string3)) {
                        getResponseMessage.setThisModel(this.parseThisModelMData(elementParser, constantsHelper));
                        continue;
                    }
                    if (constantsHelper.getMetadataDialectThisDevice().equals(string3)) {
                        getResponseMessage.setThisDevice(this.parseThisDeviceMData(elementParser, constantsHelper));
                        continue;
                    }
                    if (constantsHelper.getMetatdataDialectRelationship().equals(string3)) {
                        try {
                            object2 = this.parseRelationshipMData(elementParser, constantsHelper, sOAPHeader.getCommunicationManagerID());
                            getResponseMessage.addRelationship((RelationshipMData)object2, constantsHelper);
                        }
                        catch (VersionMismatchException versionMismatchException) {
                            Log.printStackTrace(versionMismatchException);
                        }
                        continue;
                    }
                    elementParser.next();
                    object2 = new QName(elementParser.getName(), elementParser.getNamespace());
                    Object object3 = elementParser.chainHandler((QName)object2, false);
                    if (object3 != null) {
                        object = ((ElementHandler)object3).handleElement((QName)object2, elementParser);
                        getResponseMessage.setCustomMData((String)object);
                        continue;
                    }
                    object = CustomizeMDataHandler.getInstance().handleElement((QName)object2, elementParser);
                    getResponseMessage.setCustomMData((String)object);
                    continue;
                }
                this.parseUnknownElement(getResponseMessage, elementParser, string, string2);
                continue;
            }
            this.parseUnknownElement(getResponseMessage, elementParser, string, string2);
        } while ((n = elementParser.nextTag()) != 3);
        return getResponseMessage;
    }

    public GetMetadataMessage parseGetMetadataMessage(SOAPHeader sOAPHeader, ElementParser elementParser, ProtocolData protocolData, ConstantsHelper constantsHelper) throws XmlPullParserException, IOException {
        GetMetadataMessage getMetadataMessage = new GetMetadataMessage(sOAPHeader);
        this.parseUnknownAttributes(getMetadataMessage, elementParser);
        while (elementParser.nextTag() != 3) {
            String string = elementParser.getNamespace();
            String string2 = elementParser.getName();
            if ("http://schemas.xmlsoap.org/ws/2004/09/mex".equals(string)) {
                if ("Dialect".equals(string2)) {
                    getMetadataMessage.setDialect(new URI(elementParser.nextText().trim()));
                    continue;
                }
                if ("Identifier".equals(string2)) {
                    getMetadataMessage.setIdentifier(new URI(elementParser.nextText().trim()));
                    continue;
                }
                this.parseUnknownElement(getMetadataMessage, elementParser, string, string2);
                continue;
            }
            this.parseUnknownElement(getMetadataMessage, elementParser, string, string2);
        }
        return getMetadataMessage;
    }

    public GetMetadataResponseMessage parseGetMetadataResponseMessage(SOAPHeader sOAPHeader, ElementParser elementParser, ProtocolData protocolData, ConstantsHelper constantsHelper) throws XmlPullParserException, IOException {
        GetMetadataResponseMessage getMetadataResponseMessage = new GetMetadataResponseMessage(sOAPHeader);
        this.parseUnknownAttributes(getMetadataResponseMessage, elementParser);
        int n = elementParser.nextTag();
        if (n == 3) {
            throw new XmlPullParserException("GetMetadataResponse is empty");
        }
        do {
            String string = elementParser.getNamespace();
            String string2 = elementParser.getName();
            if ("http://schemas.xmlsoap.org/ws/2004/09/mex".equals(string)) {
                if ("MetadataSection".equals(string2)) {
                    String string3 = elementParser.getAttributeValue(null, "Dialect");
                    if ("http://schemas.xmlsoap.org/wsdl".equals(string3)) {
                        elementParser.nextTag();
                        string = elementParser.getNamespace();
                        string2 = elementParser.getName();
                        if ("http://schemas.xmlsoap.org/ws/2004/09/mex".equals(string)) {
                            if ("MetadataReference".equals(string2)) {
                                getMetadataResponseMessage.addMetadataReference(this.parseEndpointReference(constantsHelper.getDPWSVersion(), elementParser));
                            } else if ("Location".equals(string2)) {
                                getMetadataResponseMessage.addMetadataLocation(new URI(elementParser.nextText().trim()));
                            }
                        } else if ("http://schemas.xmlsoap.org/wsdl/".equals(string) && "definitions".equals(string2)) {
                            getMetadataResponseMessage.addWSDL(WSDL.parse(new ElementParser(elementParser)));
                        }
                        elementParser.nextTag();
                        continue;
                    }
                    if (constantsHelper.getMetatdataDialectRelationship().equals(string3)) {
                        try {
                            RelationshipMData relationshipMData = this.parseRelationshipMData(elementParser, constantsHelper, sOAPHeader.getCommunicationManagerID());
                            getMetadataResponseMessage.addRelationship(relationshipMData, constantsHelper);
                        }
                        catch (VersionMismatchException versionMismatchException) {
                            Log.printStackTrace(versionMismatchException);
                        }
                        continue;
                    }
                    this.parseUnknownElement(getMetadataResponseMessage, elementParser, string, string2);
                    continue;
                }
                this.parseUnknownElement(getMetadataResponseMessage, elementParser, string, string2);
                continue;
            }
            this.parseUnknownElement(getMetadataResponseMessage, elementParser, string, string2);
        } while ((n = elementParser.nextTag()) != 3);
        return getMetadataResponseMessage;
    }

    public FaultMessage parseFaultMessage(SOAPHeader sOAPHeader, ElementParser elementParser, ProtocolData protocolData, ConstantsHelper constantsHelper, String string, OperationDescription operationDescription) throws XmlPullParserException, IOException {
        FaultMessage faultMessage = new FaultMessage(sOAPHeader);
        Fault fault = null;
        if (operationDescription != null) {
            Iterator iterator = operationDescription.getFaults();
            while (iterator.hasNext()) {
                fault = (Fault)iterator.next();
                if (string == null || !string.equals(fault.getAction())) continue;
            }
        }
        elementParser.handleUnknownAttributes(faultMessage);
        int n = elementParser.nextTag();
        if (n == 3) {
            throw new XmlPullParserException("Fault is empty");
        }
        do {
            String string2 = elementParser.getNamespace();
            String string3 = elementParser.getName();
            if ("http://www.w3.org/2003/05/soap-envelope".equals(string2)) {
                if ("Code".equals(string3)) {
                    this.parseCode(faultMessage, elementParser);
                    continue;
                }
                if ("Reason".equals(string3)) {
                    faultMessage.setReason(this.nextReason(elementParser));
                    continue;
                }
                if ("Detail".equals(string3)) {
                    if (elementParser.getEventType() != 2) continue;
                    if (fault != null) {
                        elementParser.nextTag();
                        faultMessage.setDetail(ParameterDefinition.parse(elementParser, fault.getElement(), operationDescription));
                        continue;
                    }
                    elementParser.addUnknownElement(faultMessage, string2, string3);
                    continue;
                }
                elementParser.addUnknownElement(faultMessage, string2, string3);
                continue;
            }
            elementParser.addUnknownElement(faultMessage, string2, string3);
        } while ((n = elementParser.nextTag()) != 3);
        return faultMessage;
    }

    private void parseCode(FaultMessage faultMessage, ElementParser elementParser) throws XmlPullParserException, IOException {
        int n = elementParser.nextTag();
        if (n == 3) {
            throw new XmlPullParserException("Code is empty");
        }
        do {
            String string = elementParser.getNamespace();
            String string2 = elementParser.getName();
            if (!"http://www.w3.org/2003/05/soap-envelope".equals(string)) continue;
            if ("Value".equals(string2)) {
                faultMessage.setCode(elementParser.nextQName());
                continue;
            }
            if (!"Subcode".equals(string2)) continue;
            int n2 = elementParser.nextTag();
            if (n2 == 3) {
                throw new XmlPullParserException("Subcode is empty");
            }
            do {
                String string3 = elementParser.getNamespace();
                String string4 = elementParser.getName();
                if (!"http://www.w3.org/2003/05/soap-envelope".equals(string3)) continue;
                if ("Value".equals(string4)) {
                    faultMessage.setSubcode(elementParser.nextQName());
                    continue;
                }
                if (!"Subcode".equals(string2)) continue;
                int n3 = elementParser.nextTag();
                if (n3 == 3) {
                    throw new XmlPullParserException("Subcode is empty");
                }
                do {
                    String string5 = elementParser.getNamespace();
                    String string6 = elementParser.getName();
                    if (!"http://www.w3.org/2003/05/soap-envelope".equals(string5)) continue;
                    if ("Value".equals(string6)) {
                        faultMessage.setSubsubcode(elementParser.nextQName());
                        continue;
                    }
                    if (!"Subcode".equals(string6)) continue;
                } while ((n3 = elementParser.nextTag()) != 3);
            } while ((n2 = elementParser.nextTag()) != 3);
        } while ((n = elementParser.nextTag()) != 3);
    }

    private DataStructure nextReason(ElementParser elementParser) throws XmlPullParserException, IOException {
        ArrayList arrayList = new ArrayList();
        int n = elementParser.nextTag();
        if (n == 3) {
            throw new XmlPullParserException("Reason is empty");
        }
        do {
            String string = elementParser.getNamespace();
            String string2 = elementParser.getName();
            if (!"http://www.w3.org/2003/05/soap-envelope".equals(string) || !"Text".equals(string2)) continue;
            ((List)arrayList).add(elementParser.nextLocalizedString());
        } while ((n = elementParser.nextTag()) != 3);
        return arrayList;
    }

    private SOAPHeader parseSOAPHeader(ElementParser elementParser, ConstantsHelper constantsHelper, ProtocolData protocolData) throws XmlPullParserException, IOException, VersionMismatchException {
        String string = protocolData.getCommunicationManagerId();
        SOAPHeader sOAPHeader = new SOAPHeader(string);
        elementParser.handleUnknownAttributes(sOAPHeader);
        int n = elementParser.nextTag();
        if (n == 3) {
            throw new XmlPullParserException("SOAP Header is empty");
        }
        do {
            CommunicationManager communicationManager = DPWSFramework.getCommunicationManager(string);
            String string2 = elementParser.getNamespace();
            String string3 = elementParser.getName();
            if (communicationManager.supportsAddressingNamespace(sOAPHeader, string2, protocolData)) {
                this.parseAddressingHeader(elementParser, sOAPHeader, string3, string2);
                continue;
            }
            if ("http://schemas.xmlsoap.org/ws/2005/04/discovery".equals(string2)) {
                if ("Security".equals(string3) && DPWSFramework.hasModule(64)) {
                    elementParser.nextTag();
                    for (int i = elementParser.getAttributeCount() - 1; i >= 0; --i) {
                        if (!elementParser.getAttributeName(i).equals("Sig")) continue;
                        sOAPHeader.setSignature(DPWSFramework.getSecurityManager().decode(elementParser.getAttributeValue(i)));
                    }
                    elementParser.nextTag();
                    elementParser.nextTag();
                    continue;
                }
                if ("AppSequence".equals(string3)) {
                    sOAPHeader.setAppSequence(AppSequence.parse(elementParser, constantsHelper));
                    continue;
                }
                this.parseUnknownElement(sOAPHeader, elementParser, string2, string3);
                continue;
            }
            if ("http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01".equals(string2)) {
                if ("AppSequence".equals(string3)) {
                    sOAPHeader.setAppSequence(AppSequence.parse(elementParser, constantsHelper));
                    continue;
                }
                this.parseUnknownElement(sOAPHeader, elementParser, string2, string3);
                continue;
            }
            if ("http://schemas.xmlsoap.org/ws/2004/08/eventing".equals(string2)) {
                if ("Identifier".equals(string3)) {
                    sOAPHeader.setWseIdentifier(elementParser.nextText().trim());
                    continue;
                }
                this.parseUnknownElement(sOAPHeader, elementParser, string2, string3);
                continue;
            }
            this.parseUnknownElement(sOAPHeader, elementParser, string2, string3);
        } while ((n = elementParser.nextTag()) != 3);
        if (Log.isDebug()) {
            Log.debug("<I> Incoming " + sOAPHeader.getProtocolInfo().getDisplayName() + " Message, Action: " + sOAPHeader.getAction() + ", Id: " + sOAPHeader.getMessageId(), 4);
        }
        return sOAPHeader;
    }

    private void parseAddressingHeader(ElementParser elementParser, SOAPHeader sOAPHeader, String string, String string2) throws XmlPullParserException, IOException {
        if ("Action".equals(string)) {
            sOAPHeader.setAction(AttributedURI.parse(elementParser));
        } else if ("MessageID".equals(string)) {
            sOAPHeader.setMessageId(AttributedURI.parse(elementParser));
        } else if ("RelatesTo".equals(string)) {
            sOAPHeader.setRelatesTo(AttributedURI.parse(elementParser));
        } else if ("ReplyTo".equals(string)) {
            sOAPHeader.setReplyTo(this.parseEndpointReference(sOAPHeader.getProtocolInfo().getVersion(), elementParser));
        } else if ("To".equals(string)) {
            sOAPHeader.setTo(AttributedURI.parse(elementParser));
        } else {
            this.parseUnknownElement(sOAPHeader, elementParser, string2, string);
        }
    }

    private RelationshipMData parseRelationshipMData(ElementParser elementParser, ConstantsHelper constantsHelper, String string) throws XmlPullParserException, IOException, VersionMismatchException {
        elementParser.nextTag();
        String string2 = elementParser.getAttributeValue(null, constantsHelper.getDPWSAttributeRelationshipType());
        if (constantsHelper.getMetadataRelationshipHostingType().equals(string2)) {
            RelationshipMData relationshipMData = new RelationshipMData();
            relationshipMData.setType(new URI(constantsHelper.getMetadataRelationshipHostingType()));
            int n = elementParser.nextTag();
            if (n == 3) {
                throw new XmlPullParserException("Relationship is empty");
            }
            ArrayList arrayList = null;
            do {
                String string3 = elementParser.getNamespace();
                String string4 = elementParser.getName();
                if (constantsHelper.getDPWSNamespace().equals(string3)) {
                    if (constantsHelper.getDPWSElementRelationshipHost().equals(string4)) {
                        relationshipMData.setHost(this.parseHostMData(elementParser, constantsHelper, string));
                        continue;
                    }
                    if (constantsHelper.getDPWSElementRelationshipHosted().equals(string4)) {
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                        }
                        ((DataStructure)arrayList).add(this.parseHostedMData(elementParser, constantsHelper, string));
                        continue;
                    }
                    this.parseUnknownElement(relationshipMData, elementParser, string3, string4);
                    continue;
                }
                this.parseUnknownElement(relationshipMData, elementParser, string3, string4);
            } while ((n = elementParser.nextTag()) != 3);
            if (arrayList != null) {
                relationshipMData.setHosted(arrayList);
            }
            elementParser.nextTag();
            return relationshipMData;
        }
        throw new VersionMismatchException("Wrong Type Attribute", 2);
    }

    private void parse(DiscoveryData discoveryData, ElementParser elementParser, String string, ConstantsHelper constantsHelper, String string2) throws XmlPullParserException, IOException {
        this.parseUnknownAttributes(discoveryData, elementParser);
        int n = elementParser.nextTag();
        if (n == 3) {
            throw new XmlPullParserException(string + " is empty");
        }
        do {
            String string3 = elementParser.getNamespace();
            String string4 = elementParser.getName();
            if (constantsHelper.getWSANamespace().equals(string3)) {
                if ("EndpointReference".equals(string4)) {
                    discoveryData.setEndpointReference(this.parseEndpointReference(constantsHelper.getDPWSVersion(), elementParser));
                    continue;
                }
                this.parseUnknownElement(discoveryData, elementParser, string3, string4);
                continue;
            }
            if (constantsHelper.getWSDNamespace().equals(string3)) {
                if ("Types".equals(string4)) {
                    discoveryData.setTypes(this.parseQNameSet(elementParser));
                    continue;
                }
                if ("Scopes".equals(string4)) {
                    discoveryData.setScopes(this.parseScopeSet(elementParser));
                    continue;
                }
                if ("XAddrs".equals(string4)) {
                    discoveryData.setXAddresInfoSet(this.parseXAddressInfoSet(elementParser, string2));
                    continue;
                }
                if ("MetadataVersion".equals(string4)) {
                    String string5 = elementParser.nextText().trim();
                    long l = 0L;
                    try {
                        l = Long.parseLong(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new XmlPullParserException(string + "/MetadataVersion is not a number: " + string5);
                    }
                    discoveryData.setMetadataVersion(l);
                    continue;
                }
                this.parseUnknownElement(discoveryData, elementParser, string3, string4);
                continue;
            }
            this.parseUnknownElement(discoveryData, elementParser, string3, string4);
        } while ((n = elementParser.nextTag()) != 3);
    }

    private QNameSet parseQNameSet(ElementParser elementParser) throws XmlPullParserException, IOException {
        int n;
        QNameSet qNameSet = new QNameSet();
        String string = elementParser.nextText();
        int n2 = n = -1;
        while ((n = ElementParser.nextNonWhiteSpace(string, n)) != -1) {
            n2 = ElementParser.nextWhiteSpace(string, n);
            if (n2 == -1) {
                n2 = string.length();
            }
            String string2 = string.substring(n, n2);
            qNameSet.add(elementParser.createQName(string2));
            n = n2;
            if (n != -1) continue;
        }
        return qNameSet;
    }

    private ScopeSet parseScopeSet(ElementParser elementParser) throws XmlPullParserException, IOException {
        int n;
        ScopeSet scopeSet = new ScopeSet();
        String string = elementParser.nextText();
        int n2 = n = -1;
        while ((n = ElementParser.nextNonWhiteSpace(string, n)) != -1) {
            n2 = ElementParser.nextWhiteSpace(string, n);
            if (n2 == -1) {
                n2 = string.length();
            }
            String string2 = string.substring(n, n2);
            scopeSet.addScope(string2);
            n = n2;
            if (n != -1) continue;
        }
        return scopeSet;
    }

    private ProbeScopeSet parseNextProbeScopeSet(ElementParser elementParser) throws XmlPullParserException, IOException {
        ProbeScopeSet probeScopeSet = new ProbeScopeSet();
        int n = elementParser.getAttributeCount();
        String string = "http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/rfc3986";
        for (int i = 0; i < n; ++i) {
            String string2 = elementParser.getAttributeNamespace(i);
            String string3 = elementParser.getAttributeName(i);
            String string4 = elementParser.getAttributeValue(i);
            if ("".equals(string2) && "MatchBy".equals(string3)) {
                string = string4;
                continue;
            }
            probeScopeSet.addUnknownAttribute(new QName(string3, string2), string4);
        }
        probeScopeSet.setMatchBy(string);
        probeScopeSet.addAll(this.parseScopeSet(elementParser));
        return probeScopeSet;
    }

    private URISet parseURISet(ElementParser elementParser) throws XmlPullParserException, IOException {
        int n;
        URISet uRISet = new URISet();
        String string = elementParser.nextText();
        int n2 = n = -1;
        while ((n = ElementParser.nextNonWhiteSpace(string, n)) != -1) {
            n2 = ElementParser.nextWhiteSpace(string, n);
            if (n2 == -1) {
                n2 = string.length();
            }
            String string2 = string.substring(n, n2);
            uRISet.add(new URI(string2));
            n = n2;
            if (n != -1) continue;
        }
        return uRISet;
    }

    private XAddressInfoSet parseXAddressInfoSet(ElementParser elementParser, String string) throws XmlPullParserException, IOException {
        int n;
        XAddressInfoSet xAddressInfoSet = new XAddressInfoSet();
        String string2 = elementParser.nextText();
        int n2 = n = -1;
        while ((n = ElementParser.nextNonWhiteSpace(string2, n)) != -1) {
            n2 = ElementParser.nextWhiteSpace(string2, n);
            if (n2 == -1) {
                n2 = string2.length();
            }
            String string3 = string2.substring(n, n2);
            xAddressInfoSet.add(new XAddressInfo(new URI(string3), string));
            n = n2;
            if (n != -1) continue;
        }
        return xAddressInfoSet;
    }

    private Delivery parseDelivery(ElementParser elementParser, ConstantsHelper constantsHelper, String string) throws XmlPullParserException, IOException {
        String string2;
        Delivery delivery = new Delivery();
        int n = elementParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            string2 = elementParser.getAttributeNamespace(i);
            String string3 = elementParser.getAttributeName(i);
            String string4 = elementParser.getAttributeValue(i);
            if ("".equals(string2) && "Mode".equals(string3)) {
                delivery.setMode(new URI(string4));
                continue;
            }
            delivery.addUnknownAttribute(new QName(string3, string2), string4);
        }
        while (elementParser.nextTag() != 3) {
            String string5 = elementParser.getNamespace();
            string2 = elementParser.getName();
            if ("http://schemas.xmlsoap.org/ws/2004/08/eventing".equals(string5)) {
                if ("NotifyTo".equals(string2)) {
                    delivery.setNotifyTo(this.parseEndpointReference(constantsHelper.getDPWSVersion(), elementParser));
                    continue;
                }
                this.parseUnknownElement(delivery, elementParser, string5, string2);
                continue;
            }
            this.parseUnknownElement(delivery, elementParser, string5, string2);
        }
        return delivery;
    }

    private Filter parseFilter(ElementParser elementParser, String string) throws XmlPullParserException, IOException {
        Filter filter = new Filter();
        int n = elementParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String string2 = elementParser.getAttributeNamespace(i);
            String string3 = elementParser.getAttributeName(i);
            String string4 = elementParser.getAttributeValue(i);
            if ("".equals(string2) && "Dialect".equals(string3)) {
                filter.setDialect(new URI(string4));
                continue;
            }
            filter.addUnknownAttribute(new QName(string3, string2), string4);
        }
        filter.setActions(this.parseURISet(elementParser));
        return filter;
    }

    private ThisModelMData parseThisModelMData(ElementParser elementParser, ConstantsHelper constantsHelper) throws XmlPullParserException, IOException {
        ThisModelMData thisModelMData = new ThisModelMData();
        elementParser.nextTag();
        this.parseUnknownAttributes(thisModelMData, elementParser);
        int n = elementParser.nextTag();
        if (n == 3) {
            throw new XmlPullParserException("ThisModel is empty");
        }
        do {
            String string = elementParser.getNamespace();
            String string2 = elementParser.getName();
            if (constantsHelper.getDPWSNamespace().equals(string)) {
                if (constantsHelper.getDPWSElementManufacturer().equals(string2)) {
                    thisModelMData.addManufacturerName(elementParser.nextLocalizedString());
                    continue;
                }
                if (constantsHelper.getDPWSElementManufacturerURL().equals(string2)) {
                    thisModelMData.setManufacturerUrl(new URI(elementParser.nextText().trim()));
                    continue;
                }
                if (constantsHelper.getDPWSElementModelName().equals(string2)) {
                    thisModelMData.addModelName(elementParser.nextLocalizedString());
                    continue;
                }
                if (constantsHelper.getDPWSElementModelNumber().equals(string2)) {
                    thisModelMData.setModelNumber(elementParser.nextText().trim());
                    continue;
                }
                if (constantsHelper.getDPWSElementModelURL().equals(string2)) {
                    thisModelMData.setModelUrl(new URI(elementParser.nextText().trim()));
                    continue;
                }
                if (constantsHelper.getDPWSElementPresentationURL().equals(string2)) {
                    thisModelMData.setPresentationUrl(new URI(elementParser.nextText().trim()));
                    continue;
                }
                this.parseUnknownElement(thisModelMData, elementParser, string, string2);
                continue;
            }
            this.parseUnknownElement(thisModelMData, elementParser, string, string2);
        } while ((n = elementParser.nextTag()) != 3);
        elementParser.nextTag();
        return thisModelMData;
    }

    private ThisDeviceMData parseThisDeviceMData(ElementParser elementParser, ConstantsHelper constantsHelper) throws XmlPullParserException, IOException {
        ThisDeviceMData thisDeviceMData = new ThisDeviceMData();
        elementParser.nextTag();
        this.parseUnknownAttributes(thisDeviceMData, elementParser);
        int n = elementParser.nextTag();
        if (n == 3) {
            throw new XmlPullParserException("ThisDevice is empty");
        }
        do {
            String string = elementParser.getNamespace();
            String string2 = elementParser.getName();
            if (constantsHelper.getDPWSNamespace().equals(string)) {
                if (constantsHelper.getDPWSElementFriendlyName().equals(string2)) {
                    thisDeviceMData.addFriendlyName(elementParser.nextLocalizedString());
                    continue;
                }
                if (constantsHelper.getDPWSElementFirmwareVersion().equals(string2)) {
                    thisDeviceMData.setFirmwareVersion(elementParser.nextText().trim());
                    continue;
                }
                if (constantsHelper.getDPWSElementSerialnumber().equals(string2)) {
                    thisDeviceMData.setSerialNumber(elementParser.nextText().trim());
                    continue;
                }
                this.parseUnknownElement(thisDeviceMData, elementParser, string, string2);
                continue;
            }
            this.parseUnknownElement(thisDeviceMData, elementParser, string, string2);
        } while ((n = elementParser.nextTag()) != 3);
        elementParser.nextTag();
        return thisDeviceMData;
    }

    private HostMData parseHostMData(ElementParser elementParser, ConstantsHelper constantsHelper, String string) throws XmlPullParserException, IOException {
        HostMData hostMData = new HostMData();
        this.parseUnknownAttributes(hostMData, elementParser);
        int n = elementParser.nextTag();
        if (n == 3) {
            throw new XmlPullParserException("Host is empty");
        }
        do {
            String string2 = elementParser.getNamespace();
            String string3 = elementParser.getName();
            if (constantsHelper.getWSANamespace().equals(string2)) {
                if ("EndpointReference".equals(string3)) {
                    hostMData.setEndpointReference(this.parseEndpointReference(constantsHelper.getDPWSVersion(), elementParser));
                    continue;
                }
                this.parseUnknownElement(hostMData, elementParser, string2, string3);
                continue;
            }
            if (constantsHelper.getDPWSNamespace().equals(string2)) {
                if (constantsHelper.getDPWSElementTypes().equals(string3)) {
                    hostMData.setTypes(this.parseQNameSet(elementParser));
                    continue;
                }
                this.parseUnknownElement(hostMData, elementParser, string2, string3);
                continue;
            }
            this.parseUnknownElement(hostMData, elementParser, string2, string3);
        } while ((n = elementParser.nextTag()) != 3);
        return hostMData;
    }

    private HostedMData parseHostedMData(ElementParser elementParser, ConstantsHelper constantsHelper, String string) throws XmlPullParserException, IOException {
        HostedMData hostedMData = new HostedMData();
        this.parseUnknownAttributes(hostedMData, elementParser);
        int n = elementParser.nextTag();
        if (n == 3) {
            throw new XmlPullParserException("Hosted is empty");
        }
        EprInfoSet eprInfoSet = null;
        do {
            String string2 = elementParser.getNamespace();
            String string3 = elementParser.getName();
            if (constantsHelper.getWSANamespace().equals(string2)) {
                if ("EndpointReference".equals(string3)) {
                    if (eprInfoSet == null) {
                        eprInfoSet = new EprInfoSet();
                    }
                    eprInfoSet.add(this.parseEprInfo(constantsHelper.getDPWSVersion(), string, elementParser));
                    continue;
                }
                this.parseUnknownElement(hostedMData, elementParser, string2, string3);
                continue;
            }
            if (constantsHelper.getDPWSNamespace().equals(string2)) {
                if (constantsHelper.getDPWSElementTypes().equals(string3)) {
                    hostedMData.setTypes(this.parseQNameSet(elementParser));
                    continue;
                }
                if (constantsHelper.getDPWSElementServiceId().equals(string3)) {
                    hostedMData.setServiceId(new URI(elementParser.nextText().trim()));
                    continue;
                }
                this.parseUnknownElement(hostedMData, elementParser, string2, string3);
                continue;
            }
            this.parseUnknownElement(hostedMData, elementParser, string2, string3);
        } while ((n = elementParser.nextTag()) != 3);
        if (eprInfoSet != null) {
            hostedMData.setEprInfoSet(eprInfoSet);
        }
        return hostedMData;
    }

    private ReferenceParametersMData parseReferenceParametersMData(ElementParser elementParser) throws XmlPullParserException, IOException {
        ReferenceParametersMData referenceParametersMData = new ReferenceParametersMData();
        this.parseUnknownAttributes(referenceParametersMData, elementParser);
        int n = elementParser.nextTag();
        int n2 = elementParser.getDepth();
        String string = elementParser.getNamespace();
        String string2 = elementParser.getName();
        if (n == 3 && ("http://www.w3.org/2005/08/addressing".equals(string) || "http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(string)) && "ReferenceParameters".equals(string2)) {
            return referenceParametersMData;
        }
        ElementParser elementParser2 = new ElementParser(elementParser);
        ReferenceParametersMData.ReferenceParameter referenceParameter = null;
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            switch (n) {
                case 2: {
                    string = elementParser2.getNamespace();
                    string2 = elementParser2.getName();
                    if (bl) {
                        if ("http://schemas.xmlsoap.org/ws/2004/08/eventing".equals(string) && "Identifier".equals(string2)) {
                            referenceParametersMData.setWseIdentifier(elementParser2.nextText().trim());
                            break;
                        }
                        QName qName = new QName(string2, string);
                        Object object = elementParser.chainHandler(qName, false);
                        if (object != null) {
                            referenceParametersMData.addUnknownElement(qName, object);
                            break;
                        }
                        referenceParameter = new ReferenceParametersMData.ReferenceParameter(string, string2);
                        referenceParametersMData.add(referenceParameter);
                    } else {
                        stringBuffer.append('<');
                        referenceParameter.appendChunk(stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        referenceParameter.appendChunk(string);
                        stringBuffer.append(':').append(string2);
                    }
                    int n3 = elementParser2.getAttributeCount();
                    for (int i = 0; i < n3; ++i) {
                        String string3;
                        stringBuffer.append(' ');
                        String string4 = elementParser2.getAttributePrefix(i);
                        String string5 = elementParser2.getAttributeName(i);
                        if (string4 == null) {
                            if (("http://www.w3.org/2005/08/addressing".equals(string) || "http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(string)) && "IsReferenceParameter".equals(string5)) {
                                continue;
                            }
                        } else {
                            string3 = elementParser2.getAttributeNamespace(i);
                            if (("http://www.w3.org/2005/08/addressing".equals(string3) || "http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(string3)) && "IsReferenceParameter".equals(string5)) continue;
                            referenceParameter.appendChunk(stringBuffer.toString());
                            referenceParameter.appendChunk(string3);
                            stringBuffer = new StringBuffer();
                            stringBuffer.append(':');
                        }
                        string3 = elementParser2.getAttributeValue(i);
                        stringBuffer.append(string5).append("=\"").append(string3).append('\"');
                    }
                    stringBuffer.append('>');
                    bl = false;
                    break;
                }
                case 4: {
                    stringBuffer.append(elementParser2.getText().trim());
                    break;
                }
                case 3: {
                    stringBuffer.append("</");
                    referenceParameter.appendChunk(stringBuffer.toString());
                    referenceParameter.appendChunk(elementParser2.getNamespace());
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(':').append(elementParser2.getName()).append('>');
                }
            }
            if ((n = elementParser2.next()) != 1) continue;
            n = elementParser.nextTag();
            if (elementParser.getDepth() != n2) break;
            elementParser2 = new ElementParser(elementParser);
            referenceParameter.appendChunk(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            bl = true;
        }
        if (referenceParameter != null) {
            referenceParameter.appendChunk(stringBuffer.toString());
        }
        return referenceParametersMData;
    }

    private EndpointReference parseEndpointReference(ElementParser elementParser) throws XmlPullParserException, IOException {
        Object object;
        int n = elementParser.getAttributeCount();
        HashMap hashMap = null;
        if (n > 0) {
            hashMap = new HashMap();
            for (int i = 0; i < n; ++i) {
                hashMap.put(new QName(elementParser.getAttributeName(i), elementParser.getAttributeNamespace(i)), elementParser.getAttributeValue(i));
            }
        }
        AttributedURI attributedURI = null;
        ReferenceParametersMData referenceParametersMData = null;
        MetadataMData metadataMData = null;
        HashMap hashMap2 = null;
        while (elementParser.nextTag() != 3) {
            DataStructure dataStructure;
            object = elementParser.getNamespace();
            String string = elementParser.getName();
            if (!"http://www.w3.org/2005/08/addressing".equals(object)) continue;
            if ("Address".equals(string)) {
                attributedURI = AttributedURI.parse(elementParser);
                continue;
            }
            if ("ReferenceParameters".equals(string)) {
                referenceParametersMData = this.parseReferenceParametersMData(new ElementParser(elementParser));
                continue;
            }
            if ("Metadata".equals(string)) {
                metadataMData = new MetadataMData();
                elementParser.nextGenericElement(metadataMData);
                continue;
            }
            QName qName = new QName(string, (String)object);
            Object object2 = elementParser.chainHandler(qName);
            if (object2 == null) continue;
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
            }
            if ((dataStructure = (DataStructure)hashMap2.get(qName)) == null) {
                dataStructure = new ArrayList();
                hashMap2.put(qName, dataStructure);
            }
            dataStructure.add(object2);
        }
        object = new EndpointReference(attributedURI, referenceParametersMData, metadataMData);
        if (hashMap != null) {
            ((UnknownDataContainer)object).setUnknownAttributes(hashMap);
        }
        if (hashMap2 != null) {
            ((UnknownDataContainer)object).setUnknownElements(hashMap2);
        }
        return object;
    }

    private EndpointReference parseEndpointReference2004(ElementParser elementParser) throws XmlPullParserException, IOException {
        Object object;
        int n = elementParser.getAttributeCount();
        HashMap hashMap = null;
        if (n > 0) {
            hashMap = new HashMap();
            for (int i = 0; i < n; ++i) {
                hashMap.put(new QName(elementParser.getAttributeName(i), elementParser.getAttributeNamespace(i)), elementParser.getAttributeValue(i));
            }
        }
        AttributedURI attributedURI = null;
        ReferenceParametersMData referenceParametersMData = null;
        ReferenceParametersMData referenceParametersMData2 = null;
        HashMap hashMap2 = null;
        QName qName = null;
        QName qName2 = null;
        String string = null;
        while (elementParser.nextTag() != 3) {
            DataStructure dataStructure;
            Object object2;
            Object object3;
            object = elementParser.getNamespace();
            String string2 = elementParser.getName();
            if (!"http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(object)) continue;
            if ("Address".equals(string2)) {
                attributedURI = AttributedURI.parse(elementParser);
                continue;
            }
            if ("ReferenceProperties".equals(string2)) {
                referenceParametersMData = this.parseReferenceParametersMData(elementParser);
                continue;
            }
            if ("ReferenceParameters".equals(string2)) {
                referenceParametersMData2 = this.parseReferenceParametersMData(elementParser);
                continue;
            }
            if ("PortType".equals(string2)) {
                qName = elementParser.nextQName();
                continue;
            }
            if ("ServiceName".equals(string2)) {
                object3 = this.parseServiceName(elementParser);
                string = (String)((ArrayList)object3).get(0);
                qName2 = (QName)((ArrayList)object3).get(1);
                continue;
            }
            if ("Policy".equals(string2) || (object2 = elementParser.chainHandler((QName)(object3 = new QName(string2, (String)object)))) == null) continue;
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
            }
            if ((dataStructure = (DataStructure)hashMap2.get(object3)) == null) {
                dataStructure = new ArrayList();
                hashMap2.put(object3, dataStructure);
            }
            dataStructure.add(object2);
        }
        object = new EndpointReference2004(attributedURI, referenceParametersMData2, referenceParametersMData, qName, qName2, string);
        if (hashMap != null) {
            ((UnknownDataContainer)object).setUnknownAttributes(hashMap);
        }
        if (hashMap2 != null) {
            ((UnknownDataContainer)object).setUnknownElements(hashMap2);
        }
        return object;
    }

    private ArrayList parseServiceName(ElementParser elementParser) throws XmlPullParserException, IOException {
        Object object;
        ArrayList arrayList = new ArrayList();
        ElementParser elementParser2 = new ElementParser(elementParser);
        int n = elementParser2.getAttributeCount();
        if (n > 0) {
            object = elementParser2.getAttributeValue(0);
            arrayList.add(object);
        }
        object = elementParser2.nextQName();
        arrayList.add(object);
        return arrayList;
    }

    private EprInfo parseEprInfo(int n, String string, ElementParser elementParser) throws XmlPullParserException, IOException {
        EndpointReference endpointReference = this.parseEndpointReference(n, elementParser);
        return new EprInfo(endpointReference, string);
    }

    private EndpointReference parseEndpointReference(int n, ElementParser elementParser) throws XmlPullParserException, IOException {
        switch (n) {
            case 0: {
                return this.parseEndpointReference(elementParser);
            }
            case 1: {
                return this.parseEndpointReference2004(elementParser);
            }
        }
        throw new IllegalArgumentException("Unsupported DPWS Version");
    }

    private void parseUnknownElement(UnknownDataContainer unknownDataContainer, ElementParser elementParser, String string, String string2) throws XmlPullParserException, IOException {
        QName qName = new QName(string2, string);
        Object object = elementParser.chainHandler(qName);
        if (object != null) {
            unknownDataContainer.addUnknownElement(qName, object);
        }
    }

    private void parseUnknownAttributes(UnknownDataContainer unknownDataContainer, ElementParser elementParser) {
        int n = elementParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            unknownDataContainer.addUnknownAttribute(new QName(elementParser.getAttributeName(i), elementParser.getAttributeNamespace(i)), elementParser.getAttributeValue(i));
        }
    }
}

