/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.soap.generator;

import java.io.IOException;
import java.io.InputStream;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.CommunicationUtil;
import org.ws4d.java.communication.DPWSCommunicationManager;
import org.ws4d.java.communication.DPWSProtocolData;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.VersionMismatchException;
import org.ws4d.java.communication.monitor.MonitorStreamFactory;
import org.ws4d.java.communication.monitor.MonitoringContext;
import org.ws4d.java.communication.protocol.soap.generator.DefaultMessageDiscarder;
import org.ws4d.java.communication.protocol.soap.generator.DefaultMessageParser;
import org.ws4d.java.communication.protocol.soap.generator.MessageParser;
import org.ws4d.java.communication.protocol.soap.generator.MessageReceiver;
import org.ws4d.java.communication.protocol.soap.generator.MissingElementException;
import org.ws4d.java.communication.protocol.soap.generator.SOAP2MessageGenerator;
import org.ws4d.java.communication.protocol.soap.generator.UnexpectedElementException;
import org.ws4d.java.communication.protocol.soap.generator.UnexpectedMessageException;
import org.ws4d.java.constants.ConstantsHelper;
import org.ws4d.java.io.xml.ElementParser;
import org.ws4d.java.io.xml.XmlPullParserSupport;
import org.ws4d.java.message.FaultMessage;
import org.ws4d.java.message.InvokeMessage;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.SOAPHeader;
import org.ws4d.java.message.discovery.ByeMessage;
import org.ws4d.java.message.discovery.HelloMessage;
import org.ws4d.java.message.discovery.ProbeMatchesMessage;
import org.ws4d.java.message.discovery.ProbeMessage;
import org.ws4d.java.message.discovery.ResolveMatchesMessage;
import org.ws4d.java.message.discovery.ResolveMessage;
import org.ws4d.java.message.eventing.GetStatusMessage;
import org.ws4d.java.message.eventing.GetStatusResponseMessage;
import org.ws4d.java.message.eventing.RenewMessage;
import org.ws4d.java.message.eventing.RenewResponseMessage;
import org.ws4d.java.message.eventing.SubscribeMessage;
import org.ws4d.java.message.eventing.SubscribeResponseMessage;
import org.ws4d.java.message.eventing.SubscriptionEndMessage;
import org.ws4d.java.message.eventing.UnsubscribeMessage;
import org.ws4d.java.message.eventing.UnsubscribeResponseMessage;
import org.ws4d.java.message.metadata.GetMessage;
import org.ws4d.java.message.metadata.GetMetadataMessage;
import org.ws4d.java.message.metadata.GetMetadataResponseMessage;
import org.ws4d.java.message.metadata.GetResponseMessage;
import org.ws4d.java.schema.Element;
import org.ws4d.java.service.OperationDescription;
import org.ws4d.java.service.parameter.ParameterDefinition;
import org.ws4d.java.service.parameter.ParameterValue;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.List;
import org.ws4d.java.types.AttributedURI;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.Log;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class DefaultSOAP2MessageGenerator
implements SOAP2MessageGenerator {
    protected static final DefaultMessageDiscarder DEFAULT_DISCARDER;
    protected static ConstantsHelper helper;
    private static DefaultMessageDiscarder defaultDiscarder;
    private final XmlPullParser parser;
    private MessageParser msgParser = new DefaultMessageParser();

    public DefaultSOAP2MessageGenerator() {
        XmlPullParser xmlPullParser = null;
        try {
            xmlPullParser = XmlPullParserSupport.getFactory().newPullParser();
        }
        catch (XmlPullParserException xmlPullParserException) {
            Log.error("Could not create XmlPullParser: " + xmlPullParserException);
            xmlPullParserException.printStackTrace();
            throw new RuntimeException("Could not create XmlPullParser: " + xmlPullParserException);
        }
        this.parser = xmlPullParser;
    }

    public void deliverMessage(InputStream inputStream, MessageReceiver messageReceiver, ProtocolData protocolData) {
        this.deliverMessage(inputStream, messageReceiver, protocolData, DefaultSOAP2MessageGenerator.getDefaultMessageDiscarder());
    }

    public static synchronized DefaultMessageDiscarder getDefaultMessageDiscarder() {
        return defaultDiscarder;
    }

    public static synchronized void setMessageDiscarder(DefaultMessageDiscarder defaultMessageDiscarder) {
        defaultDiscarder = defaultMessageDiscarder == null ? DEFAULT_DISCARDER : defaultMessageDiscarder;
    }

    protected void deliverBody(SOAPHeader sOAPHeader, ElementParser elementParser, MessageReceiver messageReceiver, ProtocolData protocolData) throws XmlPullParserException, IOException, UnexpectedMessageException, MissingElementException, UnexpectedElementException, VersionMismatchException {
        if (sOAPHeader == null) {
            throw new MissingElementException("http://www.w3.org/2003/05/soap-envelope:Header");
        }
        AttributedURI attributedURI = sOAPHeader.getAction();
        if (attributedURI == null) {
            throw new MissingElementException(helper.getWSANamespace() + ":" + "Action");
        }
        String string = attributedURI.toString();
        protocolData.setProtocolInfo(sOAPHeader.getProtocolInfo());
        int n = elementParser.next();
        if (n == 4) {
            elementParser.getText();
            n = elementParser.next();
        }
        if (n == 2 || n == 3) {
            CommunicationManager communicationManager = DPWSFramework.getCommunicationManager(protocolData.getCommunicationManagerId());
            CommunicationUtil communicationUtil = communicationManager.getCommunicationUtil();
            helper = communicationUtil.getHelper(sOAPHeader.getProtocolInfo().getVersion());
            if (this.handleMessage(elementParser, string, sOAPHeader, messageReceiver, protocolData)) {
                return;
            }
            String string2 = elementParser.getName();
            String string3 = elementParser.getNamespace();
            if ("http://www.w3.org/2003/05/soap-envelope".equals(string3) && "Fault".equals(string2)) {
                OperationDescription operationDescription = messageReceiver.getOperation(string);
                FaultMessage faultMessage = this.msgParser.parseFaultMessage(sOAPHeader, elementParser, protocolData, helper, string, operationDescription);
                messageReceiver.receive(faultMessage, protocolData);
                return;
            }
            InvokeMessage invokeMessage = new InvokeMessage(sOAPHeader);
            AttributedURI attributedURI2 = sOAPHeader.getRelatesTo();
            ArrayList arrayList = new ArrayList();
            OperationDescription operationDescription = messageReceiver.getOperation(invokeMessage.getAction().toString());
            while (elementParser.getEventType() != 3) {
                int n2 = operationDescription.getType();
                Element element = null;
                if (attributedURI2 == null && n2 == 3 || attributedURI2 != null && n2 == 2 || attributedURI2 != null && n2 == 1 || attributedURI2 == null && n2 == 4) {
                    element = operationDescription.getOutput();
                } else if (attributedURI2 != null && n2 == 3 || attributedURI2 == null && n2 == 2 || attributedURI2 == null && n2 == 1 || attributedURI2 != null && n2 == 4) {
                    element = operationDescription.getInput();
                }
                ((List)arrayList).add(ParameterDefinition.parse(elementParser, element, operationDescription));
                elementParser.nextTag();
            }
            switch (arrayList.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    ParameterValue parameterValue = (ParameterValue)((List)arrayList).get(0);
                    invokeMessage.setContent(parameterValue);
                    break;
                }
                default: {
                    throw new UnexpectedElementException("too much message parts: " + arrayList.size() + "; next part=" + ((List)arrayList).get(1).toString());
                }
            }
            messageReceiver.receive(invokeMessage, protocolData);
        }
    }

    protected boolean handleMessage(ElementParser elementParser, String string, SOAPHeader sOAPHeader, MessageReceiver messageReceiver, ProtocolData protocolData) throws XmlPullParserException, IOException, VersionMismatchException {
        if (helper.getWSDActionHello().equals(string)) {
            HelloMessage helloMessage = this.msgParser.parseHelloMessage(sOAPHeader, elementParser, protocolData, helper);
            messageReceiver.receive(helloMessage, protocolData);
        } else if (helper.getWSDActionBye().equals(string)) {
            ByeMessage byeMessage = this.msgParser.parseByeMessage(sOAPHeader, elementParser, protocolData, helper);
            messageReceiver.receive(byeMessage, protocolData);
        } else if (helper.getWSDActionProbe().equals(string)) {
            ProbeMessage probeMessage = this.msgParser.parseProbeMessage(sOAPHeader, elementParser, protocolData, helper);
            messageReceiver.receive(probeMessage, protocolData);
        } else if (helper.getWSDActionProbeMatches().equals(string)) {
            ProbeMatchesMessage probeMatchesMessage = this.msgParser.parseProbeMatchesMessage(sOAPHeader, elementParser, protocolData, helper);
            messageReceiver.receive(probeMatchesMessage, protocolData);
        } else if (helper.getWSDActionResolve().equals(string)) {
            ResolveMessage resolveMessage = this.msgParser.parseResolveMessage(sOAPHeader, elementParser, protocolData, helper);
            messageReceiver.receive(resolveMessage, protocolData);
        } else if (helper.getWSDActionResolveMatches().equals(string)) {
            ResolveMatchesMessage resolveMatchesMessage = this.msgParser.parseResolveMatchesMessage(sOAPHeader, elementParser, protocolData, helper);
            messageReceiver.receive(resolveMatchesMessage, protocolData);
        } else if ("http://schemas.xmlsoap.org/ws/2004/09/transfer/Get".equals(string)) {
            URI uRI = protocolData.getTransportAddress();
            if (uRI != null && DPWSCommunicationManager.getRegisterForGetMetadata().contains(uRI)) {
                messageReceiver.receive(new GetMetadataMessage(sOAPHeader), protocolData);
            } else {
                messageReceiver.receive(new GetMessage(sOAPHeader), protocolData);
            }
        } else if ("http://schemas.xmlsoap.org/ws/2004/09/transfer/GetResponse".equals(string)) {
            HashSet hashSet = (HashSet)DPWSCommunicationManager.getMessageIDsForGetMetadataMapping();
            if (hashSet.remove(sOAPHeader.getRelatesTo())) {
                GetMetadataResponseMessage getMetadataResponseMessage = this.msgParser.parseGetMetadataResponseMessage(sOAPHeader, elementParser, protocolData, helper);
                messageReceiver.receive(getMetadataResponseMessage, protocolData);
            } else {
                GetResponseMessage getResponseMessage = this.msgParser.parseGetResponseMessage(sOAPHeader, elementParser, protocolData, helper);
                messageReceiver.receive(getResponseMessage, protocolData);
            }
        } else if ("http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata/Request".equals(string)) {
            GetMetadataMessage getMetadataMessage = this.msgParser.parseGetMetadataMessage(sOAPHeader, elementParser, protocolData, helper);
            messageReceiver.receive(getMetadataMessage, protocolData);
        } else if ("http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata/Response".equals(string)) {
            GetMetadataResponseMessage getMetadataResponseMessage = this.msgParser.parseGetMetadataResponseMessage(sOAPHeader, elementParser, protocolData, helper);
            messageReceiver.receive(getMetadataResponseMessage, protocolData);
        } else if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/Subscribe".equals(string)) {
            SubscribeMessage subscribeMessage = this.msgParser.parseSubscribeMessage(sOAPHeader, elementParser, protocolData, helper);
            messageReceiver.receive(subscribeMessage, protocolData);
        } else if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/SubscribeResponse".equals(string)) {
            SubscribeResponseMessage subscribeResponseMessage = this.msgParser.parseSubscribeResponseMessage(sOAPHeader, elementParser, protocolData, helper);
            messageReceiver.receive(subscribeResponseMessage, protocolData);
        } else if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/Renew".equals(string)) {
            RenewMessage renewMessage = this.msgParser.parseRenewMessage(sOAPHeader, elementParser, protocolData, helper);
            messageReceiver.receive(renewMessage, protocolData);
        } else if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/RenewResponse".equals(string)) {
            RenewResponseMessage renewResponseMessage = this.msgParser.parseRenewResponseMessage(sOAPHeader, elementParser, protocolData, helper);
            messageReceiver.receive(renewResponseMessage, protocolData);
        } else if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatus".equals(string)) {
            GetStatusMessage getStatusMessage = this.msgParser.parseGetStatusMessage(sOAPHeader, elementParser, protocolData, helper);
            messageReceiver.receive(getStatusMessage, protocolData);
        } else if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatusResponse".equals(string)) {
            GetStatusResponseMessage getStatusResponseMessage = this.msgParser.parseGetStatusResponseMessage(sOAPHeader, elementParser, protocolData, helper);
            messageReceiver.receive(getStatusResponseMessage, protocolData);
        } else if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/Unsubscribe".equals(string)) {
            UnsubscribeMessage unsubscribeMessage = this.msgParser.parseUnsubscribeMessage(sOAPHeader, elementParser, protocolData, helper);
            messageReceiver.receive(unsubscribeMessage, protocolData);
        } else if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/UnsubscribeResponse".equals(string)) {
            UnsubscribeResponseMessage unsubscribeResponseMessage = this.msgParser.parseUnsubscribeResponseMessage(sOAPHeader, elementParser, protocolData, helper);
            messageReceiver.receive(unsubscribeResponseMessage, protocolData);
        } else if ("http://schemas.xmlsoap.org/ws/2004/08/eventing/SubscriptionEnd".equals(string)) {
            SubscriptionEndMessage subscriptionEndMessage = this.msgParser.parseSubscriptionEndMessage(sOAPHeader, elementParser, protocolData, helper);
            messageReceiver.receive(subscriptionEndMessage, protocolData);
        } else {
            return false;
        }
        return true;
    }

    public Message generateMessage(InputStream inputStream) throws Exception {
        InlineMessageReceiver inlineMessageReceiver = new InlineMessageReceiver();
        this.deliverMessage(inputStream, inlineMessageReceiver, new DPWSProtocolData("", true, "", 0, "", 0, false), DefaultSOAP2MessageGenerator.getDefaultMessageDiscarder());
        if (inlineMessageReceiver.e != null) {
            throw inlineMessageReceiver.e;
        }
        return inlineMessageReceiver.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverMessage(InputStream inputStream, MessageReceiver messageReceiver, ProtocolData protocolData, DefaultMessageDiscarder defaultMessageDiscarder) {
        block50: {
            Object object;
            Object object2;
            XmlPullParser xmlPullParser = this.parser;
            if (DPWSFramework.hasModule(64)) {
                inputStream = DPWSFramework.getSecurityManager().wrapInputStream(inputStream, protocolData);
            }
            try {
                xmlPullParser.setInput(inputStream, null);
                xmlPullParser.nextTag();
                String string = xmlPullParser.getNamespace();
                object2 = xmlPullParser.getName();
                if ("http://www.w3.org/2003/05/soap-envelope".equals(string)) {
                    if ("Envelope".equals(object2)) {
                        object = new ElementParser(xmlPullParser);
                        ((ElementParser)object).nextTag();
                        string = ((ElementParser)object).getNamespace();
                        object2 = ((ElementParser)object).getName();
                        SOAPHeader sOAPHeader = null;
                        if ("http://www.w3.org/2003/05/soap-envelope".equals(string) && "Header".equals(object2)) {
                            int n;
                            sOAPHeader = this.msgParser.parseSOAPHeader((ElementParser)object, protocolData, helper);
                            if (Log.isDebug()) {
                                Log.debug("<I> Incoming SOAP message header: [ " + sOAPHeader + " ]", 4);
                            }
                            if (defaultMessageDiscarder == null) {
                                defaultMessageDiscarder = DefaultSOAP2MessageGenerator.getDefaultMessageDiscarder();
                            }
                            if ((n = defaultMessageDiscarder.discardMessage(sOAPHeader, protocolData)) > 0) {
                                MonitorStreamFactory monitorStreamFactory = DPWSFramework.getMonitorStreamFactory();
                                if (monitorStreamFactory != null) {
                                    MonitoringContext monitoringContext = monitorStreamFactory.getMonitoringContextIn(protocolData);
                                    if (monitoringContext != null) {
                                        monitorStreamFactory.discard(protocolData, monitoringContext, n);
                                    } else {
                                        Log.warn("Cannot get correct monitoring context for message generation.");
                                    }
                                }
                                return;
                            }
                            object2 = ((ElementParser)object).getName();
                            ((ElementParser)object).nextTag();
                            string = ((ElementParser)object).getNamespace();
                            object2 = ((ElementParser)object).getName();
                        }
                        if ("http://www.w3.org/2003/05/soap-envelope".equals(string) && "Body".equals(object2)) {
                            this.deliverBody(sOAPHeader, (ElementParser)object, messageReceiver, protocolData);
                            break block50;
                        }
                        throw new UnexpectedElementException(string + ":" + (String)object2 + " (SOAP12:Body expected)");
                    }
                    throw new UnexpectedElementException(string + ":" + (String)object2 + " (SOAP12:Envelope expected)");
                }
                if ("http://schemas.xmlsoap.org/soap/envelope/".equals(string)) {
                    throw new VersionMismatchException("SOAP http://schemas.xmlsoap.org/soap/envelope/", 0);
                }
                throw new UnexpectedElementException(string + ":" + (String)object2 + " (SOAP12:Envelope expected)");
            }
            catch (VersionMismatchException versionMismatchException) {
                if (Log.isDebug()) {
                    Log.debug("Version mismatch: " + versionMismatchException.getMessage(), 4);
                }
                if ((object2 = DPWSFramework.getMonitorStreamFactory()) != null) {
                    object = ((MonitorStreamFactory)object2).getMonitoringContextIn(protocolData);
                    if (object != null) {
                        ((MonitorStreamFactory)object2).discard(protocolData, (MonitoringContext)object, 4);
                    } else {
                        Log.warn("Cannot get correct monitoring context for message generation.");
                    }
                }
                messageReceiver.receiveFailed(versionMismatchException, protocolData);
            }
            catch (UnexpectedMessageException unexpectedMessageException) {
                Log.error("Unexpected message: " + unexpectedMessageException.getMessage());
                unexpectedMessageException.printStackTrace();
                messageReceiver.receiveFailed(unexpectedMessageException, protocolData);
            }
            catch (MissingElementException missingElementException) {
                Log.error("Missing required element " + missingElementException.getMessage());
                messageReceiver.receiveFailed(missingElementException, protocolData);
            }
            catch (UnexpectedElementException unexpectedElementException) {
                Log.error("Unexpected element: " + unexpectedElementException.getMessage());
                messageReceiver.receiveFailed(unexpectedElementException, protocolData);
            }
            catch (XmlPullParserException xmlPullParserException) {
                Log.error("Parse exception during XML processing: " + xmlPullParserException + ", caused by " + xmlPullParserException.getDetail());
                xmlPullParserException.printStackTrace();
                messageReceiver.receiveFailed(xmlPullParserException, protocolData);
            }
            catch (IOException iOException) {
                Log.error("IO exception during XML processing: " + iOException);
                iOException.printStackTrace();
                messageReceiver.receiveFailed(iOException, protocolData);
            }
            finally {
                try {
                    xmlPullParser.setInput(null);
                }
                catch (XmlPullParserException xmlPullParserException) {
                    Log.error("Unable to reset XML parser: " + xmlPullParserException);
                }
            }
        }
    }

    static {
        defaultDiscarder = DEFAULT_DISCARDER = new DefaultMessageDiscarder();
    }

    protected static class InlineMessageReceiver
    implements MessageReceiver {
        Message result;
        Exception e;

        protected InlineMessageReceiver() {
        }

        public void sendFailed(Exception exception, ProtocolData protocolData) {
            this.e = exception;
        }

        public void receiveFailed(Exception exception, ProtocolData protocolData) {
            this.e = exception;
        }

        public void receive(FaultMessage faultMessage, ProtocolData protocolData) {
            this.result = faultMessage;
        }

        public void receive(InvokeMessage invokeMessage, ProtocolData protocolData) {
            this.result = invokeMessage;
        }

        public void receive(SubscriptionEndMessage subscriptionEndMessage, ProtocolData protocolData) {
            this.result = subscriptionEndMessage;
        }

        public void receive(UnsubscribeResponseMessage unsubscribeResponseMessage, ProtocolData protocolData) {
            this.result = unsubscribeResponseMessage;
        }

        public void receive(UnsubscribeMessage unsubscribeMessage, ProtocolData protocolData) {
            this.result = unsubscribeMessage;
        }

        public void receive(RenewResponseMessage renewResponseMessage, ProtocolData protocolData) {
            this.result = renewResponseMessage;
        }

        public void receive(RenewMessage renewMessage, ProtocolData protocolData) {
            this.result = renewMessage;
        }

        public void receive(GetStatusResponseMessage getStatusResponseMessage, ProtocolData protocolData) {
            this.result = getStatusResponseMessage;
        }

        public void receive(GetStatusMessage getStatusMessage, ProtocolData protocolData) {
            this.result = getStatusMessage;
        }

        public void receive(SubscribeResponseMessage subscribeResponseMessage, ProtocolData protocolData) {
            this.result = subscribeResponseMessage;
        }

        public void receive(SubscribeMessage subscribeMessage, ProtocolData protocolData) {
            this.result = subscribeMessage;
        }

        public void receive(GetMetadataResponseMessage getMetadataResponseMessage, ProtocolData protocolData) {
            this.result = getMetadataResponseMessage;
        }

        public void receive(GetMetadataMessage getMetadataMessage, ProtocolData protocolData) {
            this.result = getMetadataMessage;
        }

        public void receive(GetResponseMessage getResponseMessage, ProtocolData protocolData) {
            this.result = getResponseMessage;
        }

        public void receive(GetMessage getMessage, ProtocolData protocolData) {
            this.result = getMessage;
        }

        public void receive(ResolveMatchesMessage resolveMatchesMessage, ProtocolData protocolData) {
            this.result = resolveMatchesMessage;
        }

        public void receive(ResolveMessage resolveMessage, ProtocolData protocolData) {
            this.result = resolveMessage;
        }

        public void receive(ProbeMatchesMessage probeMatchesMessage, ProtocolData protocolData) {
            this.result = probeMatchesMessage;
        }

        public void receive(ProbeMessage probeMessage, ProtocolData protocolData) {
            this.result = probeMessage;
        }

        public void receive(ByeMessage byeMessage, ProtocolData protocolData) {
            this.result = byeMessage;
        }

        public void receive(HelloMessage helloMessage, ProtocolData protocolData) {
            this.result = helloMessage;
        }

        public OperationDescription getOperation(String string) {
            return null;
        }
    }
}

