/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.message;

import org.ws4d.java.communication.ProtocolInfo;
import org.ws4d.java.constants.DPWSMessageConstants;
import org.ws4d.java.message.SOAPHeader;
import org.ws4d.java.types.AppSequence;
import org.ws4d.java.types.AttributedURI;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.URI;
import org.ws4d.java.types.UnknownDataContainer;
import org.ws4d.java.types.XAddressInfo;
import org.ws4d.java.util.StringUtil;

public abstract class Message
extends UnknownDataContainer
implements DPWSMessageConstants {
    public static final int UNKNOWN_ROUTING_SCHEME = 0;
    public static final int UNICAST_ROUTING_SCHEME = 1;
    public static final int MULTICAST_ROUTING_SCHEME = 2;
    protected SOAPHeader header;
    protected boolean inbound = false;
    private XAddressInfo targetXAddressInfo;
    private int routingScheme = 0;
    private boolean secureMessage = false;
    private Object certificate;
    private Object privateKey;

    public Message(SOAPHeader sOAPHeader) {
        this.header = sOAPHeader;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(StringUtil.formatClassName(this.getClass()));
        stringBuffer.append(" [ header=").append(this.header);
        stringBuffer.append(", inbound=").append(this.inbound);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public void setResponseTo(Message message) {
        this.header.setResponseTo(message.header);
        this.header.setProtocolInfo(message.getProtocolInfo());
    }

    public void setResponseTo(SOAPHeader sOAPHeader) {
        this.header.setResponseTo(sOAPHeader);
    }

    public abstract int getType();

    public SOAPHeader getHeader() {
        return this.header;
    }

    public AttributedURI getAction() {
        return this.header.getAction();
    }

    public boolean isSecure() {
        return this.secureMessage;
    }

    public void setCertificate(Object object) {
        this.certificate = object;
    }

    public void setPrivateKey(Object object) {
        this.privateKey = object;
    }

    public Object getCertificate() {
        return this.certificate;
    }

    public Object getPrivateKey() {
        return this.privateKey;
    }

    public void setSecure(boolean bl) {
        this.secureMessage = bl;
    }

    public AttributedURI getMessageId() {
        return this.header.getMessageId();
    }

    public AttributedURI getRelatesTo() {
        return this.header.getRelatesTo();
    }

    public AttributedURI getTo() {
        return this.header.getTo();
    }

    public EndpointReference getReplyTo() {
        return this.header.getReplyTo();
    }

    public AppSequence getAppSequence() {
        return this.header.getAppSequence();
    }

    public URI getTargetAddress() {
        return this.targetXAddressInfo != null ? this.targetXAddressInfo.getXAddress() : null;
    }

    public XAddressInfo getTargetXAddressInfo() {
        return this.targetXAddressInfo;
    }

    public void setTargetXAddressInfo(XAddressInfo xAddressInfo) {
        this.targetXAddressInfo = xAddressInfo;
    }

    public boolean isInbound() {
        return this.inbound;
    }

    public void setInbound(boolean bl) {
        this.inbound = bl;
    }

    public void setProtocolInfo(ProtocolInfo protocolInfo) {
        this.header.setProtocolInfo(protocolInfo);
    }

    public ProtocolInfo getProtocolInfo() {
        return this.header.getProtocolInfo();
    }

    public int getRoutingScheme() {
        return this.routingScheme;
    }

    public void setRoutingScheme(int n) {
        this.routingScheme = n;
    }

    protected void setSOAPHeader(SOAPHeader sOAPHeader) {
        this.header = sOAPHeader;
    }
}

