/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.schema;

import java.io.IOException;
import org.ws4d.java.io.xml.ElementParser;
import org.ws4d.java.schema.Any;
import org.ws4d.java.structures.EmptyStructures;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LinkedList;
import org.ws4d.java.structures.List;
import org.ws4d.java.util.StringUtil;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

abstract class Annotation
implements Any {
    static final String TAG_DOCUMENTATION = "documentation";
    static final String TAG_APPINFO = "appInfo";
    static final String TAG_ANNOTATION = "annotation";
    protected List documentation = EmptyStructures.EMPTY_LIST;
    protected List appinfo = EmptyStructures.EMPTY_LIST;

    Annotation() {
    }

    static final void serialize(XmlSerializer xmlSerializer, Annotation annotation) throws IOException {
        String string;
        Iterator iterator;
        if (!(annotation.documentation != null && annotation.documentation.size() != 0 || annotation.appinfo != null && annotation.appinfo.size() != 0)) {
            return;
        }
        xmlSerializer.startTag("http://www.w3.org/2001/XMLSchema", TAG_ANNOTATION);
        if (annotation.documentation != null && annotation.documentation.size() > 0) {
            iterator = annotation.documentation.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                xmlSerializer.startTag("http://www.w3.org/2001/XMLSchema", TAG_DOCUMENTATION);
                xmlSerializer.text(string);
                xmlSerializer.endTag("http://www.w3.org/2001/XMLSchema", TAG_DOCUMENTATION);
            }
        }
        if (annotation.appinfo != null && annotation.appinfo.size() > 0) {
            iterator = annotation.appinfo.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                xmlSerializer.startTag("http://www.w3.org/2001/XMLSchema", TAG_APPINFO);
                xmlSerializer.text(string);
                xmlSerializer.endTag("http://www.w3.org/2001/XMLSchema", TAG_APPINFO);
            }
        }
        xmlSerializer.endTag("http://www.w3.org/2001/XMLSchema", TAG_ANNOTATION);
    }

    static final void handleAnnotation(ElementParser elementParser, Annotation annotation) throws XmlPullParserException, IOException {
        int n = elementParser.getDepth();
        while (elementParser.nextTag() != 3 && elementParser.getDepth() >= n + 1) {
            int n2;
            String string = elementParser.getName();
            String string2 = elementParser.getNamespace();
            if (!"http://www.w3.org/2001/XMLSchema".equals(string2)) continue;
            if (elementParser.getEventType() == 2 && StringUtil.equalsIgnoreCase(TAG_DOCUMENTATION, string)) {
                n2 = elementParser.getDepth();
                elementParser.next();
                while (elementParser.getDepth() >= n2 && (elementParser.getEventType() != 3 || elementParser.getDepth() != n2)) {
                    if (elementParser.getEventType() == 4 && elementParser.getDepth() == n2 && !elementParser.isWhitespace()) {
                        annotation.addDocumentation(elementParser.getText());
                    }
                    elementParser.next();
                }
                if (elementParser.getEventType() != 4 || elementParser.getDepth() != n2 || elementParser.isWhitespace()) continue;
                annotation.addDocumentation(elementParser.getText());
                continue;
            }
            if (elementParser.getEventType() != 2 || !StringUtil.equalsIgnoreCase(TAG_APPINFO, string)) continue;
            if (elementParser.getDepth() == 0) {
                annotation.addAppInfo(elementParser.nextText());
                continue;
            }
            n2 = elementParser.getDepth();
            elementParser.next();
            while (elementParser.getDepth() >= n2 && (elementParser.getEventType() != 3 || elementParser.getDepth() != n2)) {
                elementParser.next();
            }
        }
    }

    protected void addDocumentation(String string) {
        if (this.documentation == EmptyStructures.EMPTY_LIST) {
            this.documentation = new LinkedList();
        }
        this.documentation.add(string);
    }

    protected Iterator getDocumentations() {
        return this.documentation.iterator();
    }

    protected void addAppInfo(String string) {
        if (this.appinfo == EmptyStructures.EMPTY_LIST) {
            this.appinfo = new LinkedList();
        }
        this.appinfo.add(string);
    }

    protected Iterator getAppInfos() {
        return this.appinfo.iterator();
    }
}

