/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.schema;

import java.io.IOException;
import org.ws4d.java.io.xml.ElementParser;
import org.ws4d.java.schema.Annotation;
import org.ws4d.java.schema.Element;
import org.ws4d.java.schema.Reference;
import org.ws4d.java.schema.Schema;
import org.ws4d.java.schema.SchemaException;
import org.ws4d.java.schema.SchemaUtil;
import org.ws4d.java.schema.SimpleType;
import org.ws4d.java.schema.Type;
import org.ws4d.java.types.QName;
import org.ws4d.java.util.StringUtil;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class Attribute
extends Reference {
    static final String TAG_ATTRIBUTE = "attribute";
    protected static int count = 0;
    protected Type type = null;
    protected QName typeLink = null;
    protected byte use = 1;
    protected boolean fixed = false;
    protected String defaultValue = null;

    public static int getAttributeCount() {
        return count;
    }

    static final Attribute createAttribute(ElementParser elementParser, String string, Schema schema) throws XmlPullParserException, IOException, SchemaException {
        Object object;
        String string2;
        String string3;
        String string4;
        String string5 = elementParser.getAttributeValue(null, "name");
        String string6 = elementParser.getAttributeValue(null, "type");
        String string7 = elementParser.getAttributeValue(null, "ref");
        String string8 = elementParser.getAttributeValue(null, "use");
        String string9 = elementParser.getAttributeValue(null, "fixed");
        String string10 = elementParser.getAttributeValue(null, "default");
        if (string5 == null && string7 == null) {
            throw new SchemaException("Wrong attribute definiton. No name or reference set.");
        }
        Attribute attribute = null;
        attribute = string5 == null ? new Attribute() : new Attribute(new QName(string5, string));
        attribute.setParentSchema(schema);
        if (string8 != null) {
            attribute.setUse(string8);
        }
        if (string9 != null && string10 != null) {
            throw new SchemaException("Wrong attribute definiton. Attribute can only have fixed or default. Not both.");
        }
        if (string9 != null) {
            attribute.setFixed(string9, true);
        } else if (string10 != null) {
            attribute.setDefault(string10);
        }
        if (string6 != null && string7 == null) {
            string4 = SchemaUtil.getPrefix(string6);
            string3 = SchemaUtil.getName(string6);
            string2 = elementParser.getNamespace(string4);
            object = new QName(string3, string2);
            if ("http://www.w3.org/2001/XMLSchema".equals(string2)) {
                Type type = SchemaUtil.getType((QName)object);
                if (type != null) {
                    attribute.setType(type);
                }
            } else {
                attribute.setTypeLink((QName)object);
                schema.addAttributeForResolve(attribute);
            }
        } else if (string7 != null && string6 == null) {
            string4 = SchemaUtil.getPrefix(string7);
            string3 = SchemaUtil.getName(string7);
            string2 = elementParser.getNamespace(string4);
            attribute.setReferenceLink(new QName(string3, string2));
            schema.addAttributeForResolve(attribute);
        }
        int n = elementParser.getDepth();
        while (elementParser.nextTag() != 3 && elementParser.getDepth() == n + 1) {
            string3 = elementParser.getNamespace();
            string2 = elementParser.getName();
            if (!"http://www.w3.org/2001/XMLSchema".equals(string3)) continue;
            if (StringUtil.equalsIgnoreCase("simpleType", string2)) {
                object = SimpleType.createSimpleType(elementParser, string, schema);
                attribute.setType((Type)object);
                continue;
            }
            if (!StringUtil.equalsIgnoreCase("annotation", string2)) continue;
            Annotation.handleAnnotation(elementParser, attribute);
        }
        return attribute;
    }

    Attribute() {
        this((QName)null);
    }

    public Attribute(String string, String string2) {
        this(new QName(string, string2));
    }

    public Attribute(String string, String string2, Type type) {
        this(new QName(string, string2), type);
    }

    public Attribute(QName qName) {
        this(qName, null);
    }

    public Attribute(QName qName, Type type) {
        this.name = qName;
        if (qName != null && !"http://www.w3.org/2001/XMLSchema".equals(qName.getNamespace()) || qName == null) {
            ++count;
        }
        this.setType(type);
    }

    public Attribute(Element element) {
        this((QName)null);
        this.setReference(element);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(StringUtil.formatClassName(this.getClass()));
        QName qName = this.getName();
        stringBuffer.append(" [ name=").append(qName.getLocalPart());
        stringBuffer.append(", namespace=").append(qName.getNamespace());
        stringBuffer.append(", type=").append(this.getType().getName());
        if (this.fixed) {
            stringBuffer.append(", fixed=").append(this.defaultValue);
        } else if (this.defaultValue != null) {
            stringBuffer.append(", default=").append(this.defaultValue);
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public int getSchemaIdentifier() {
        return 5;
    }

    public Type getType() {
        if (this.reference != null) {
            return ((Attribute)this.reference).getType();
        }
        if (this.type == null) {
            return SchemaUtil.getAnySimpleType();
        }
        return this.type;
    }

    public boolean isOptional() {
        return this.use == 1;
    }

    public boolean isProhibited() {
        return this.use == 2;
    }

    public boolean isRequired() {
        return this.use == 3;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public String getFixed() {
        return this.fixed ? this.defaultValue : null;
    }

    public void setType(Type type) {
        this.typeLink = null;
        this.type = type;
    }

    public void setUse(String string) {
        if ("optional".equals(string)) {
            this.use = 1;
        } else if ("prohibited".equals(string)) {
            this.use = (byte)2;
        } else if ("required".equals(string)) {
            this.use = (byte)3;
        }
    }

    public String getUse() {
        if (this.use == 2) {
            return "prohibited";
        }
        if (this.use == 3) {
            return "required";
        }
        return "optional";
    }

    public void setDefault(String string) {
        if (this.fixed) {
            return;
        }
        this.defaultValue = string;
    }

    public void setFixed(String string, boolean bl) {
        this.fixed = bl;
        this.defaultValue = string;
    }

    void setUse(byte by) {
        this.use = by;
    }

    void setTypeLink(QName qName) {
        this.typeLink = qName;
    }

    QName getTypeLink() {
        return this.typeLink;
    }

    void serialize(XmlSerializer xmlSerializer, Schema schema) throws IOException {
        xmlSerializer.startTag("http://www.w3.org/2001/XMLSchema", TAG_ATTRIBUTE);
        if (this.name != null) {
            xmlSerializer.attribute(null, "name", this.name.getLocalPart());
        }
        if (this.fixed) {
            xmlSerializer.attribute(null, "fixed", this.defaultValue);
        } else if (this.defaultValue != null) {
            xmlSerializer.attribute(null, "default", this.defaultValue);
        }
        if (this.use > 1) {
            xmlSerializer.attribute(null, "use", this.getUse());
        }
        if (this.type != null) {
            QName qName = this.type.getName();
            if (qName == null) {
                this.type.serialize(xmlSerializer, schema);
            } else {
                String string = xmlSerializer.getPrefix(qName.getNamespace(), false);
                if (string != null && !"".equals(string)) {
                    qName.setPrefix(string);
                    xmlSerializer.attribute(null, "type", qName.getLocalPartPrefixed());
                } else {
                    xmlSerializer.attribute(null, "type", qName.getLocalPart());
                }
            }
        } else if (this.reference != null) {
            QName qName = this.reference.getName();
            String string = xmlSerializer.getPrefix(qName.getNamespace(), false);
            if (string != null && !"".equals(string)) {
                qName.setPrefix(string);
                xmlSerializer.attribute(null, "ref", qName.getLocalPartPrefixed());
            } else {
                xmlSerializer.attribute(null, "ref", qName.getLocalPart());
            }
        }
        xmlSerializer.endTag("http://www.w3.org/2001/XMLSchema", TAG_ATTRIBUTE);
    }
}

