/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.schema;

import java.io.IOException;
import org.ws4d.java.io.xml.ElementParser;
import org.ws4d.java.schema.AllContainer;
import org.ws4d.java.schema.Any;
import org.ws4d.java.schema.AnyElement;
import org.ws4d.java.schema.ChoiceContainer;
import org.ws4d.java.schema.Element;
import org.ws4d.java.schema.Group;
import org.ws4d.java.schema.Schema;
import org.ws4d.java.schema.SchemaException;
import org.ws4d.java.schema.SequenceContainer;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LinkedList;
import org.ws4d.java.structures.List;
import org.ws4d.java.structures.ReadOnlyIterator;
import org.ws4d.java.types.QName;
import org.ws4d.java.util.StringUtil;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public abstract class ElementContainer
implements Any {
    static final String TAG_CHOICE = "choice";
    static final String TAG_SEQUENCE = "sequence";
    static final String TAG_ALL = "all";
    protected List container = null;
    protected int min = 1;
    protected int max = 1;
    protected int containerCount = 0;
    protected int elementCount = 0;
    protected int groupCount = 0;

    static final void handleContainerElements(ElementParser elementParser, ElementContainer elementContainer, String string, Schema schema) throws XmlPullParserException, IOException, SchemaException {
        String string2 = elementParser.getAttributeValue(null, "minOccurs");
        String string3 = elementParser.getAttributeValue(null, "maxOccurs");
        if (string2 != null) {
            elementContainer.setMinOccurs(Integer.parseInt(string2.trim()));
        }
        if (string3 != null) {
            if ("unbounded".equals(string3)) {
                elementContainer.setMaxOccurs(-1);
            } else {
                elementContainer.setMaxOccurs(Integer.parseInt(string3.trim()));
            }
        }
        int n = elementParser.getDepth();
        while (elementParser.nextTag() != 3 && elementParser.getDepth() == n + 1) {
            Any any;
            String string4 = elementParser.getNamespace();
            String string5 = elementParser.getName();
            if (!"http://www.w3.org/2001/XMLSchema".equals(string4)) continue;
            if (StringUtil.equalsIgnoreCase("element", string5)) {
                any = Element.createElement(elementParser, string, schema);
                elementContainer.addElement((Element)any);
                continue;
            }
            if (StringUtil.equalsIgnoreCase(TAG_SEQUENCE, string5)) {
                any = new SequenceContainer();
                ElementContainer.handleContainerElements(elementParser, (ElementContainer)any, string, schema);
                elementContainer.addContainer((ElementContainer)any);
                continue;
            }
            if (StringUtil.equalsIgnoreCase(TAG_ALL, string5)) {
                any = new AllContainer();
                ElementContainer.handleContainerElements(elementParser, (ElementContainer)any, string, schema);
                elementContainer.addContainer((ElementContainer)any);
                continue;
            }
            if (StringUtil.equalsIgnoreCase(TAG_CHOICE, string5)) {
                any = new ChoiceContainer();
                ElementContainer.handleContainerElements(elementParser, (ElementContainer)any, string, schema);
                elementContainer.addContainer((ElementContainer)any);
                continue;
            }
            if (StringUtil.equalsIgnoreCase("group", string5)) {
                any = Group.createGroup(elementParser, string, schema);
                elementContainer.addGroup((Group)any);
                continue;
            }
            if (!StringUtil.equalsIgnoreCase("any", string5)) continue;
            any = AnyElement.createAnyElement(elementParser);
            elementContainer.addAnyElement((AnyElement)any);
        }
    }

    ElementContainer(List list) {
        this.container = list;
    }

    public String toString() {
        int n = this.getElementCount();
        return "Container [ own=" + this.elementCount + ", inherit=" + (n - this.elementCount) + ", all=" + n + ", min=" + this.min + ", max=" + this.max + ", container=" + this.container + " ]";
    }

    public int getMinOccurs() {
        return this.min;
    }

    public int getMaxOccurs() {
        return this.max;
    }

    public void setMinOccurs(int n) {
        this.min = n;
    }

    public void setMaxOccurs(int n) {
        this.max = n;
    }

    public void mergeContainer(ElementContainer elementContainer) {
        if (elementContainer == null) {
            return;
        }
        if (elementContainer.getContainerType() != this.getContainerType()) {
            throw new RuntimeException("XML schema container mismatch! Cannot merge different container types.");
        }
        Iterator iterator = elementContainer.allElements();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            this.addElement(element);
        }
    }

    public int getInnerContainerCount() {
        int n = 0;
        Iterator iterator = this.container.iterator();
        while (iterator.hasNext()) {
            Any any = (Any)iterator.next();
            int n2 = any.getSchemaIdentifier();
            if (n2 != 13 && n2 != 15 && n2 != 14) continue;
            ++n;
        }
        return n;
    }

    public void addContainer(ElementContainer elementContainer) {
        ++this.containerCount;
        this.container.add(elementContainer);
    }

    public void addElement(Element element) {
        ++this.elementCount;
        this.container.add(element);
    }

    public void addAnyElement(AnyElement anyElement) {
        ++this.elementCount;
        this.container.add(anyElement);
    }

    public void addGroup(Group group) {
        QName qName = group.getName();
        if (qName == null) {
            qName = group.getReferenceLink();
        }
        ++this.elementCount;
        this.container.add(group);
    }

    public int getElementCount() {
        int n = this.elementCount;
        Iterator iterator = this.container.iterator();
        while (iterator.hasNext()) {
            Any any = (Any)iterator.next();
            int n2 = any.getSchemaIdentifier();
            if (n2 == 13 || n2 == 15 || n2 == 14) {
                n += ((ElementContainer)any).getElementCount();
                continue;
            }
            if (n2 != 2) continue;
            n += ((Group)any).getElementCount();
        }
        return n;
    }

    public Element getElementByName(QName qName) {
        if (qName == null) {
            return null;
        }
        Iterator iterator = this.container.iterator();
        while (iterator.hasNext()) {
            Any any = (Any)iterator.next();
            int n = any.getSchemaIdentifier();
            Element element = null;
            if (n == 1) {
                element = (Element)any;
            } else if (n == 15 || n == 13 || n == 14) {
                ElementContainer elementContainer = (ElementContainer)any;
                element = elementContainer.getElementByName(qName);
            }
            if (element == null || !qName.equals(element.getName())) continue;
            return element;
        }
        return null;
    }

    public Element getLocalElementByName(QName qName) {
        if (qName == null) {
            return null;
        }
        Iterator iterator = this.container.iterator();
        while (iterator.hasNext()) {
            Element element;
            Any any = (Any)iterator.next();
            int n = any.getSchemaIdentifier();
            if (n != 1 || !qName.equals((element = (Element)any).getName())) continue;
            return element;
        }
        return null;
    }

    public Element getElementByName(String string) {
        if (string == null) {
            return null;
        }
        Iterator iterator = this.container.iterator();
        while (iterator.hasNext()) {
            Any any = (Any)iterator.next();
            int n = any.getSchemaIdentifier();
            Element element = null;
            if (n == 1) {
                element = (Element)any;
            } else if (n == 15 || n == 13 || n == 14) {
                ElementContainer elementContainer = (ElementContainer)any;
                element = elementContainer.getElementByName(string);
            }
            if (!string.equals(element.getName().getLocalPart())) continue;
            return element;
        }
        return null;
    }

    public Element getLocalElementByName(String string) {
        if (string == null) {
            return null;
        }
        Iterator iterator = this.container.iterator();
        while (iterator.hasNext()) {
            Element element;
            Any any = (Any)iterator.next();
            int n = any.getSchemaIdentifier();
            if (n != 1 || !string.equals((element = (Element)any).getName().getLocalPart())) continue;
            return element;
        }
        return null;
    }

    public Iterator listAll() {
        return new ReadOnlyIterator(new ArrayList(this.container));
    }

    public Iterator containers() {
        int n = this.getInnerContainerCount();
        ArrayList arrayList = new ArrayList(n);
        Iterator iterator = this.container.iterator();
        while (iterator.hasNext()) {
            Any any = (Any)iterator.next();
            int n2 = any.getSchemaIdentifier();
            if (n2 != 13 && n2 != 15 && n2 != 14) continue;
            ((List)arrayList).add(any);
        }
        return arrayList.iterator();
    }

    public Iterator all() {
        int n = this.container.size();
        ArrayList arrayList = new ArrayList(n);
        Iterator iterator = this.container.iterator();
        while (iterator.hasNext()) {
            Any any = (Any)iterator.next();
            int n2 = any.getSchemaIdentifier();
            if (n2 == 13 || n2 == 15 || n2 == 14) {
                ((List)arrayList).add(any);
                continue;
            }
            if (n2 == 2) {
                Group group = (Group)any;
                Iterator iterator2 = group.elements();
                while (iterator2.hasNext()) {
                    Any any2 = (Any)iterator2.next();
                    ((List)arrayList).add(any2);
                }
                continue;
            }
            if (n2 != 1 && n2 != 16) continue;
            ((List)arrayList).add(any);
        }
        return arrayList.iterator();
    }

    public Element getFirstElement() {
        Element element = null;
        Iterator iterator = this.container.iterator();
        while (iterator.hasNext()) {
            Any any = (Any)iterator.next();
            int n = any.getSchemaIdentifier();
            if (n == 2) {
                Iterator iterator2 = ((Group)any).elements();
                while (iterator2.hasNext()) {
                    Any any2 = (Any)iterator2.next();
                    if (element != null || any2.getSchemaIdentifier() != 1) continue;
                    element = (Element)any2;
                }
                continue;
            }
            if (n != 1 || element != null) continue;
            element = (Element)any;
        }
        return element;
    }

    public Iterator ownElements() {
        int n = this.container.size();
        ArrayList arrayList = new ArrayList(n);
        Iterator iterator = this.container.iterator();
        while (iterator.hasNext()) {
            Any any = (Any)iterator.next();
            int n2 = any.getSchemaIdentifier();
            if (n2 == 2) {
                Iterator iterator2 = ((Group)any).elements();
                while (iterator2.hasNext()) {
                    Any any2 = (Any)iterator2.next();
                    ((List)arrayList).add(any2);
                }
                continue;
            }
            if (n2 != 1 && n2 != 16) continue;
            ((List)arrayList).add(any);
        }
        return arrayList.iterator();
    }

    public Iterator allElements() {
        int n = this.getElementCount();
        ArrayList arrayList = new ArrayList(n);
        Iterator iterator = this.container.iterator();
        while (iterator.hasNext()) {
            Any any;
            Iterator iterator2;
            Any any2 = (Any)iterator.next();
            int n2 = any2.getSchemaIdentifier();
            if (n2 == 13 || n2 == 15 || n2 == 14) {
                iterator2 = ((ElementContainer)any2).allElements();
                while (iterator2.hasNext()) {
                    any = (Any)iterator2.next();
                    ((List)arrayList).add(any);
                }
                continue;
            }
            if (n2 == 2) {
                iterator2 = ((Group)any2).elements();
                while (iterator2.hasNext()) {
                    any = (Any)iterator2.next();
                    ((List)arrayList).add(any);
                }
                continue;
            }
            if (n2 != 1 && n2 != 16) continue;
            ((List)arrayList).add(any2);
        }
        return arrayList.iterator();
    }

    public Iterator getContainerContent() {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.container.iterator();
        while (iterator.hasNext()) {
            Any any = (Any)iterator.next();
            int n = any.getSchemaIdentifier();
            if (n == 13 || n == 15 || n == 14) {
                ((List)linkedList).add(any);
                continue;
            }
            if (n == 2) {
                Iterator iterator2 = ((Group)any).elements();
                while (iterator2.hasNext()) {
                    Any any2 = (Any)iterator2.next();
                    ((List)linkedList).add(any2);
                }
                continue;
            }
            if (n != 1 && n != 16) continue;
            ((List)linkedList).add(any);
        }
        return ((List)linkedList).iterator();
    }

    public boolean hasElements() {
        if (this.elementCount > 0) {
            return true;
        }
        return this.getElementCount() > 0;
    }

    protected void serialize0(XmlSerializer xmlSerializer, Schema schema) throws IOException {
        if (this.getMinOccurs() != 1) {
            xmlSerializer.attribute(null, "minOccurs", Integer.toString(this.min));
        }
        if (this.max != 1) {
            if (this.max == -1) {
                xmlSerializer.attribute(null, "maxOccurs", "unbounded");
            } else {
                xmlSerializer.attribute(null, "maxOccurs", Integer.toString(this.max));
            }
        }
        Iterator iterator = this.container.iterator();
        while (iterator.hasNext()) {
            Any any = (Any)iterator.next();
            int n = any.getSchemaIdentifier();
            if (n == 13 || n == 15 || n == 14) {
                ((ElementContainer)any).serialize(xmlSerializer, schema);
                continue;
            }
            if (n == 2) {
                ((Group)any).serialize(xmlSerializer, schema);
                continue;
            }
            if (n == 1) {
                ((Element)any).serialize(xmlSerializer, schema);
                continue;
            }
            if (n != 16) continue;
            ((AnyElement)any).serialize(xmlSerializer, schema);
        }
    }

    public abstract int getContainerType();

    abstract void serialize(XmlSerializer var1, Schema var2) throws IOException;
}

