/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.schema;

import org.ws4d.java.schema.Annotation;
import org.ws4d.java.schema.Attribute;
import org.ws4d.java.schema.AttributeGroup;
import org.ws4d.java.schema.ComplexContent;
import org.ws4d.java.schema.ComplexType;
import org.ws4d.java.schema.Element;
import org.ws4d.java.schema.Group;
import org.ws4d.java.schema.Reference;
import org.ws4d.java.schema.RestrictedSimpleType;
import org.ws4d.java.schema.Schema;
import org.ws4d.java.schema.SimpleContent;
import org.ws4d.java.schema.Type;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.types.QName;
import org.ws4d.java.util.StringUtil;

public abstract class NamedObject
extends Annotation {
    protected QName name = null;
    protected boolean abstractValue = false;
    private Schema parentSchema = null;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(StringUtil.formatClassName(this.getClass()));
        QName qName = this.getName();
        if (qName == null) {
            stringBuffer.append(" [ anonymous ]");
        } else {
            stringBuffer.append(" [ name=").append(qName.getLocalPart());
            stringBuffer.append(", namespace=").append(qName.getNamespace());
            stringBuffer.append(" ]");
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        NamedObject namedObject = (NamedObject)object;
        return !(this.name == null ? namedObject.name != null : !this.name.equals(namedObject.name));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName qName) {
        this.name = qName;
    }

    public boolean isAbstract() {
        return this.abstractValue;
    }

    public void setAbstract(boolean bl) {
        this.abstractValue = bl;
    }

    public void checkNamespace(NamedObject namedObject) {
        QName qName;
        if (namedObject != null && (qName = namedObject.getName()) != null) {
            String string = qName.getNamespace();
            String string2 = qName.getLocalPart();
            String string3 = qName.getPrefix();
            int n = qName.getPriority();
            if ("".equals(string)) {
                string = this.name.getNamespace();
                qName = new QName(string2, string, string3, n);
                namedObject.setName(qName);
                this.checkSubs(namedObject);
            }
        }
    }

    public Schema getParentSchema() {
        return this.parentSchema;
    }

    void setParentSchema(Schema schema) {
        this.parentSchema = schema;
    }

    private void checkSubs(NamedObject namedObject) {
        Iterator iterator = null;
        if (namedObject instanceof Type) {
            NamedObject namedObject2;
            Type type = (Type)namedObject;
            iterator = type.attributes();
            while (iterator.hasNext()) {
                namedObject2 = (Attribute)iterator.next();
                type.checkNamespace(namedObject2);
            }
            iterator = type.attributeGroups();
            while (iterator.hasNext()) {
                namedObject2 = (AttributeGroup)iterator.next();
                type.checkNamespace(namedObject2);
            }
            if (type instanceof ComplexType) {
                NamedObject namedObject3;
                namedObject2 = (ComplexType)type;
                iterator = ((ComplexType)namedObject2).elements();
                while (iterator.hasNext()) {
                    namedObject3 = (Element)iterator.next();
                    namedObject2.checkNamespace(namedObject3);
                }
                if (namedObject2 instanceof ComplexContent) {
                    namedObject3 = (ComplexContent)namedObject2;
                    namedObject3.checkNamespace(((ComplexContent)namedObject3).base);
                }
            } else if (type instanceof RestrictedSimpleType) {
                namedObject2 = (RestrictedSimpleType)type;
                namedObject2.checkNamespace(((RestrictedSimpleType)namedObject2).base);
            } else if (type instanceof SimpleContent) {
                namedObject2 = (SimpleContent)type;
                namedObject2.checkNamespace(((SimpleContent)namedObject2).base);
            }
        } else if (namedObject instanceof Reference) {
            if (namedObject instanceof Element) {
                Element element = (Element)namedObject;
                element.checkNamespace(element.type);
            } else if (namedObject instanceof Attribute) {
                Attribute attribute = (Attribute)namedObject;
                attribute.checkNamespace(attribute.type);
            } else if (namedObject instanceof AttributeGroup) {
                Reference reference;
                AttributeGroup attributeGroup = (AttributeGroup)namedObject;
                iterator = attributeGroup.attributes();
                while (iterator.hasNext()) {
                    reference = (Attribute)iterator.next();
                    attributeGroup.checkNamespace(reference);
                }
                iterator = attributeGroup.attributeGroups();
                while (iterator.hasNext()) {
                    reference = (AttributeGroup)iterator.next();
                    attributeGroup.checkNamespace(reference);
                }
            } else if (namedObject instanceof Group) {
                // empty if block
            }
        }
    }
}

