/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.schema;

import java.io.IOException;
import org.ws4d.java.io.xml.ElementParser;
import org.ws4d.java.schema.AllContainer;
import org.ws4d.java.schema.Annotation;
import org.ws4d.java.schema.Any;
import org.ws4d.java.schema.AnyAttribute;
import org.ws4d.java.schema.Attribute;
import org.ws4d.java.schema.AttributeGroup;
import org.ws4d.java.schema.ChoiceContainer;
import org.ws4d.java.schema.ComplexContent;
import org.ws4d.java.schema.ElementContainer;
import org.ws4d.java.schema.Schema;
import org.ws4d.java.schema.SchemaException;
import org.ws4d.java.schema.SchemaUtil;
import org.ws4d.java.schema.SequenceContainer;
import org.ws4d.java.types.QName;
import org.ws4d.java.util.StringUtil;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class RestrictedComplexContent
extends ComplexContent {
    static final void handleRestriction(ElementParser elementParser, RestrictedComplexContent restrictedComplexContent, String string, Schema schema) throws XmlPullParserException, IOException, SchemaException {
        String string2 = elementParser.getAttributeValue(null, "base");
        if (string2 == null) {
            throw new SchemaException("Cannot restrict given type. No base type set.");
        }
        String string3 = SchemaUtil.getPrefix(string2);
        String string4 = SchemaUtil.getName(string2);
        String string5 = elementParser.getNamespace(string3);
        restrictedComplexContent.setBaseLink(new QName(string4, string5));
        while (elementParser.nextTag() != 3) {
            Any any;
            String string6 = elementParser.getNamespace();
            String string7 = elementParser.getName();
            if (!"http://www.w3.org/2001/XMLSchema".equals(string6)) continue;
            if (StringUtil.equalsIgnoreCase("sequence", string7)) {
                any = new SequenceContainer();
                ElementContainer.handleContainerElements(elementParser, any, string, schema);
                restrictedComplexContent.container = any;
                continue;
            }
            if (StringUtil.equalsIgnoreCase("choice", string7)) {
                any = new ChoiceContainer();
                ElementContainer.handleContainerElements(elementParser, any, string, schema);
                restrictedComplexContent.container = any;
                continue;
            }
            if (StringUtil.equalsIgnoreCase("all", string7)) {
                any = new AllContainer();
                ElementContainer.handleContainerElements(elementParser, any, string, schema);
                restrictedComplexContent.container = any;
                continue;
            }
            if (StringUtil.equalsIgnoreCase("attribute", string7)) {
                any = Attribute.createAttribute(elementParser, string, schema);
                restrictedComplexContent.addAttribute((Attribute)any);
                continue;
            }
            if (StringUtil.equalsIgnoreCase("attributeGroup", string7)) {
                any = AttributeGroup.createAttributeGroup(elementParser, string, schema);
                restrictedComplexContent.addAttributeGroup((AttributeGroup)any);
                continue;
            }
            if (StringUtil.equalsIgnoreCase("anyAttribute", string7)) {
                any = AnyAttribute.createAnyAttribute(elementParser);
                restrictedComplexContent.setAnyAttribute((AnyAttribute)any);
                continue;
            }
            if (!StringUtil.equalsIgnoreCase("annotation", string7)) continue;
            Annotation.handleAnnotation(elementParser, restrictedComplexContent);
        }
        if (restrictedComplexContent.getBaseLink() == null && restrictedComplexContent.getBase() == null) {
            throw new IOException("Cannot restrict given type. No base type set.");
        }
    }

    RestrictedComplexContent() {
    }

    RestrictedComplexContent(QName qName) {
        super(qName);
    }

    public RestrictedComplexContent(String string, String string2, int n) {
        this(new QName(string, string2), n);
    }

    public RestrictedComplexContent(QName qName, int n) {
        super(qName, n);
    }

    public int getSchemaIdentifier() {
        return 10;
    }

    void serialize(XmlSerializer xmlSerializer, Schema schema) throws IOException {
        xmlSerializer.startTag("http://www.w3.org/2001/XMLSchema", "complexType");
        if (this.getName() != null) {
            xmlSerializer.attribute(null, "name", this.getName().getLocalPart());
        }
        xmlSerializer.startTag("http://www.w3.org/2001/XMLSchema", "complexContent");
        xmlSerializer.startTag("http://www.w3.org/2001/XMLSchema", "restriction");
        QName qName = this.base.getName();
        schema.addBaseReference(this.base);
        String string = xmlSerializer.getPrefix(qName.getNamespace(), false);
        if (string != null && !"".equals(string)) {
            qName.setPrefix(string);
            xmlSerializer.attribute(null, "base", qName.getLocalPartPrefixed());
        } else {
            xmlSerializer.attribute(null, "base", qName.getLocalPart());
        }
        this.serializeElements(xmlSerializer, schema);
        this.serializeAttributes(xmlSerializer, schema);
        this.serializeAttributeGroups(xmlSerializer, schema);
        this.serializeAnyAttribute(xmlSerializer, schema);
        xmlSerializer.endTag("http://www.w3.org/2001/XMLSchema", "restriction");
        xmlSerializer.endTag("http://www.w3.org/2001/XMLSchema", "complexContent");
        xmlSerializer.endTag("http://www.w3.org/2001/XMLSchema", "complexType");
    }
}

