/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.security;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;

public class ForcedAliasKeyManager
implements X509KeyManager {
    private X509KeyManager baseKM;
    private String alias;

    public ForcedAliasKeyManager(X509KeyManager x509KeyManager, String string) {
        this.baseKM = x509KeyManager;
        this.alias = string;
    }

    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        boolean bl = false;
        String string = this.alias;
        while (string.length() > 1 && !bl) {
            int n;
            for (n = 0; n < stringArray.length && !bl; ++n) {
                String[] stringArray2 = this.baseKM.getClientAliases(stringArray[n], principalArray);
                if (stringArray2 == null) continue;
                for (int i = 0; i < stringArray2.length && !bl; ++i) {
                    if (!stringArray2[i].toLowerCase().equals(string.toLowerCase())) continue;
                    bl = true;
                }
            }
            n = -1;
            if (!bl) continue;
            n = string.lastIndexOf(47);
            string = n < 0 ? "" : string.substring(n + 1);
        }
        this.alias = string;
        if (bl) {
            return string;
        }
        return null;
    }

    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        return this.baseKM.chooseServerAlias(string, principalArray, socket);
    }

    public X509Certificate[] getCertificateChain(String string) {
        return this.baseKM.getCertificateChain(string);
    }

    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this.baseKM.getClientAliases(string, principalArray);
    }

    public PrivateKey getPrivateKey(String string) {
        return this.baseKM.getPrivateKey(string);
    }

    public String[] getServerAliases(String string, Principal[] principalArray) {
        return this.baseKM.getServerAliases(string, principalArray);
    }
}

