/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.service;

import java.util.NoSuchElementException;
import org.ws4d.java.schema.ComplexType;
import org.ws4d.java.schema.Element;
import org.ws4d.java.schema.ElementContainer;
import org.ws4d.java.schema.Type;
import org.ws4d.java.service.Fault;
import org.ws4d.java.service.OperationDescription;
import org.ws4d.java.service.Service;
import org.ws4d.java.service.parameter.ParameterValue;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.EmptyStructures;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.ReadOnlyIterator;
import org.ws4d.java.structures.Set;
import org.ws4d.java.types.Attributable;
import org.ws4d.java.types.AttributableSupport;
import org.ws4d.java.types.CustomAttributeValue;
import org.ws4d.java.types.QName;
import org.ws4d.java.util.StringUtil;
import org.ws4d.java.util.WS4DIllegalStateException;
import org.ws4d.java.wsdl.IOType;
import org.ws4d.java.wsdl.WSDLMessagePart;
import org.ws4d.java.wsdl.WSDLOperation;

public abstract class OperationCommons
extends AttributableSupport
implements OperationDescription {
    protected int type = -1;
    protected Attributable inputAttributable;
    protected Attributable outputAttributable;
    private final String name;
    private final QName portType;
    private Service service;
    private String inputName;
    private String outputName;
    private String inputAction;
    private String outputAction;
    private final HashMap faults = new HashMap();
    private Set customComplexTypes = null;
    private boolean managedInput = true;
    private boolean managedOutput = true;
    private Element input = null;
    private Element output = null;
    private boolean inputNameSet = false;
    private boolean outputNameSet = false;
    private boolean inputActionSet = false;
    private boolean outputActionSet = false;
    private boolean inputActionExtended = false;
    private boolean outputActionExtended = false;

    protected OperationCommons(String string, QName qName) {
        this.name = string == null ? StringUtil.simpleClassName(this.getClass()) : string;
        this.portType = qName == null ? new QName(StringUtil.simpleClassName(this.getClass()), null) : qName;
    }

    protected OperationCommons(WSDLOperation wSDLOperation) {
        this(wSDLOperation.getName(), wSDLOperation.getPortType().getName());
        Object object;
        Object object2;
        Object object3;
        DataStructure dataStructure;
        int n;
        IOType iOType;
        IOType iOType2;
        this.setType(wSDLOperation.getType());
        this.setInputName(wSDLOperation.getInputName());
        this.setOutputName(wSDLOperation.getOutputName());
        this.setInputAction(wSDLOperation.getInputAction());
        this.setOutputAction(wSDLOperation.getOutputAction());
        if (wSDLOperation.hasAttributes()) {
            this.setAttributes(wSDLOperation.getAttributes());
        }
        if ((iOType2 = wSDLOperation.getInput()) != null && iOType2.hasAttributes()) {
            this.setInputAttributes(iOType2.getAttributes());
        }
        if ((iOType = wSDLOperation.getOutput()) != null && iOType.hasAttributes()) {
            this.setOutputAttributes(iOType.getAttributes());
        }
        if ((n = (dataStructure = wSDLOperation.getInputParts()).size()) > 1) {
            throw new IllegalArgumentException("Unsupported WSDL feature (input message with more than one parts ): " + wSDLOperation.getInputMessage());
        }
        if (n == 1) {
            object3 = (WSDLMessagePart)dataStructure.iterator().next();
            if (((WSDLMessagePart)object3).isElement()) {
                this.setInput(((WSDLMessagePart)object3).getElement());
            } else {
                object2 = new Element(this.getInputName(), this.getPortType().getNamespace(), ((WSDLMessagePart)object3).getType());
                this.setInput((Element)object2);
            }
        }
        if ((n = ((DataStructure)(object3 = wSDLOperation.getOutputParts())).size()) > 1) {
            throw new IllegalArgumentException("Unsupported WSDL feature (output message with more than one parts): " + wSDLOperation.getInputMessage());
        }
        if (n == 1) {
            object2 = (WSDLMessagePart)((DataStructure)object3).iterator().next();
            if (((WSDLMessagePart)object2).isElement()) {
                this.setOutput(((WSDLMessagePart)object2).getElement());
            } else {
                object = new Element(this.getOutputName(), this.getPortType().getNamespace(), ((WSDLMessagePart)object2).getType());
                this.setInput((Element)object);
            }
        }
        object2 = wSDLOperation.getFaults();
        object = ((DataStructure)object2).iterator();
        while (object.hasNext()) {
            IOType iOType3 = (IOType)object.next();
            Fault fault = new Fault(iOType3);
            if (iOType3.hasAttributes()) {
                fault.setAttributes(iOType3.getAttributes());
            }
            this.addFault(fault);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append(" [ name=").append(this.getName());
        stringBuffer.append(", portType=").append(this.getPortType());
        stringBuffer.append(", type=").append(WSDLOperation.typeToString(this.getType()));
        stringBuffer.append(", inputName=").append(this.getInputName());
        stringBuffer.append(", outputName=").append(this.getOutputName());
        stringBuffer.append(", inputAction=").append(this.getInputAction());
        stringBuffer.append(", outputAction=").append(this.getOutputAction());
        stringBuffer.append(", input=").append(this.getInput());
        stringBuffer.append(", output=").append(this.getOutput());
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OperationCommons operationCommons = (OperationCommons)object;
        if (!this.name.equals(operationCommons.name)) {
            return false;
        }
        if (this.portType == null ? operationCommons.portType != null : !this.portType.equals(operationCommons.portType)) {
            return false;
        }
        if (this.inputName == null ? operationCommons.inputName != null : !this.inputName.equals(operationCommons.inputName)) {
            return false;
        }
        return !(this.outputName == null ? operationCommons.outputName != null : !this.outputName.equals(operationCommons.outputName));
    }

    public final int hashCode() {
        int n = 1;
        n = 31 * n + this.name.hashCode();
        n = 31 * n + (this.portType == null ? 0 : this.portType.hashCode());
        n = 31 * n + (this.inputName == null ? 0 : this.inputName.hashCode());
        n = 31 * n + (this.outputName == null ? 0 : this.outputName.hashCode());
        return n;
    }

    public String getName() {
        return this.name;
    }

    public QName getPortType() {
        return this.portType;
    }

    public abstract int getType();

    public String getInputName() {
        if (this.getType() == 4) {
            return null;
        }
        if (this.inputName == null) {
            this.inputName = this.generateDefaultInputName();
            this.inputNameSet = false;
        }
        return this.inputName;
    }

    public void setInputName(String string) {
        this.checkModifiable();
        this.setInputNameInternal(string);
        if (string != null) {
            this.inputNameSet = true;
        }
    }

    public String getInputAction() {
        if (this.getType() == 4) {
            return null;
        }
        if (this.inputAction == null) {
            this.inputAction = this.generateDefaultAction(true);
            this.inputActionSet = false;
            this.inputActionExtended = false;
        }
        return this.inputAction;
    }

    public void setInputAction(String string) {
        this.checkModifiable();
        this.inputAction = string;
        if (string != null) {
            this.inputActionSet = true;
            this.inputActionExtended = false;
        }
    }

    public String getOutputName() {
        if (this.getType() == 1) {
            return null;
        }
        if (this.outputName == null) {
            this.outputName = this.generateDefaultOutputName();
            this.outputNameSet = false;
        }
        return this.outputName;
    }

    public void setOutputName(String string) {
        this.checkModifiable();
        this.setOutputNameInternal(string);
        if (string != null) {
            this.outputNameSet = true;
        }
    }

    public String getOutputAction() {
        if (this.getType() == 1) {
            return null;
        }
        if (this.outputAction == null) {
            this.outputAction = this.generateDefaultAction(false);
            this.outputActionSet = false;
            this.outputActionExtended = false;
        }
        return this.outputAction;
    }

    public void setOutputAction(String string) {
        this.checkModifiable();
        this.outputAction = string;
        if (string != null) {
            this.outputActionSet = true;
            this.outputActionExtended = false;
        }
    }

    public Element getInput() {
        return this.input;
    }

    public Element getInputParameter(String string) {
        if (!this.managedInput) {
            throw new WS4DIllegalStateException("unable to retrieve input parameter when input is set explicitly via setInput(Element)");
        }
        if (this.input == null) {
            return null;
        }
        ComplexType complexType = (ComplexType)this.input.getType();
        ElementContainer elementContainer = complexType.getContainer();
        return elementContainer.getLocalElementByName(new QName(string, this.getPortType().getNamespace()));
    }

    public void setInput(Element element) {
        this.checkModifiable();
        this.checkNamespace(element);
        this.input = element;
        this.managedInput = false;
        this.resetType();
    }

    public void addInputParameter(String string, Type type) {
        ComplexType complexType;
        this.checkModifiable();
        if (!this.managedInput) {
            throw new WS4DIllegalStateException("unable to add input parameter when input is set explicitly via setInput(Element)");
        }
        if (this.input == null) {
            complexType = new ComplexType(1);
            this.input = new Element(new QName(this.getName(), this.getPortType().getNamespace()), (Type)complexType);
            this.resetType();
        } else {
            complexType = (ComplexType)this.input.getType();
        }
        ElementContainer elementContainer = complexType.getContainer();
        elementContainer.addElement(new Element(new QName(string, this.getPortType().getNamespace()), type));
        this.managedInput = true;
    }

    public Element getOutput() {
        return this.output;
    }

    public Element getOutputParameter(String string) {
        if (!this.managedOutput) {
            throw new WS4DIllegalStateException("unable to retrieve output parameter when output is set explicitly via setOutput(Element)");
        }
        if (this.output == null) {
            return null;
        }
        ComplexType complexType = (ComplexType)this.output.getType();
        ElementContainer elementContainer = complexType.getContainer();
        return elementContainer.getLocalElementByName(new QName(string, this.getPortType().getNamespace()));
    }

    public void setOutput(Element element) {
        this.checkModifiable();
        this.checkNamespace(element);
        this.output = element;
        this.managedOutput = false;
        this.resetType();
    }

    public void addOutputParameter(String string, Type type) {
        ComplexType complexType;
        this.checkModifiable();
        if (!this.managedOutput) {
            throw new WS4DIllegalStateException("unable to add output parameter when output is set explicitly via setOutput(Element)");
        }
        if (this.output == null) {
            complexType = new ComplexType(1);
            this.output = new Element(new QName(this.getName() + "Response", this.getPortType().getNamespace()), (Type)complexType);
            this.resetType();
        } else {
            complexType = (ComplexType)this.output.getType();
        }
        ElementContainer elementContainer = complexType.getContainer();
        elementContainer.addElement(new Element(new QName(string, this.getPortType().getNamespace()), type));
        this.managedOutput = true;
    }

    public Iterator getFaults() {
        return new ReadOnlyIterator(this.faults.values());
    }

    public int getFaultCount() {
        return this.faults.size();
    }

    public Fault getFault(String string) {
        return (Fault)this.faults.get(string);
    }

    public void addFault(Fault fault) {
        this.checkModifiable();
        if (fault == null) {
            throw new NullPointerException("fault is null");
        }
        String string = fault.getName();
        if (this.faults.containsKey(string)) {
            throw new IllegalArgumentException("duplicate fault name: " + string);
        }
        if (fault.getAction() == null) {
            fault.setAction(this.generateDefaultFaultAction(string));
        }
        this.faults.put(fault.getName(), fault);
        fault.attached = true;
        this.checkNamespace(fault.getElement());
        this.resetType();
    }

    public void removeFault(String string) {
        this.checkModifiable();
        Fault fault = (Fault)this.faults.remove(string);
        if (fault != null) {
            fault.attached = false;
        }
        if (this.getFaultCount() == 0) {
            this.resetType();
        }
    }

    public ParameterValue createOutputValue() {
        return ParameterValue.createElementValue(this.getOutput());
    }

    public ParameterValue createInputValue() {
        return ParameterValue.createElementValue(this.getInput());
    }

    public ParameterValue createFaultValue(String string) {
        Fault fault = this.getFault(string);
        if (fault == null) {
            throw new NoSuchElementException("unknown fault: " + string);
        }
        return fault.createValue();
    }

    public Service getService() {
        return this.service;
    }

    public CustomAttributeValue getInputAttribute(QName qName) {
        return this.inputAttributable == null ? null : this.inputAttributable.getAttribute(qName);
    }

    public void setInputAttribute(QName qName, CustomAttributeValue customAttributeValue) {
        if (this.inputAttributable == null) {
            this.inputAttributable = new AttributableSupport();
        }
        this.inputAttributable.setAttribute(qName, customAttributeValue);
    }

    public HashMap getInputAttributes() {
        if (this.inputAttributable == null) {
            this.inputAttributable = new AttributableSupport();
        }
        return this.inputAttributable.getAttributes();
    }

    public void setInputAttributes(HashMap hashMap) {
        if (this.inputAttributable == null) {
            this.inputAttributable = new AttributableSupport();
        }
        this.inputAttributable.setAttributes(hashMap);
    }

    public boolean hasInputAttributes() {
        return this.inputAttributable != null && this.inputAttributable.hasAttributes();
    }

    public CustomAttributeValue getOutputAttribute(QName qName) {
        return this.outputAttributable == null ? null : this.outputAttributable.getAttribute(qName);
    }

    public void setOutputAttribute(QName qName, CustomAttributeValue customAttributeValue) {
        if (this.outputAttributable == null) {
            this.outputAttributable = new AttributableSupport();
        }
        this.outputAttributable.setAttribute(qName, customAttributeValue);
    }

    public HashMap getOutputAttributes() {
        if (this.outputAttributable == null) {
            this.outputAttributable = new AttributableSupport();
        }
        return this.outputAttributable.getAttributes();
    }

    public void setOutputAttributes(HashMap hashMap) {
        if (this.outputAttributable == null) {
            this.outputAttributable = new AttributableSupport();
        }
        this.outputAttributable.setAttributes(hashMap);
    }

    public boolean hasOutputAttributes() {
        return this.outputAttributable != null && this.outputAttributable.hasAttributes();
    }

    public CustomAttributeValue getFaultAttribute(String string, QName qName) {
        Fault fault = this.getFault(string);
        if (fault == null) {
            throw new IllegalArgumentException("no such fault: " + string);
        }
        return fault.getAttribute(qName);
    }

    public void setFaultAttribute(String string, QName qName, CustomAttributeValue customAttributeValue) {
        Fault fault = this.getFault(string);
        if (fault == null) {
            throw new IllegalArgumentException("no such fault: " + string);
        }
        fault.setAttribute(qName, customAttributeValue);
    }

    public HashMap getFaultAttributes(String string) {
        Fault fault = this.getFault(string);
        if (fault == null) {
            throw new IllegalArgumentException("no such fault: " + string);
        }
        return fault.getAttributes();
    }

    public void setFaultAttributes(String string, HashMap hashMap) {
        Fault fault = this.getFault(string);
        if (fault == null) {
            throw new IllegalArgumentException("no such fault: " + string);
        }
        fault.setAttributes(hashMap);
    }

    public boolean hasFaultAttributes(String string) {
        Fault fault = this.getFault(string);
        return fault != null && fault.hasAttributes();
    }

    public void setService(Service service) {
        this.service = service;
    }

    public void setInputNameInternal(String string) {
        this.inputName = string;
        if (!this.inputActionSet) {
            this.inputAction = null;
        }
    }

    public void setOutputNameInternal(String string) {
        this.outputName = string;
        if (!this.outputActionSet) {
            this.outputAction = null;
        }
    }

    public String setExtendedDefaultInputAction() {
        int n = this.getType();
        if (n == -1) {
            return null;
        }
        String string = "/";
        if (this.portType.getNamespace().startsWith("urn")) {
            string = ":";
        }
        this.inputActionExtended = true;
        this.inputAction = this.buildActionName(this.getInputName() + string + this.getOutputName(), string);
        return this.inputAction;
    }

    public String setExtendedDefaultOutputAction() {
        int n = this.getType();
        if (n == -1) {
            return null;
        }
        String string = "/";
        if (this.portType.getNamespace().startsWith("urn")) {
            string = ":";
        }
        this.outputActionExtended = true;
        this.outputAction = this.buildActionName(this.getOutputName() + string + this.getInputName(), string);
        return this.outputAction;
    }

    public boolean isInputNameSet() {
        return this.inputNameSet;
    }

    public boolean isInputActionSet() {
        return this.inputActionSet;
    }

    public boolean isOutputNameSet() {
        return this.outputNameSet;
    }

    public boolean isOutputActionSet() {
        return this.outputActionSet;
    }

    public boolean isInputActionExtended() {
        return this.inputActionExtended;
    }

    public boolean isOutputActionExtended() {
        return this.outputActionExtended;
    }

    public synchronized void addCustomComplexType(ComplexType complexType) {
        if (complexType.getName() == null) {
            throw new RuntimeException("Cannot add custom complex type with out name to the operation.");
        }
        if (this.customComplexTypes == null) {
            this.customComplexTypes = new HashSet();
        }
        this.customComplexTypes.add(complexType);
    }

    public synchronized void removeCustomComplexType(ComplexType complexType) {
        if (this.customComplexTypes == null) {
            return;
        }
        this.customComplexTypes.remove(complexType);
    }

    public synchronized void clearCustomComplexTypes() {
        if (this.customComplexTypes == null) {
            return;
        }
        this.customComplexTypes = null;
    }

    public synchronized Iterator getCustomComplexTypes() {
        if (this.customComplexTypes == null) {
            return EmptyStructures.EMPTY_ITERATOR;
        }
        return this.customComplexTypes.iterator();
    }

    private void setType(int n) {
        this.checkModifiable();
        this.type = n;
    }

    private void checkModifiable() {
        if (this.service != null) {
            throw new WS4DIllegalStateException("unable to modify after being added to service");
        }
    }

    private void checkNamespace(Element element) {
        QName qName;
        if (element != null && (qName = element.getName()) != null) {
            String string = qName.getNamespace();
            String string2 = qName.getLocalPart();
            String string3 = qName.getPrefix();
            int n = qName.getPriority();
            if ("".equals(string)) {
                string = this.portType == null ? this.generateDefaultNamespace() : this.getPortType().getNamespace();
                qName = new QName(string2, string, string3, n);
                element.setName(qName);
                element.checkNamespace(element.getType());
            }
        }
    }

    private String generateDefaultNamespace() {
        return "http://www.ws4d.org";
    }

    private String generateDefaultInputName() {
        return this.generateDefaultName(true);
    }

    private String generateDefaultOutputName() {
        return this.generateDefaultName(false);
    }

    private String generateDefaultName(boolean bl) {
        String string = this.getName();
        switch (this.getType()) {
            case 1: {
                if (!bl) break;
                return string;
            }
            case 4: {
                if (bl) break;
                return string;
            }
            case 2: {
                if (bl) {
                    return string + "";
                }
                if (bl) break;
                return string + "Response";
            }
            case 3: {
                if (!bl) {
                    return string + "Solicit";
                }
                if (!bl) break;
                return string + "Response";
            }
        }
        return null;
    }

    private String generateDefaultAction(boolean bl) {
        int n = this.getType();
        if (n == -1) {
            return null;
        }
        String string = "/";
        if (this.portType.getNamespace().startsWith("urn")) {
            string = ":";
        }
        switch (n) {
            case 1: {
                return this.buildActionName(this.getInputName(), string);
            }
            case 2: {
                if (bl) {
                    return this.buildActionName(this.getInputName(), string);
                }
                return this.buildActionName(this.getOutputName(), string);
            }
            case 3: {
                if (bl) {
                    return this.buildActionName(this.getInputName(), string);
                }
                return this.buildActionName(this.getOutputName(), string);
            }
            case 4: {
                return this.buildActionName(this.getOutputName(), string);
            }
        }
        return null;
    }

    private String buildActionName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = this.portType.getNamespace();
        stringBuffer.append(string3);
        if (!string3.endsWith(string2)) {
            stringBuffer.append(string2);
        }
        stringBuffer.append(this.portType.getLocalPart());
        stringBuffer.append(string2);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private String generateDefaultFaultAction(String string) {
        String string2 = "/";
        String string3 = this.portType.getNamespace();
        if (string3.startsWith("urn")) {
            string2 = ":";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string3);
        if (!string3.endsWith(string2)) {
            stringBuffer.append(string2);
        }
        stringBuffer.append(this.portType.getLocalPart());
        stringBuffer.append(string2);
        stringBuffer.append(this.getName());
        stringBuffer.append(string2);
        stringBuffer.append("Fault");
        stringBuffer.append(string2);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private void resetType() {
        this.type = -1;
    }
}

