/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.service;

import java.io.IOException;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.eventing.EventSource;
import org.ws4d.java.eventing.EventingFactory;
import org.ws4d.java.service.Operation;
import org.ws4d.java.service.OperationCommons;
import org.ws4d.java.service.OperationDescription;
import org.ws4d.java.service.Service;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.EmptyStructures;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.ReadOnlyIterator;
import org.ws4d.java.types.AttributableSupport;
import org.ws4d.java.types.CustomAttributeValue;
import org.ws4d.java.types.EprInfo;
import org.ws4d.java.types.QName;
import org.ws4d.java.util.Log;
import org.ws4d.java.wsdl.WSDL;
import org.ws4d.java.wsdl.WSDLOperation;
import org.ws4d.java.wsdl.WSDLPortType;

public abstract class ServiceCommons
implements Service {
    final HashMap portTypes = new HashMap();
    final HashMap operations = new HashMap();
    final HashMap events = new HashMap();
    protected final HashMap wsdls = new HashMap();
    protected boolean secure = false;
    protected Object certificate;
    protected Object privateKey;

    ServiceCommons() {
    }

    protected HashMap getPortTypesInternal() {
        return this.portTypes;
    }

    protected HashMap getOperationsInternal() {
        return this.operations;
    }

    protected HashMap getEventsInternal() {
        return this.events;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append(" [ serviceId=").append(this.getServiceId());
        Iterator iterator = this.getEprInfos();
        if (iterator.hasNext()) {
            stringBuffer.append(", endpointReferences={ ");
            while (iterator.hasNext()) {
                stringBuffer.append(((EprInfo)iterator.next()).getEndpointReference()).append(' ');
            }
            stringBuffer.append('}');
        }
        if ((iterator = this.getPortTypes()).hasNext()) {
            stringBuffer.append(", portTypes={ ");
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next()).append(' ');
            }
            stringBuffer.append('}');
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public Iterator getOperations() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.portTypes.values().iterator();
        while (iterator.hasNext()) {
            PortType portType = (PortType)iterator.next();
            Iterator iterator2 = portType.getOperations();
            while (iterator2.hasNext()) {
                ((DataStructure)hashSet).add(iterator2.next());
            }
        }
        return new ReadOnlyIterator(hashSet);
    }

    public Iterator getOperations(QName qName) {
        PortType portType = (PortType)this.portTypes.get(qName);
        return portType == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(portType.getOperations());
    }

    public Operation getOperation(QName qName, String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        PortType portType = (PortType)this.portTypes.get(qName);
        return portType == null ? null : portType.getOperation(string, string2, string3);
    }

    public Operation getOperation(String string) {
        return (Operation)this.operations.get(string);
    }

    public Operation getAnyOperation(QName qName, String string) {
        if (string == null) {
            return null;
        }
        Iterator iterator = this.getOperations(qName);
        while (iterator.hasNext()) {
            Operation operation = (Operation)iterator.next();
            if (!string.equals(operation.getName())) continue;
            return operation;
        }
        return null;
    }

    public Iterator getEventSources() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.portTypes.values().iterator();
        while (iterator.hasNext()) {
            PortType portType = (PortType)iterator.next();
            Iterator iterator2 = portType.getEventSources();
            while (iterator2.hasNext()) {
                ((DataStructure)hashSet).add(iterator2.next());
            }
        }
        return new ReadOnlyIterator(hashSet);
    }

    public Iterator getEventSources(QName qName) {
        PortType portType = (PortType)this.portTypes.get(qName);
        return portType == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(portType.getEventSources());
    }

    public EventSource getEventSource(QName qName, String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        PortType portType = (PortType)this.portTypes.get(qName);
        return portType == null ? null : portType.getEventSource(string, string2, string3);
    }

    public EventSource getEventSource(String string) {
        return (EventSource)this.events.get(string);
    }

    public EventSource getAnyEventSource(QName qName, String string) {
        if (string == null) {
            return null;
        }
        Iterator iterator = this.getEventSources(qName);
        while (iterator.hasNext()) {
            EventSource eventSource = (EventSource)iterator.next();
            if (!string.equals(eventSource.getName())) continue;
            return eventSource;
        }
        return null;
    }

    public CustomAttributeValue getPortTypeAttribute(QName qName, QName qName2) {
        PortType portType = (PortType)this.portTypes.get(qName);
        if (portType == null) {
            throw new IllegalArgumentException("no such port type: " + qName);
        }
        return portType.getAttribute(qName2);
    }

    public void setPortTypeAttribute(QName qName, QName qName2, CustomAttributeValue customAttributeValue) {
        PortType portType = (PortType)this.portTypes.get(qName);
        if (portType == null) {
            throw new IllegalArgumentException("no such port type: " + qName);
        }
        portType.setAttribute(qName2, customAttributeValue);
    }

    public HashMap getPortTypeAttributes(QName qName) {
        PortType portType = (PortType)this.portTypes.get(qName);
        if (portType == null) {
            throw new IllegalArgumentException("no such port type: " + qName);
        }
        return portType.getAttributes();
    }

    public void setPortTypeAttributes(QName qName, HashMap hashMap) {
        PortType portType = (PortType)this.portTypes.get(qName);
        if (portType == null) {
            throw new IllegalArgumentException("no such port type: " + qName);
        }
        portType.setAttributes(hashMap);
    }

    public boolean hasPortTypeAttributes(QName qName) {
        PortType portType = (PortType)this.portTypes.get(qName);
        return portType != null && portType.hasAttributes();
    }

    public void setSecureService() throws Exception {
        if (!DPWSFramework.hasModule(64)) {
            throw new RuntimeException("You are running the DPWS Framework without the required Security-Module");
        }
        this.secure = true;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public void setCertificate(Object object) {
        if (object == null) {
            return;
        }
        this.certificate = object;
        this.setSecure(true);
    }

    public Object getCertificate() {
        return this.certificate;
    }

    public Object getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(Object object) {
        this.privateKey = object;
    }

    protected void processWSDLPortType(WSDLPortType wSDLPortType) {
        QName qName = wSDLPortType.getName();
        if (this.portTypes.containsKey(qName)) {
            return;
        }
        PortType portType = new PortType();
        if (wSDLPortType.hasAttributes()) {
            portType.setAttributes(wSDLPortType.getAttributes());
        }
        DataStructure dataStructure = wSDLPortType.getOperations();
        Iterator iterator = dataStructure.iterator();
        while (iterator.hasNext()) {
            OperationCommons operationCommons;
            OperationDescription operationDescription;
            WSDLOperation wSDLOperation = (WSDLOperation)iterator.next();
            if (wSDLOperation.isRequest()) {
                operationDescription = this.createOperation(wSDLOperation);
                operationCommons = operationDescription;
                portType.addOperation(new OperationSignature(operationCommons), (Operation)operationDescription);
                this.operations.put(((OperationCommons)operationDescription).getInputAction(), operationDescription);
                if (Log.isDebug()) {
                    Log.debug("[NEW OPERATION]: " + ((OperationCommons)operationDescription).toString(), 2);
                }
            } else if (wSDLOperation.isEvented()) {
                operationDescription = this.createEventSource(wSDLOperation);
                if (operationDescription == null || !(operationDescription instanceof OperationCommons)) {
                    Log.error("Cannot create event source from " + wSDLOperation + ". Event does not exist, or is not a extension of operation.");
                    continue;
                }
                operationCommons = (OperationCommons)operationDescription;
                portType.addEventSource(new OperationSignature(operationCommons), (EventSource)operationDescription);
                this.events.put(operationDescription.getOutputAction(), operationDescription);
                if (Log.isDebug()) {
                    Log.debug("[NEW EVENT SOURCE]: " + operationDescription.toString(), 2);
                }
            } else {
                throw new IllegalArgumentException("Unknown type of WSDL operation: " + wSDLOperation);
            }
            operationCommons.setService(this);
        }
        this.portTypes.put(qName, portType);
    }

    protected abstract Operation createOperation(WSDLOperation var1);

    protected EventSource createEventSource(WSDLOperation wSDLOperation) {
        if (DPWSFramework.hasModule(4)) {
            try {
                EventingFactory eventingFactory = DPWSFramework.getEventingFactory();
                return eventingFactory.createDefaultEventSource(wSDLOperation);
            }
            catch (IOException iOException) {
                Log.error("Cannot create event source from " + wSDLOperation + ". " + iOException.getMessage());
            }
        } else {
            Log.error("Cannot create event source, event support missing.");
        }
        return null;
    }

    public Iterator getDescriptions() {
        return new ReadOnlyIterator(this.wsdls.values().iterator());
    }

    protected WSDL getExistingDescription(String string) {
        if (this.wsdls.size() > 0) {
            WSDL wSDL = (WSDL)this.wsdls.get(string);
            if (wSDL != null) {
                return wSDL;
            }
            Iterator iterator = this.wsdls.values().iterator();
            while (iterator.hasNext()) {
                wSDL = (WSDL)iterator.next();
                WSDL wSDL2 = wSDL.getLinkedWsdlRecursive(string);
                if (wSDL2 == null) continue;
                return wSDL2;
            }
        }
        return null;
    }

    public static class OperationSignature {
        private final String name;
        private final String inputName;
        private final String outputName;

        public OperationSignature(OperationDescription operationDescription) {
            this(operationDescription.getName(), operationDescription.getInputName(), operationDescription.getOutputName());
        }

        public OperationSignature(String string, String string2, String string3) {
            this.name = string;
            this.inputName = string2;
            this.outputName = string3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            OperationSignature operationSignature = (OperationSignature)object;
            if (!this.name.equals(operationSignature.name)) {
                return false;
            }
            if (this.inputName == null ? operationSignature.inputName != null : !this.inputName.equals(operationSignature.inputName)) {
                return false;
            }
            return !(this.outputName == null ? operationSignature.outputName != null : !this.outputName.equals(operationSignature.outputName));
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.name.hashCode();
            n = 31 * n + (this.inputName == null ? 0 : this.inputName.hashCode());
            n = 31 * n + (this.outputName == null ? 0 : this.outputName.hashCode());
            return n;
        }
    }

    public static class PortType
    extends AttributableSupport {
        protected final HashMap operations = new HashMap();
        protected final HashMap events = new HashMap();
        protected boolean plombed;

        public boolean contains(OperationSignature operationSignature) {
            return this.operations.containsKey(operationSignature) || this.events.containsKey(operationSignature);
        }

        public boolean hasOperations() {
            return this.operations.size() != 0;
        }

        public Iterator getOperations() {
            return this.operations.values().iterator();
        }

        public Operation getOperation(String string, String string2, String string3) {
            return (Operation)this.operations.get(new OperationSignature(string, string2, string3));
        }

        public void addOperation(OperationSignature operationSignature, Operation operation) {
            this.operations.put(operationSignature, operation);
        }

        public boolean hasEventSources() {
            return this.events.size() != 0;
        }

        public Iterator getEventSources() {
            return this.events.values().iterator();
        }

        public EventSource getEventSource(String string, String string2, String string3) {
            return (EventSource)this.events.get(new OperationSignature(string, string2, string3));
        }

        public void addEventSource(OperationSignature operationSignature, EventSource eventSource) {
            this.events.put(operationSignature, eventSource);
        }

        public boolean isPlombed() {
            return this.plombed;
        }

        protected void plomb() {
            this.plombed = true;
        }
    }
}

