/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.structures;

import org.ws4d.java.concurrency.LockSupport;
import org.ws4d.java.concurrency.Lockable;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.List;
import org.ws4d.java.structures.ListIterator;

public class LockedList
extends List
implements Lockable {
    private Lockable lock;
    private List listToSynchronize;

    public LockedList() {
        this(new ArrayList());
    }

    public LockedList(List list) {
        this(list, new LockSupport());
    }

    public LockedList(List list, Lockable lockable) {
        this.lock = lockable;
        this.listToSynchronize = list;
    }

    public void sharedLock() {
        this.lock.sharedLock();
    }

    public void exclusiveLock() {
        this.lock.exclusiveLock();
    }

    public void releaseSharedLock() {
        this.lock.releaseSharedLock();
    }

    public boolean releaseExclusiveLock() {
        return this.lock.releaseExclusiveLock();
    }

    public boolean tryExclusiveLock() {
        return this.lock.tryExclusiveLock();
    }

    public boolean trySharedLock() {
        return this.lock.trySharedLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int n, Object object) {
        try {
            this.lock.exclusiveLock();
            this.listToSynchronize.add(n, object);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int n, DataStructure dataStructure) {
        try {
            this.lock.exclusiveLock();
            boolean bl = this.listToSynchronize.addAll(n, dataStructure);
            return bl;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int n) {
        try {
            this.lock.sharedLock();
            Object object = this.listToSynchronize.get(n);
            return object;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object object) {
        try {
            this.lock.sharedLock();
            int n = this.listToSynchronize.indexOf(object);
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(Object object) {
        try {
            this.lock.sharedLock();
            int n = this.listToSynchronize.lastIndexOf(object);
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterator listIterator() {
        try {
            this.lock.sharedLock();
            ListIterator listIterator = this.listToSynchronize.listIterator();
            return listIterator;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterator listIterator(int n) {
        try {
            this.lock.sharedLock();
            ListIterator listIterator = this.listToSynchronize.listIterator(n);
            return listIterator;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int n) {
        try {
            this.lock.exclusiveLock();
            Object object = this.listToSynchronize.remove(n);
            return object;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int n, Object object) {
        try {
            this.lock.exclusiveLock();
            Object object2 = this.listToSynchronize.set(n, object);
            return object2;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List subList(int n, int n2) {
        try {
            this.lock.sharedLock();
            List list = this.listToSynchronize.subList(n, n2);
            return list;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public Iterator iterator() {
        return this.listToSynchronize.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock.sharedLock();
        try {
            int n = this.listToSynchronize.size();
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        this.lock.sharedLock();
        try {
            boolean bl = this.listToSynchronize.contains(object);
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object object) {
        this.lock.exclusiveLock();
        try {
            boolean bl = this.listToSynchronize.remove(object);
            return bl;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.exclusiveLock();
        try {
            this.listToSynchronize.clear();
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object object) {
        this.lock.exclusiveLock();
        try {
            boolean bl = this.listToSynchronize.add(object);
            return bl;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(DataStructure dataStructure) {
        this.lock.exclusiveLock();
        try {
            boolean bl = this.listToSynchronize.addAll(dataStructure);
            return bl;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(DataStructure dataStructure) {
        this.lock.sharedLock();
        try {
            boolean bl = this.listToSynchronize.containsAll(dataStructure);
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.lock.sharedLock();
        try {
            boolean bl = this.listToSynchronize.isEmpty();
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        this.lock.sharedLock();
        try {
            Object[] objectArray = this.listToSynchronize.toArray();
            return objectArray;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] objectArray) {
        this.lock.sharedLock();
        try {
            Object[] objectArray2 = this.listToSynchronize.toArray(objectArray);
            return objectArray2;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        this.lock.sharedLock();
        try {
            int n = this.listToSynchronize.hashCode();
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        this.lock.sharedLock();
        try {
            boolean bl = this.listToSynchronize.equals(object);
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.sharedLock();
        try {
            String string = this.listToSynchronize.toString();
            return string;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }
}

