/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.structures;

import org.ws4d.java.concurrency.LockSupport;
import org.ws4d.java.concurrency.Lockable;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.LockedSet;
import org.ws4d.java.structures.LockedStructure;
import org.ws4d.java.structures.Set;

public class LockedMap
extends HashMap
implements Lockable {
    private HashMap mapToSynchronize;
    private LockSupport lock;

    public LockedMap() {
        this(new HashMap());
    }

    public LockedMap(HashMap hashMap) {
        this.mapToSynchronize = hashMap;
        this.lock = new LockSupport();
    }

    public void sharedLock() {
        this.lock.sharedLock();
    }

    public void exclusiveLock() {
        this.lock.exclusiveLock();
    }

    public void releaseSharedLock() {
        this.lock.releaseSharedLock();
    }

    public boolean releaseExclusiveLock() {
        return this.lock.releaseExclusiveLock();
    }

    public boolean tryExclusiveLock() {
        return this.lock.tryExclusiveLock();
    }

    public boolean trySharedLock() {
        return this.lock.trySharedLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.exclusiveLock();
        try {
            this.mapToSynchronize.clear();
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object object) {
        this.lock.sharedLock();
        try {
            boolean bl = this.mapToSynchronize.containsKey(object);
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object object) {
        this.lock.sharedLock();
        try {
            boolean bl = this.mapToSynchronize.containsKey(object);
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        this.lock.exclusiveLock();
        try {
            if (this.entrySet == null) {
                this.entrySet = new LockedSet(this.mapToSynchronize.entrySet(), this.lock);
            }
            Set set = this.entrySet;
            return set;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        this.lock.sharedLock();
        try {
            Object object2 = this.mapToSynchronize.get(object);
            return object2;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.lock.sharedLock();
        try {
            boolean bl = this.mapToSynchronize.isEmpty();
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        this.lock.exclusiveLock();
        try {
            Object object3 = this.mapToSynchronize.put(object, object2);
            return object3;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(HashMap hashMap) {
        this.lock.exclusiveLock();
        try {
            this.mapToSynchronize.putAll(hashMap);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object) {
        this.lock.exclusiveLock();
        try {
            Object object2 = this.mapToSynchronize.remove(object);
            return object2;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock.sharedLock();
        try {
            int n = this.mapToSynchronize.size();
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStructure values() {
        this.lock.exclusiveLock();
        try {
            if (this.values == null) {
                this.values = new LockedStructure(this.mapToSynchronize.values(), this.lock);
            }
            DataStructure dataStructure = this.values;
            return dataStructure;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        this.lock.exclusiveLock();
        try {
            if (this.keySet == null) {
                this.keySet = new LockedSet(this.mapToSynchronize.keySet(), this.lock);
            }
            Set set = this.keySet;
            return set;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        this.lock.sharedLock();
        try {
            int n = this.mapToSynchronize.hashCode();
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        this.lock.sharedLock();
        try {
            boolean bl = this.mapToSynchronize.equals(object);
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.sharedLock();
        try {
            String string = this.mapToSynchronize.toString();
            return string;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }
}

