/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.structures;

import org.ws4d.java.concurrency.LockSupport;
import org.ws4d.java.concurrency.Lockable;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.Set;

public class LockedSet
extends Set {
    private Set lockedData;
    private Lockable lock;

    public LockedSet() {
        this(new HashSet());
    }

    public LockedSet(Set set) {
        this(set, new LockSupport());
    }

    public LockedSet(Set set, Lockable lockable) {
        this.lockedData = set;
        this.lock = lockable;
    }

    public void sharedLock() {
        this.lock.sharedLock();
    }

    public void exclusiveLock() {
        this.lock.exclusiveLock();
    }

    public void releaseSharedLock() {
        this.lock.releaseSharedLock();
    }

    public boolean releaseExclusiveLock() {
        return this.lock.releaseExclusiveLock();
    }

    public boolean tryExclusiveLock() {
        return this.lock.tryExclusiveLock();
    }

    public boolean trySharedLock() {
        return this.lock.trySharedLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object object) {
        this.lock.exclusiveLock();
        try {
            boolean bl = this.lockedData.add(object);
            return bl;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(DataStructure dataStructure) {
        this.lock.exclusiveLock();
        try {
            boolean bl = this.lockedData.addAll(dataStructure);
            return bl;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.exclusiveLock();
        try {
            this.lockedData.clear();
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        this.lock.sharedLock();
        try {
            boolean bl = this.lockedData.contains(object);
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(DataStructure dataStructure) {
        this.lock.sharedLock();
        try {
            boolean bl = this.lockedData.containsAll(dataStructure);
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.lock.sharedLock();
        try {
            boolean bl = this.lockedData.isEmpty();
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    public Iterator iterator() {
        return this.lockedData.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object object) {
        this.lock.exclusiveLock();
        try {
            boolean bl = this.lockedData.remove(object);
            return bl;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock.sharedLock();
        try {
            int n = this.lockedData.size();
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        this.lock.sharedLock();
        try {
            Object[] objectArray = this.lockedData.toArray();
            return objectArray;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] objectArray) {
        this.lock.sharedLock();
        try {
            Object[] objectArray2 = this.lockedData.toArray(objectArray);
            return objectArray2;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        this.lock.sharedLock();
        try {
            int n = this.lockedData.hashCode();
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        this.lock.sharedLock();
        try {
            boolean bl = this.lockedData.equals(object);
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.sharedLock();
        try {
            String string = this.lockedData.toString();
            return string;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }
}

