/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.structures;

import org.ws4d.java.concurrency.LockSupport;
import org.ws4d.java.concurrency.Lockable;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.Iterator;

public class LockedStructure
extends DataStructure
implements Lockable {
    DataStructure dataToSynchronize;
    Lockable lock;

    public LockedStructure(DataStructure dataStructure, Lockable lockable) {
        this.dataToSynchronize = dataStructure;
        this.lock = lockable;
    }

    public LockedStructure(DataStructure dataStructure) {
        this.dataToSynchronize = dataStructure;
        this.lock = new LockSupport();
    }

    public void sharedLock() {
        this.lock.sharedLock();
    }

    public void exclusiveLock() {
        this.lock.exclusiveLock();
    }

    public void releaseSharedLock() {
        this.lock.releaseSharedLock();
    }

    public boolean releaseExclusiveLock() {
        return this.lock.releaseExclusiveLock();
    }

    public boolean tryExclusiveLock() {
        return this.lock.tryExclusiveLock();
    }

    public boolean trySharedLock() {
        return this.lock.trySharedLock();
    }

    public Iterator iterator() {
        return this.dataToSynchronize.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock.sharedLock();
        try {
            int n = this.dataToSynchronize.size();
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        this.lock.sharedLock();
        try {
            boolean bl = this.dataToSynchronize.contains(object);
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object object) {
        this.lock.exclusiveLock();
        try {
            boolean bl = this.dataToSynchronize.remove(object);
            return bl;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.exclusiveLock();
        try {
            this.dataToSynchronize.clear();
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object object) {
        this.lock.exclusiveLock();
        try {
            boolean bl = this.dataToSynchronize.add(object);
            return bl;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(DataStructure dataStructure) {
        this.lock.exclusiveLock();
        try {
            boolean bl = this.dataToSynchronize.addAll(dataStructure);
            return bl;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(DataStructure dataStructure) {
        this.lock.sharedLock();
        try {
            boolean bl = this.dataToSynchronize.containsAll(dataStructure);
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.lock.sharedLock();
        try {
            boolean bl = this.dataToSynchronize.isEmpty();
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        this.lock.sharedLock();
        try {
            Object[] objectArray = this.dataToSynchronize.toArray();
            return objectArray;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] objectArray) {
        this.lock.sharedLock();
        try {
            Object[] objectArray2 = this.dataToSynchronize.toArray(objectArray);
            return objectArray2;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        this.lock.sharedLock();
        try {
            int n = this.dataToSynchronize.hashCode();
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        this.lock.sharedLock();
        try {
            boolean bl = this.dataToSynchronize.equals(object);
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.sharedLock();
        try {
            String string = this.dataToSynchronize.toString();
            return string;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }
}

