/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.types;

import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.ReadOnlyIterator;
import org.ws4d.java.structures.Set;
import org.ws4d.java.structures.UnsupportedOperationException;
import org.ws4d.java.types.AttributedURI;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.EprInfo;
import org.ws4d.java.types.URISet;

public class EprInfoSet {
    private Set infosets = null;
    private boolean readOnly = false;

    public EprInfoSet() {
        this.infosets = new HashSet();
    }

    public EprInfoSet(int n) {
        this.infosets = new HashSet(n);
    }

    public EprInfoSet(EprInfo eprInfo) {
        this.infosets = new HashSet(1);
        this.add(eprInfo);
    }

    public EprInfoSet(EprInfoSet eprInfoSet) {
        this(eprInfoSet == null ? 1 : eprInfoSet.size());
        this.addAll(eprInfoSet);
    }

    public Iterator iterator() {
        if (this.readOnly) {
            return new ReadOnlyIterator(this.infosets);
        }
        return this.infosets.iterator();
    }

    public EprInfo[] toArray() {
        EprInfo[] eprInfoArray = new EprInfo[this.infosets.size()];
        Object[] objectArray = this.infosets.toArray();
        for (int i = 0; i < eprInfoArray.length; ++i) {
            eprInfoArray[i] = (EprInfo)objectArray[i];
        }
        return eprInfoArray;
    }

    public boolean contains(EprInfo eprInfo) {
        return this.infosets.contains(eprInfo);
    }

    public boolean containsAll(EprInfoSet eprInfoSet) {
        if (eprInfoSet == null) {
            return true;
        }
        Iterator iterator = eprInfoSet.iterator();
        while (iterator.hasNext()) {
            if (this.infosets.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.infosets.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.infosets.iterator();
        while (iterator.hasNext()) {
            EprInfo eprInfo = (EprInfo)iterator.next();
            stringBuffer.append(eprInfo.toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof URISet) {
            bl = this.equals((EprInfoSet)object);
        }
        return bl;
    }

    public int hashCode() {
        return this.infosets.hashCode();
    }

    public boolean equals(EprInfoSet eprInfoSet) {
        if (eprInfoSet != null) {
            return this.infosets.equals(eprInfoSet);
        }
        return false;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public synchronized boolean containsEprAddress(AttributedURI attributedURI) {
        Iterator iterator = this.infosets.iterator();
        while (iterator.hasNext()) {
            AttributedURI attributedURI2;
            EndpointReference endpointReference = ((EprInfo)iterator.next()).getEndpointReference();
            if (endpointReference == null || (attributedURI2 = endpointReference.getAddress()) == null || !attributedURI2.equals(attributedURI)) continue;
            return true;
        }
        return false;
    }

    public void add(EprInfo eprInfo) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Set is read-only.");
        }
        if (eprInfo != null) {
            this.infosets.add(eprInfo);
        }
    }

    public void addAll(EprInfoSet eprInfoSet) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Set status is read-only.");
        }
        if (eprInfoSet == null) {
            return;
        }
        this.infosets.addAll(eprInfoSet.infosets);
    }

    public boolean remove(EprInfo eprInfo) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Set status is read-only.");
        }
        return this.infosets.remove(eprInfo);
    }
}

